/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

final class MethodInvocation {
    private static final String TAG = "MethodInvocation";
    private static final Cache<MethodKey, Method> methodCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    private final Class<?> clazz;
    private final Object instance;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    /*
     * Enabled aggressive block sorting
     */
    public MethodInvocation(Class<?> clazz, Object object, String string, Class<?> ... classArray) {
        this.clazz = Preconditions.checkNotNull(clazz, "clazz cannot be null!");
        this.instance = object;
        boolean bl = string != null && !string.isEmpty();
        Preconditions.checkArgument(bl, "methodName cannot be null or empty");
        this.methodName = string;
        this.parameterTypes = classArray;
    }

    private static Method getMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, false);
    }

    private static Method getDeclaredMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Method getMethodInternal(MethodKey object, boolean bl) throws NoSuchMethodException {
        void var1_4;
        void var0_2;
        Object[] objectArray = methodCache.getIfPresent(object);
        if (objectArray != null) {
            Object[] objectArray2 = new Object[]{((MethodKey)object).type.getSimpleName(), ((MethodKey)object).methodName, Arrays.toString(((MethodKey)object).parameterTypes)};
            LogUtil.logDebug((String)TAG, (String)"Cache hit for method: %s#%s(%s).", (Object[])objectArray2);
            Object[] objectArray3 = objectArray;
            return var0_2;
        }
        objectArray = new Object[]{((MethodKey)object).type.getSimpleName(), ((MethodKey)object).methodName, Arrays.toString(((MethodKey)object).parameterTypes)};
        LogUtil.logDebug((String)TAG, (String)"Cache miss for method: %s#%s(%s). Loading into cache.", (Object[])objectArray);
        Method method = var1_4 != false ? ((MethodKey)object).type.getDeclaredMethod(((MethodKey)object).methodName, ((MethodKey)object).parameterTypes) : ((MethodKey)object).type.getMethod(((MethodKey)object).methodName, ((MethodKey)object).parameterTypes);
        methodCache.put((MethodKey)object, method);
        Method method2 = method;
        return var0_2;
    }

    public static void invalidateCache() {
        methodCache.invalidateAll();
    }

    public Object invokeDeclaredMethod(Object ... object) {
        try {
            MethodKey methodKey = new MethodKey(this.clazz, this.methodName, this.parameterTypes);
            object = this.invokeMethodExplosively(MethodInvocation.getDeclaredMethod(methodKey), object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.methodName, Arrays.asList(this.parameterTypes), this.clazz.getName(), Arrays.asList(this.clazz.getDeclaredMethods())};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, "No method: %s(%s) found for clazz: %s Available methods: %s", objectArray), noSuchMethodException);
            throw remoteProtocolException;
        }
        return object;
    }

    public Object invokeMethod(Object ... object) {
        try {
            MethodKey methodKey = new MethodKey(this.clazz, this.methodName, this.parameterTypes);
            object = this.invokeMethodExplosively(MethodInvocation.getMethod(methodKey), object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.methodName, this.clazz.getName(), Arrays.asList(this.clazz.getMethods())};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, "No method: %s found for clazz: %s. Available methods: %s", objectArray), noSuchMethodException);
            throw remoteProtocolException;
        }
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeMethodExplosively(Method objectArray, Object ... objectArray2) {
        Object object;
        try {
            objectArray.setAccessible(true);
            object = objectArray.invoke(this.instance, objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Object[] objectArray3;
            String string;
            Locale locale;
            Locale locale2 = Locale.ROOT;
            Object[] objectArray4 = new Object[]{objectArray, Arrays.toString(objectArray2), this.clazz.getName()};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale2, "Cannot invoke method %s with args [%s] on builder %s", objectArray4), invocationTargetException);
            throw remoteProtocolException;
            catch (IllegalAccessException illegalAccessException) {
                Locale locale3 = Locale.ROOT;
                String string2 = "Cannot create instance of %s";
                Object[] objectArray5 = new Object[]{this.clazz.getName()};
                RemoteProtocolException remoteProtocolException2 = new RemoteProtocolException(String.format(locale3, string2, objectArray5), illegalAccessException);
                throw remoteProtocolException2;
            }
            catch (SecurityException securityException) {
                locale = Locale.ROOT;
                string = "Method not accessible: %s";
                objectArray3 = new Object[1];
            }
            try {
                objectArray3[0] = objectArray.getName();
                RemoteProtocolException remoteProtocolException3 = new RemoteProtocolException(String.format(locale, string, objectArray3), securityException);
                throw remoteProtocolException3;
            }
            catch (Throwable throwable) {
                Object[] objectArray6 = new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(objectArray2)};
                LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])objectArray6);
                throw throwable;
            }
        }
        objectArray = new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString(objectArray2)};
        LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])objectArray);
        return object;
    }

    private static final class MethodKey {
        private final Class<?> type;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        public MethodKey(Class<?> clazz, String string, Class<?>[] classArray) {
            this.type = clazz;
            this.methodName = string;
            this.parameterTypes = classArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (MethodKey)object;
                if (!this.type.equals(((MethodKey)object).type)) {
                    return false;
                }
                if (!this.methodName.equals(((MethodKey)object).methodName)) {
                    return false;
                }
                return Arrays.equals(this.parameterTypes, ((MethodKey)object).parameterTypes);
            }
            return false;
        }

        public int hashCode() {
            return (this.type.hashCode() * 31 + this.methodName.hashCode()) * 31 + Arrays.hashCode(this.parameterTypes);
        }
    }
}

