/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.webkit.WebView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.test.annotation.Beta;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.BoundedMatcher;
import androidx.test.espresso.matcher.HasBackgroundMatcher;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public final class ViewMatchers {
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("\\d+");

    private ViewMatchers() {
    }

    public static org.hamcrest.Matcher<View> isAssignableFrom(Class<? extends View> clazz) {
        IsAssignableFromMatcher isAssignableFromMatcher = new IsAssignableFromMatcher(clazz);
        return isAssignableFromMatcher;
    }

    public static org.hamcrest.Matcher<View> withClassName(org.hamcrest.Matcher<String> matcher) {
        WithClassNameMatcher withClassNameMatcher = new WithClassNameMatcher(Preconditions.checkNotNull(matcher));
        return withClassNameMatcher;
    }

    public static org.hamcrest.Matcher<View> isDisplayed() {
        IsDisplayedMatcher isDisplayedMatcher = new IsDisplayedMatcher();
        return isDisplayedMatcher;
    }

    public static org.hamcrest.Matcher<View> isCompletelyDisplayed() {
        return ViewMatchers.isDisplayingAtLeast(100);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static org.hamcrest.Matcher<View> isDisplayingAtLeast(int n) {
        boolean bl = n <= 100;
        Preconditions.checkState(bl, "Cannot have over 100 percent: %s", n);
        bl = n > 0;
        Preconditions.checkState(bl, "Must have a positive, non-zero value: %s", n);
        return new IsDisplayingAtLeastMatcher(n);
    }

    public static org.hamcrest.Matcher<View> isEnabled() {
        IsEnabledMatcher isEnabledMatcher = new IsEnabledMatcher();
        return isEnabledMatcher;
    }

    public static org.hamcrest.Matcher<View> isFocusable() {
        IsFocusableMatcher isFocusableMatcher = new IsFocusableMatcher();
        return isFocusableMatcher;
    }

    public static org.hamcrest.Matcher<View> isFocused() {
        IsFocusedMatcher isFocusedMatcher = new IsFocusedMatcher();
        return isFocusedMatcher;
    }

    public static org.hamcrest.Matcher<View> hasFocus() {
        HasFocusMatcher hasFocusMatcher = new HasFocusMatcher();
        return hasFocusMatcher;
    }

    public static org.hamcrest.Matcher<View> isSelected() {
        IsSelectedMatcher isSelectedMatcher = new IsSelectedMatcher();
        return isSelectedMatcher;
    }

    public static org.hamcrest.Matcher<View> hasSibling(org.hamcrest.Matcher<View> matcher) {
        HasSiblingMatcher hasSiblingMatcher = new HasSiblingMatcher(Preconditions.checkNotNull(matcher));
        return hasSiblingMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(int n) {
        WithContentDescriptionFromIdMatcher withContentDescriptionFromIdMatcher = new WithContentDescriptionFromIdMatcher(n);
        return withContentDescriptionFromIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(String string) {
        WithContentDescriptionTextMatcher withContentDescriptionTextMatcher = new WithContentDescriptionTextMatcher(Matchers.is((Object)string));
        return withContentDescriptionTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(org.hamcrest.Matcher<? extends CharSequence> matcher) {
        WithContentDescriptionMatcher withContentDescriptionMatcher = new WithContentDescriptionMatcher(Preconditions.checkNotNull(matcher));
        return withContentDescriptionMatcher;
    }

    public static org.hamcrest.Matcher<View> withId(int n) {
        return ViewMatchers.withId((org.hamcrest.Matcher<Integer>)Matchers.is((Object)n));
    }

    public static org.hamcrest.Matcher<View> withId(org.hamcrest.Matcher<Integer> matcher) {
        WithIdMatcher withIdMatcher = new WithIdMatcher(Preconditions.checkNotNull(matcher));
        return withIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withResourceName(String string) {
        return ViewMatchers.withResourceName((org.hamcrest.Matcher<String>)Matchers.is((Object)string));
    }

    public static org.hamcrest.Matcher<View> withResourceName(org.hamcrest.Matcher<String> matcher) {
        WithResourceNameMatcher withResourceNameMatcher = new WithResourceNameMatcher(Preconditions.checkNotNull(matcher));
        return withResourceNameMatcher;
    }

    public static org.hamcrest.Matcher<View> withTagKey(int n) {
        return ViewMatchers.withTagKey(n, Matchers.notNullValue());
    }

    public static org.hamcrest.Matcher<View> withTagKey(int n, org.hamcrest.Matcher<?> matcher) {
        WithTagKeyMatcher withTagKeyMatcher = new WithTagKeyMatcher(n, Preconditions.checkNotNull(matcher));
        return withTagKeyMatcher;
    }

    public static org.hamcrest.Matcher<View> withTagValue(org.hamcrest.Matcher<Object> matcher) {
        WithTagValueMatcher withTagValueMatcher = new WithTagValueMatcher(Preconditions.checkNotNull(matcher));
        return withTagValueMatcher;
    }

    public static org.hamcrest.Matcher<View> withText(String string) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.is((Object)string));
    }

    public static org.hamcrest.Matcher<View> withText(org.hamcrest.Matcher<String> matcher) {
        WithTextMatcher withTextMatcher = new WithTextMatcher(Preconditions.checkNotNull(matcher));
        return withTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withText(int n) {
        WithCharSequenceMatcher withCharSequenceMatcher = new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_TEXT);
        return withCharSequenceMatcher;
    }

    public static org.hamcrest.Matcher<View> withSubstring(String string) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.containsString((String)string));
    }

    public static org.hamcrest.Matcher<View> withHint(String string) {
        return ViewMatchers.withHint((org.hamcrest.Matcher<String>)Matchers.is((Object)Preconditions.checkNotNull(string)));
    }

    public static org.hamcrest.Matcher<View> withHint(org.hamcrest.Matcher<String> matcher) {
        WithHintMatcher withHintMatcher = new WithHintMatcher(Preconditions.checkNotNull(matcher));
        return withHintMatcher;
    }

    public static org.hamcrest.Matcher<View> withHint(int n) {
        WithCharSequenceMatcher withCharSequenceMatcher = new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_HINT);
        return withCharSequenceMatcher;
    }

    public static org.hamcrest.Matcher<View> isChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)true));
    }

    public static org.hamcrest.Matcher<View> isNotChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)false));
    }

    private static <E extends View> org.hamcrest.Matcher<View> withCheckBoxState(org.hamcrest.Matcher<Boolean> matcher) {
        WithCheckBoxStateMatcher withCheckBoxStateMatcher = new WithCheckBoxStateMatcher(matcher);
        return withCheckBoxStateMatcher;
    }

    public static org.hamcrest.Matcher<View> hasContentDescription() {
        HasContentDescriptionMatcher hasContentDescriptionMatcher = new HasContentDescriptionMatcher();
        return hasContentDescriptionMatcher;
    }

    public static org.hamcrest.Matcher<View> hasDescendant(org.hamcrest.Matcher<View> matcher) {
        HasDescendantMatcher hasDescendantMatcher = new HasDescendantMatcher(Preconditions.checkNotNull(matcher));
        return hasDescendantMatcher;
    }

    public static org.hamcrest.Matcher<View> isClickable() {
        IsClickableMatcher isClickableMatcher = new IsClickableMatcher();
        return isClickableMatcher;
    }

    public static org.hamcrest.Matcher<View> isDescendantOfA(org.hamcrest.Matcher<View> matcher) {
        IsDescendantOfAMatcher isDescendantOfAMatcher = new IsDescendantOfAMatcher(Preconditions.checkNotNull(matcher));
        return isDescendantOfAMatcher;
    }

    public static org.hamcrest.Matcher<View> withEffectiveVisibility(Visibility visibility) {
        WithEffectiveVisibilityMatcher withEffectiveVisibilityMatcher = new WithEffectiveVisibilityMatcher(visibility);
        return withEffectiveVisibilityMatcher;
    }

    public static org.hamcrest.Matcher<View> withAlpha(float f) {
        WithAlphaMatcher withAlphaMatcher = new WithAlphaMatcher(f);
        return withAlphaMatcher;
    }

    public static org.hamcrest.Matcher<View> withParent(org.hamcrest.Matcher<View> matcher) {
        WithParentMatcher withParentMatcher = new WithParentMatcher(Preconditions.checkNotNull(matcher));
        return withParentMatcher;
    }

    public static org.hamcrest.Matcher<View> withChild(org.hamcrest.Matcher<View> matcher) {
        WithChildMatcher withChildMatcher = new WithChildMatcher(Preconditions.checkNotNull(matcher));
        return withChildMatcher;
    }

    public static org.hamcrest.Matcher<View> hasChildCount(int n) {
        HasChildCountMatcher hasChildCountMatcher = new HasChildCountMatcher(n);
        return hasChildCountMatcher;
    }

    public static org.hamcrest.Matcher<View> hasMinimumChildCount(int n) {
        HasMinimumChildCountMatcher hasMinimumChildCountMatcher = new HasMinimumChildCountMatcher(n);
        return hasMinimumChildCountMatcher;
    }

    public static org.hamcrest.Matcher<View> isRoot() {
        IsRootMatcher isRootMatcher = new IsRootMatcher();
        return isRootMatcher;
    }

    public static org.hamcrest.Matcher<View> supportsInputMethods() {
        SupportsInputMethodsMatcher supportsInputMethodsMatcher = new SupportsInputMethodsMatcher();
        return supportsInputMethodsMatcher;
    }

    public static org.hamcrest.Matcher<View> hasImeAction(int n) {
        return ViewMatchers.hasImeAction((org.hamcrest.Matcher<Integer>)Matchers.is((Object)n));
    }

    public static org.hamcrest.Matcher<View> hasImeAction(org.hamcrest.Matcher<Integer> matcher) {
        HasImeActionMatcher hasImeActionMatcher = new HasImeActionMatcher(matcher);
        return hasImeActionMatcher;
    }

    public static org.hamcrest.Matcher<View> hasLinks() {
        HasLinksMatcher hasLinksMatcher = new HasLinksMatcher();
        return hasLinksMatcher;
    }

    public static <T> void assertThat(T t, org.hamcrest.Matcher<T> matcher) {
        ViewMatchers.assertThat("", t, matcher);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> void assertThat(String string, T t, org.hamcrest.Matcher<T> matcher) {
        if (matcher.matches(t)) {
            return;
        }
        StringDescription stringDescription = new StringDescription();
        stringDescription.appendText(string).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     Got: ");
        if (t instanceof View) {
            stringDescription.appendValue((Object)HumanReadables.describe((View)t));
        } else {
            stringDescription.appendValue(t);
        }
        stringDescription.appendText("\n");
        string = new AssertionFailedError(stringDescription.toString());
        throw string;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(int n) {
        WithSpinnerTextIdMatcher withSpinnerTextIdMatcher = new WithSpinnerTextIdMatcher(n);
        return withSpinnerTextIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(org.hamcrest.Matcher<String> matcher) {
        WithSpinnerTextMatcher withSpinnerTextMatcher = new WithSpinnerTextMatcher(Preconditions.checkNotNull(matcher));
        return withSpinnerTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(String string) {
        return ViewMatchers.withSpinnerText((org.hamcrest.Matcher<String>)Matchers.is((Object)string));
    }

    public static org.hamcrest.Matcher<View> isJavascriptEnabled() {
        IsJavascriptEnabledMatcher isJavascriptEnabledMatcher = new IsJavascriptEnabledMatcher();
        return isJavascriptEnabledMatcher;
    }

    public static org.hamcrest.Matcher<View> hasErrorText(org.hamcrest.Matcher<String> matcher) {
        HasErrorTextMatcher hasErrorTextMatcher = new HasErrorTextMatcher(Preconditions.checkNotNull(matcher));
        return hasErrorTextMatcher;
    }

    public static org.hamcrest.Matcher<View> hasErrorText(String string) {
        return ViewMatchers.hasErrorText((org.hamcrest.Matcher<String>)Matchers.is((Object)string));
    }

    public static org.hamcrest.Matcher<View> withInputType(int n) {
        WithInputTypeMatcher withInputTypeMatcher = new WithInputTypeMatcher(n);
        return withInputTypeMatcher;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static org.hamcrest.Matcher<View> withParentIndex(int n) {
        boolean bl = n >= 0;
        Preconditions.checkArgument(bl, "Index %s must be >= 0", n);
        return new WithParentIndexMatcher(n);
    }

    @Beta
    public static org.hamcrest.Matcher<View> hasBackground(int n) {
        HasBackgroundMatcher hasBackgroundMatcher = new HasBackgroundMatcher(n);
        return hasBackgroundMatcher;
    }

    @Beta
    public static org.hamcrest.Matcher<View> hasTextColor(final int n) {
        BoundedMatcher<View, TextView> boundedMatcher = new BoundedMatcher<View, TextView>(TextView.class){
            private Context context;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            protected boolean matchesSafely(TextView textView) {
                this.context = textView.getContext();
                int n2 = textView.getCurrentTextColor();
                boolean bl = Build.VERSION.SDK_INT <= 22 ? this.context.getResources().getColor(n) : this.context.getColor(n);
                if (n2 != bl) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void describeTo(Description description) {
                String string = String.valueOf(object.n);
                Object object = object.context != null ? object.context.getResources().getResourceName(object.n) : string;
                object = String.valueOf(object);
                string = "has color with ID ";
                object = ((String)object).length() == 0 ? new String(string) : string.concat((String)object);
                description.appendText((String)object);
            }
        };
        return boundedMatcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewIdGenerated(int n) {
        if ((n & 0xFF000000) != 0) return 0 != 0;
        if ((n & 0xFFFFFF) == 0) return 0 != 0;
        return 1 != 0;
    }

    static final class WithParentIndexMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int index;

        @RemoteMsgConstructor
        private WithParentIndexMatcher(int n) {
            this.index = n;
        }

        public void describeTo(Description description) {
            int n = this.index;
            StringBuilder stringBuilder = new StringBuilder(30);
            description.appendText(stringBuilder.append("with parent index: ").append(n).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            ViewParent viewParent = view.getParent();
            if (!(viewParent instanceof ViewGroup)) return false;
            if (((ViewGroup)viewParent).getChildCount() <= this.index) return false;
            if (((ViewGroup)viewParent).getChildAt(this.index) != view) return false;
            return true;
        }
    }

    static final class WithInputTypeMatcher
    extends BoundedMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private int inputType;

        @RemoteMsgConstructor
        private WithInputTypeMatcher(int n) {
            super(EditText.class);
            this.inputType = n;
        }

        public void describeTo(Description description) {
            description.appendText("is view input type equal to: ");
            description.appendText(Integer.toString(this.inputType));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchesSafely(EditText editText) {
            if (editText.getInputType() != this.inputType) return false;
            return true;
        }
    }

    static final class HasErrorTextMatcher
    extends BoundedMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private HasErrorTextMatcher(org.hamcrest.Matcher<String> matcher) {
            super(EditText.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with error: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(EditText editText) {
            return this.stringMatcher.matches((Object)editText.getError());
        }
    }

    static final class IsJavascriptEnabledMatcher
    extends BoundedMatcher<View, WebView> {
        @RemoteMsgConstructor
        private IsJavascriptEnabledMatcher() {
            super(WebView.class);
        }

        public void describeTo(Description description) {
            description.appendText("WebView with JS enabled");
        }

        @Override
        public boolean matchesSafely(WebView webView) {
            return webView.getSettings().getJavaScriptEnabled();
        }
    }

    static final class WithSpinnerTextMatcher
    extends BoundedMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithSpinnerTextMatcher(org.hamcrest.Matcher<String> matcher) {
            super(Spinner.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with text: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(Spinner spinner) {
            return this.stringMatcher.matches((Object)spinner.getSelectedItem().toString());
        }
    }

    static final class WithSpinnerTextIdMatcher
    extends BoundedMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithSpinnerTextIdMatcher(int n) {
            super(Spinner.class);
            this.resourceId = n;
        }

        public void describeTo(Description description) {
            description.appendText("with string from resource id: ");
            description.appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                description.appendText("[");
                description.appendText(this.resourceName);
                description.appendText("]");
            }
            if (this.expectedText != null) {
                description.appendText(" value: ");
                description.appendText(this.expectedText);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matchesSafely(Spinner spinner) {
            if (this.expectedText == null) {
                try {
                    this.expectedText = spinner.getResources().getString(this.resourceId);
                    this.resourceName = spinner.getResources().getResourceEntryName(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {}
            }
            if (this.expectedText != null) {
                return this.expectedText.equals(spinner.getSelectedItem().toString());
            }
            return false;
        }
    }

    static final class HasLinksMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgConstructor
        private HasLinksMatcher() {
            super(TextView.class);
        }

        public void describeTo(Description description) {
            description.appendText("has links");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matchesSafely(TextView textView) {
            if (textView.getUrls().length <= 0) return false;
            return true;
        }
    }

    static final class HasImeActionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Integer> imeActionMatcher;

        @RemoteMsgConstructor
        private HasImeActionMatcher(org.hamcrest.Matcher<Integer> matcher) {
            this.imeActionMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has ime action: ");
            this.imeActionMatcher.describeTo(description);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            int n;
            EditorInfo editorInfo = new EditorInfo();
            if (view.onCreateInputConnection(editorInfo) == null) {
                return false;
            }
            if (editorInfo.actionId != 0) {
                n = editorInfo.actionId;
                return this.imeActionMatcher.matches((Object)n);
            }
            n = editorInfo.imeOptions & 0xFF;
            return this.imeActionMatcher.matches((Object)n);
        }
    }

    static final class SupportsInputMethodsMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private SupportsInputMethodsMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("supports input methods");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            SupportsInputMethodsMatcher supportsInputMethodsMatcher = new EditorInfo();
            if (view.onCreateInputConnection((EditorInfo)supportsInputMethodsMatcher) == null) return false;
            return true;
        }
    }

    static final class IsRootMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsRootMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is a root view.");
        }

        public boolean matchesSafely(View view) {
            return view.getRootView().equals(view);
        }
    }

    static final class HasMinimumChildCountMatcher
    extends BoundedMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int minChildCount;

        @RemoteMsgConstructor
        private HasMinimumChildCountMatcher(int n) {
            super(ViewGroup.class);
            this.minChildCount = n;
        }

        public void describeTo(Description description) {
            description.appendText("has minimum child count: ").appendValue((Object)this.minChildCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matchesSafely(ViewGroup viewGroup) {
            if (viewGroup.getChildCount() < this.minChildCount) return false;
            return true;
        }
    }

    static final class HasChildCountMatcher
    extends BoundedMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int childCount;

        @RemoteMsgConstructor
        private HasChildCountMatcher(int n) {
            super(ViewGroup.class);
            this.childCount = n;
        }

        public void describeTo(Description description) {
            description.appendText("has child count: ").appendValue((Object)this.childCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matchesSafely(ViewGroup viewGroup) {
            if (viewGroup.getChildCount() != this.childCount) return false;
            return true;
        }
    }

    static final class WithChildMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> childMatcher;

        @RemoteMsgConstructor
        private WithChildMatcher(org.hamcrest.Matcher<View> matcher) {
            this.childMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has child: ");
            this.childMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            if (!(view instanceof ViewGroup)) {
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (!this.childMatcher.matches((Object)viewGroup.getChildAt(i))) {
                    continue;
                }
                return true;
            }
            return false;
        }
    }

    static final class WithParentMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> parentMatcher;

        @RemoteMsgConstructor
        private WithParentMatcher(org.hamcrest.Matcher<View> matcher) {
            this.parentMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has parent matching: ");
            this.parentMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.parentMatcher.matches((Object)view.getParent());
        }
    }

    static final class WithAlphaMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final float alpha;

        @RemoteMsgConstructor
        private WithAlphaMatcher(float f) {
            this.alpha = f;
        }

        public void describeTo(Description description) {
            description.appendText("has alpha: ").appendValue((Object)Float.valueOf(this.alpha));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            if (view.getAlpha() != this.alpha) return false;
            return true;
        }
    }

    static final class WithEffectiveVisibilityMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Visibility visibility;

        @RemoteMsgConstructor
        private WithEffectiveVisibilityMatcher(Visibility visibility) {
            this.visibility = visibility;
        }

        public void describeTo(Description description) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.visibility};
            description.appendText(String.format(locale, "view has effective visibility=%s", objectArray));
        }

        public boolean matchesSafely(View view) {
            if (this.visibility.getValue() == 0) {
                if (view.getVisibility() == this.visibility.getValue()) {
                    while (view.getParent() != null && view.getParent() instanceof View) {
                        if ((view = (View)view.getParent()).getVisibility() == this.visibility.getValue()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (view.getVisibility() != this.visibility.getValue()) {
                while (view.getParent() != null && view.getParent() instanceof View) {
                    if ((view = (View)view.getParent()).getVisibility() != this.visibility.getValue()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    static final class IsDescendantOfAMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> ancestorMatcher;

        @RemoteMsgConstructor
        private IsDescendantOfAMatcher(org.hamcrest.Matcher<View> matcher) {
            this.ancestorMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("is descendant of a: ");
            this.ancestorMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.checkAncestors(view.getParent(), this.ancestorMatcher);
        }

        private boolean checkAncestors(ViewParent viewParent, org.hamcrest.Matcher<View> matcher) {
            if (!(viewParent instanceof View)) {
                return false;
            }
            if (matcher.matches((Object)viewParent)) {
                return true;
            }
            return this.checkAncestors(viewParent.getParent(), matcher);
        }
    }

    static final class IsClickableMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsClickableMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is clickable");
        }

        public boolean matchesSafely(View view) {
            return view.isClickable();
        }
    }

    static final class HasDescendantMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> descendantMatcher;

        @RemoteMsgConstructor
        private HasDescendantMatcher(org.hamcrest.Matcher<View> matcher) {
            this.descendantMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has descendant: ");
            this.descendantMatcher.describeTo(description);
        }

        public boolean matchesSafely(final View view) {
            Predicate<View> predicate = new Predicate<View>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean apply(View view2) {
                    if (view2 == view) return false;
                    if (!descendantMatcher.matches((Object)view2)) return false;
                    return true;
                }
            };
            return Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator().hasNext();
        }
    }

    static final class HasContentDescriptionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private HasContentDescriptionMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("has content description");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            if (view.getContentDescription() == null) return false;
            return true;
        }
    }

    static final class WithCheckBoxStateMatcher<E extends View>
    extends BoundedMatcher<View, E> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Boolean> checkStateMatcher;

        @RemoteMsgConstructor
        private WithCheckBoxStateMatcher(org.hamcrest.Matcher<Boolean> matcher) {
            super(View.class, Checkable.class, new Class[0]);
            this.checkStateMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with checkbox state: ");
            this.checkStateMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(E e) {
            return this.checkStateMatcher.matches((Object)((Checkable)e).isChecked());
        }
    }

    static final class WithHintMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithHintMatcher(org.hamcrest.Matcher<String> matcher) {
            super(TextView.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with hint: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        public boolean matchesSafely(TextView textView) {
            return this.stringMatcher.matches((Object)textView.getHint());
        }
    }

    static final class WithCharSequenceMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        @RemoteMsgField(order=1)
        private final TextViewMethod method;
        private String resourceName;
        private String expectedText;

        @RemoteMsgConstructor
        private WithCharSequenceMatcher(int n, TextViewMethod textViewMethod) {
            super(TextView.class);
            this.resourceId = n;
            this.method = textViewMethod;
        }

        public void describeTo(Description description) {
            description.appendText("with string from resource id: ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                description.appendText("[").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                description.appendText(" value: ").appendText(this.expectedText);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matchesSafely(TextView object) {
            if (((WithCharSequenceMatcher)((Object)object2)).expectedText == null) {
                try {
                    ((WithCharSequenceMatcher)((Object)object2)).expectedText = object.getResources().getString(((WithCharSequenceMatcher)((Object)object2)).resourceId);
                    ((WithCharSequenceMatcher)((Object)object2)).resourceName = object.getResources().getResourceEntryName(((WithCharSequenceMatcher)((Object)object2)).resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {}
            }
            switch (2.$SwitchMap$androidx$test$espresso$matcher$ViewMatchers$WithCharSequenceMatcher$TextViewMethod[((WithCharSequenceMatcher)((Object)object2)).method.ordinal()]) {
                default: {
                    Object object2 = String.valueOf(((WithCharSequenceMatcher)((Object)object2)).method.toString());
                    String string = "Unexpected TextView method: ";
                    object2 = ((String)object2).length() == 0 ? new String(string) : string.concat((String)object2);
                }
                case 2: {
                    object = object.getHint();
                    break;
                }
                case 1: {
                    object = object.getText();
                    break;
                }
            }
            if (((WithCharSequenceMatcher)((Object)object2)).expectedText == null) return false;
            if (object == null) return false;
            if (((WithCharSequenceMatcher)((Object)object2)).expectedText.equals(object.toString())) return true;
            return false;
            object = new IllegalStateException((String)object2);
            throw object;
        }

        private static final class TextViewMethod
        extends Enum<TextViewMethod> {
            public static final /* enum */ TextViewMethod GET_TEXT;
            public static final /* enum */ TextViewMethod GET_HINT;
            private static final /* synthetic */ TextViewMethod[] $VALUES;

            public static TextViewMethod[] values() {
                return (TextViewMethod[])$VALUES.clone();
            }

            public static TextViewMethod valueOf(String string) {
                return Enum.valueOf(TextViewMethod.class, string);
            }

            static {
                TextViewMethod[] textViewMethodArray = new TextViewMethod();
                GET_TEXT = textViewMethodArray;
                textViewMethodArray = new TextViewMethod();
                GET_HINT = textViewMethodArray;
                textViewMethodArray = new TextViewMethod[]{GET_TEXT, GET_HINT};
                $VALUES = textViewMethodArray;
            }
        }
    }

    static final class WithTagValueMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Object> tagValueMatcher;

        @RemoteMsgConstructor
        private WithTagValueMatcher(org.hamcrest.Matcher<Object> matcher) {
            this.tagValueMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with tag value: ");
            this.tagValueMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.tagValueMatcher.matches(view.getTag());
        }
    }

    static final class WithContentDescriptionTextMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> textMatcher;

        @RemoteMsgConstructor
        private WithContentDescriptionTextMatcher(org.hamcrest.Matcher<String> matcher) {
            this.textMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with content description text: ");
            this.textMatcher.describeTo(description);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View object) {
            void var1_3;
            if (object.getContentDescription() == null) return this.textMatcher.matches((Object)var1_3);
            String string = object.getContentDescription().toString();
            return this.textMatcher.matches((Object)var1_3);
        }
    }

    static final class WithContentDescriptionMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher;

        @RemoteMsgConstructor
        private WithContentDescriptionMatcher(org.hamcrest.Matcher<? extends CharSequence> matcher) {
            this.charSequenceMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with content description: ");
            this.charSequenceMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.charSequenceMatcher.matches((Object)view.getContentDescription());
        }
    }

    static final class WithContentDescriptionFromIdMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        @RemoteMsgConstructor
        private WithContentDescriptionFromIdMatcher(int n) {
            this.resourceId = n;
        }

        public void describeTo(Description description) {
            description.appendText("with content description from resource id: ");
            description.appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                description.appendText("[");
                description.appendText(this.resourceName);
                description.appendText("]");
            }
            if (this.expectedText != null) {
                description.appendText(" value: ");
                description.appendText(this.expectedText);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean matchesSafely(View view) {
            if (this.expectedText == null) {
                try {
                    this.expectedText = view.getResources().getString(this.resourceId);
                    this.resourceName = view.getResources().getResourceEntryName(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {}
            }
            if (this.expectedText != null && view.getContentDescription() != null) {
                return this.expectedText.equals(view.getContentDescription().toString());
            }
            return false;
        }
    }

    static final class HasSiblingMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> siblingMatcher;

        @RemoteMsgConstructor
        private HasSiblingMatcher(org.hamcrest.Matcher<View> matcher) {
            this.siblingMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has sibling: ");
            this.siblingMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            if (!((view = view.getParent()) instanceof ViewGroup)) {
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (!this.siblingMatcher.matches((Object)viewGroup.getChildAt(i))) {
                    continue;
                }
                return true;
            }
            return false;
        }
    }

    static final class IsSelectedMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsSelectedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is selected");
        }

        public boolean matchesSafely(View view) {
            return view.isSelected();
        }
    }

    static final class HasFocusMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private HasFocusMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("has focus on the screen to the user");
        }

        public boolean matchesSafely(View view) {
            return view.hasFocus();
        }
    }

    static final class IsFocusedMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsFocusedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is focused");
        }

        public boolean matchesSafely(View view) {
            return view.isFocused();
        }
    }

    static final class IsFocusableMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsFocusableMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is focusable");
        }

        public boolean matchesSafely(View view) {
            return view.isFocusable();
        }
    }

    static final class IsEnabledMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsEnabledMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is enabled");
        }

        public boolean matchesSafely(View view) {
            return view.isEnabled();
        }
    }

    static final class IsDisplayingAtLeastMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        final int areaPercentage;

        @RemoteMsgConstructor
        private IsDisplayingAtLeastMatcher(int n) {
            this.areaPercentage = n;
        }

        public void describeTo(Description description) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.areaPercentage};
            description.appendText(String.format(locale, "at least %s percent of the view's area is displayed to the user.", objectArray));
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesSafely(View view) {
            float f;
            Rect rect = new Rect();
            if (!view.getGlobalVisibleRect(rect)) {
                return false;
            }
            Rect rect2 = this.getScreenWithoutStatusBarActionBar(view);
            float f2 = view.getHeight() > rect2.height() ? (float)rect2.height() : (float)view.getHeight();
            float f3 = view.getWidth() > rect2.width() ? (float)rect2.width() : (float)view.getWidth();
            if (Build.VERSION.SDK_INT >= 11) {
                f2 = Math.min((float)view.getHeight() * Math.abs(view.getScaleY()), (float)rect2.height());
                f = Math.min((float)view.getWidth() * Math.abs(view.getScaleX()), (float)rect2.width());
            } else {
                f = f3;
            }
            if ((int)((double)(rect.height() * rect.width()) / (double)(f2 * f) * 100.0) < this.areaPercentage) return false;
            if (!ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE).matches((Object)view)) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Rect getScreenWithoutStatusBarActionBar(View view) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)view.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n = view.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
            n = n > 0 ? view.getContext().getResources().getDimensionPixelSize(n) : 0;
            TypedValue typedValue = new TypedValue();
            int n2 = view.getContext().getTheme().resolveAttribute(16843499, typedValue, true) ? TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)view.getContext().getResources().getDisplayMetrics()) : 0;
            return new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels - (n + n2));
        }
    }

    static final class IsDisplayedMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        private IsDisplayedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is displayed on the screen to the user");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            IsDisplayedMatcher isDisplayedMatcher = new Rect();
            if (!view.getGlobalVisibleRect((Rect)isDisplayedMatcher)) return false;
            if (!ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE).matches((Object)view)) return false;
            return true;
        }
    }

    static final class WithClassNameMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        final org.hamcrest.Matcher<String> classNameMatcher;

        @RemoteMsgConstructor
        private WithClassNameMatcher(org.hamcrest.Matcher<String> matcher) {
            this.classNameMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with class name: ");
            this.classNameMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.classNameMatcher.matches((Object)view.getClass().getName());
        }
    }

    static final class IsAssignableFromMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final Class<?> clazz;

        @RemoteMsgConstructor
        private IsAssignableFromMatcher(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        public void describeTo(Description description) {
            Object object = String.valueOf(object.clazz);
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 26);
            description.appendText(stringBuilder.append("is assignable from class: ").append((String)object).toString());
        }

        public boolean matchesSafely(View view) {
            return this.clazz.isAssignableFrom(view.getClass());
        }
    }

    static final class WithTagKeyMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final int key;
        @RemoteMsgField(order=1)
        private final org.hamcrest.Matcher<?> objectMatcher;

        @RemoteMsgConstructor
        private WithTagKeyMatcher(int n, org.hamcrest.Matcher<?> matcher) {
            this.key = n;
            this.objectMatcher = matcher;
        }

        public void describeTo(Description description) {
            int n = this.key;
            StringBuilder stringBuilder = new StringBuilder(21);
            description.appendText(stringBuilder.append("with key: ").append(n).toString());
            this.objectMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            return this.objectMatcher.matches(view.getTag(this.key));
        }
    }

    static final class WithResourceNameMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithResourceNameMatcher(org.hamcrest.Matcher<String> matcher) {
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with res-name that ");
            this.stringMatcher.describeTo(description);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(View view) {
            if (view.getId() == -1) return false;
            if (view.getResources() == null) return false;
            if (ViewMatchers.isViewIdGenerated(view.getId())) return false;
            try {
                return this.stringMatcher.matches((Object)view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {
                return false;
            }
        }
    }

    static final class WithTextMatcher
    extends BoundedMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        @RemoteMsgConstructor
        private WithTextMatcher(org.hamcrest.Matcher<String> matcher) {
            super(TextView.class);
            this.stringMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with text: ");
            this.stringMatcher.describeTo(description);
        }

        @Override
        protected boolean matchesSafely(TextView object) {
            String string = object.getText().toString();
            if (this.stringMatcher.matches((Object)string)) {
                return true;
            }
            if (object.getTransformationMethod() != null && (object = object.getTransformationMethod().getTransformation((CharSequence)string, (View)object)) != null) {
                return this.stringMatcher.matches((Object)object.toString());
            }
            return false;
        }
    }

    static final class WithIdMatcher
    extends TypeSafeMatcher<View> {
        @RemoteMsgField(order=0)
        org.hamcrest.Matcher<Integer> viewIdMatcher;
        private Resources resources;

        @RemoteMsgConstructor
        private WithIdMatcher(org.hamcrest.Matcher<Integer> matcher) {
            this.viewIdMatcher = matcher;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void describeTo(Description description) {
            String string = this.viewIdMatcher.toString();
            Matcher matcher = RESOURCE_ID_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            while (true) {
                if (!matcher.find()) {
                    matcher.appendTail(stringBuffer);
                    description.appendText("with id ").appendText(stringBuffer.toString());
                    return;
                }
                if (this.resources == null) continue;
                string = matcher.group();
                int n = Integer.parseInt(string);
                try {
                    matcher.appendReplacement(stringBuffer, this.resources.getResourceName(n));
                    continue;
                }
                catch (Resources.NotFoundException notFoundException) {
                    Locale locale = Locale.ROOT;
                    Object[] objectArray = new Object[]{string};
                    matcher.appendReplacement(stringBuffer, String.format(locale, "%s (resource name not found)", objectArray));
                    continue;
                }
                break;
            }
        }

        public boolean matchesSafely(View view) {
            this.resources = view.getResources();
            return this.viewIdMatcher.matches((Object)view.getId());
        }
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility VISIBLE;
        public static final /* enum */ Visibility INVISIBLE;
        public static final /* enum */ Visibility GONE;
        private final int value;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        static {
            Visibility[] visibilityArray = new Visibility(0);
            VISIBLE = visibilityArray;
            visibilityArray = new Visibility(4);
            INVISIBLE = visibilityArray;
            visibilityArray = new Visibility(8);
            GONE = visibilityArray;
            visibilityArray = new Visibility[]{VISIBLE, INVISIBLE, GONE};
            $VALUES = visibilityArray;
        }
    }
}

