/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.app.Activity;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.Root;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class RootMatchers {
    private static final String TAG = "RootMatchers";
    public static final Matcher<Root> DEFAULT = Matchers.allOf(RootMatchers.hasWindowLayoutParams(), (Matcher)Matchers.allOf((Matcher)Matchers.anyOf((Matcher)Matchers.allOf(RootMatchers.isDialog(), RootMatchers.withDecorView(RootMatchers.hasWindowFocus())), RootMatchers.isSubwindowOfCurrentActivity()), RootMatchers.isFocusable()));

    private RootMatchers() {
    }

    public static Matcher<Root> isFocusable() {
        IsFocusable isFocusable = new IsFocusable();
        return isFocusable;
    }

    public static Matcher<Root> isTouchable() {
        IsTouchable isTouchable = new IsTouchable();
        return isTouchable;
    }

    public static Matcher<Root> isDialog() {
        IsDialog isDialog = new IsDialog();
        return isDialog;
    }

    public static Matcher<Root> isSystemAlertWindow() {
        IsSystemAlertWindow isSystemAlertWindow = new IsSystemAlertWindow();
        return isSystemAlertWindow;
    }

    public static Matcher<Root> isPlatformPopup() {
        IsPlatformPopup isPlatformPopup = new IsPlatformPopup();
        return isPlatformPopup;
    }

    public static Matcher<Root> withDecorView(Matcher<View> matcher) {
        Preconditions.checkNotNull(matcher);
        WithDecorView withDecorView = new WithDecorView(matcher);
        return withDecorView;
    }

    private static Matcher<View> hasWindowFocus() {
        HasWindowFocus hasWindowFocus = new HasWindowFocus();
        return hasWindowFocus;
    }

    public static Matcher<Root> hasWindowLayoutParams() {
        HasWindowLayoutParams hasWindowLayoutParams = new HasWindowLayoutParams();
        return hasWindowLayoutParams;
    }

    private static Matcher<Root> isSubwindowOfCurrentActivity() {
        IsSubwindowOfCurrentActivity isSubwindowOfCurrentActivity = new IsSubwindowOfCurrentActivity();
        return isSubwindowOfCurrentActivity;
    }

    private static List<IBinder> getResumedActivityTokens() {
        Object object = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (object.isEmpty()) {
            Log.w((String)TAG, (String)"suppressed: NoActivityResumedException(\"At least one activity should be in RESUMED stage.\"");
        }
        ArrayList<IBinder> arrayList = Lists.newArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((Activity)object.next()).getWindow().getDecorView().getApplicationWindowToken());
        }
        return arrayList;
    }

    static final class IsSubwindowOfCurrentActivity
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsSubwindowOfCurrentActivity() {
        }

        public void describeTo(Description description) {
            description.appendText("is subwindow of current activity");
        }

        public boolean matchesSafely(Root root) {
            return RootMatchers.getResumedActivityTokens().contains(root.getDecorView().getApplicationWindowToken());
        }
    }

    static final class HasWindowLayoutParams
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public HasWindowLayoutParams() {
        }

        public void describeTo(Description description) {
            description.appendText("has window layout params");
        }

        public boolean matchesSafely(Root root) {
            return root.getWindowLayoutParams().isPresent();
        }
    }

    static final class HasWindowFocus
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        public HasWindowFocus() {
        }

        public void describeTo(Description description) {
            description.appendText("has window focus");
        }

        public boolean matchesSafely(View view) {
            return view.hasWindowFocus();
        }
    }

    static final class WithDecorView
    extends TypeSafeMatcher<Root> {
        @RemoteMsgField(order=0)
        private final Matcher<View> decorViewMatcher;

        @RemoteMsgConstructor
        public WithDecorView(Matcher<View> matcher) {
            this.decorViewMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("with decor view ");
            this.decorViewMatcher.describeTo(description);
        }

        public boolean matchesSafely(Root root) {
            return this.decorViewMatcher.matches((Object)root.getDecorView());
        }
    }

    static final class IsPlatformPopup
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsPlatformPopup() {
        }

        public boolean matchesSafely(Root root) {
            Object object = "android.widget.PopupWindow$PopupViewContainer";
            if (Build.VERSION.SDK_INT >= 23) {
                object = "android.widget.PopupWindow$PopupDecorView";
            }
            return RootMatchers.withDecorView(ViewMatchers.withClassName((Matcher<String>)Matchers.is((Object)object))).matches((Object)root);
        }

        public void describeTo(Description description) {
            description.appendText("with decor view of type PopupWindow$PopupViewContainer");
        }
    }

    static final class IsSystemAlertWindow
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsSystemAlertWindow() {
        }

        public void describeTo(Description description) {
            description.appendText("is system alert window");
        }

        public boolean matchesSafely(Root root) {
            int n = root.getWindowLayoutParams().get().type;
            return n > 2000 && n < 2999 && root.getDecorView().getWindowToken() == root.getDecorView().getApplicationWindowToken();
        }
    }

    static final class IsDialog
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsDialog() {
        }

        public void describeTo(Description description) {
            description.appendText("is dialog");
        }

        public boolean matchesSafely(Root root) {
            int n = root.getWindowLayoutParams().get().type;
            return n != 1 && n < 99 && root.getDecorView().getWindowToken() == root.getDecorView().getApplicationWindowToken();
        }
    }

    static final class IsTouchable
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsTouchable() {
        }

        public void describeTo(Description description) {
            description.appendText("is touchable");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Root root) {
            if ((root.getWindowLayoutParams().get().flags & 0x10) == 16) return false;
            return true;
        }
    }

    static final class IsFocusable
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsFocusable() {
        }

        public void describeTo(Description description) {
            description.appendText("is focusable");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Root root) {
            if ((root.getWindowLayoutParams().get().flags & 8) == 8) return false;
            return true;
        }
    }
}

