/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.preference.Preference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class PreferenceMatchers {
    private PreferenceMatchers() {
    }

    public static Matcher<Preference> withSummary(final int n) {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with summary string from resource id: ");
                description.appendValue((Object)n);
                if (this.resourceName != null) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (this.expectedText != null) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean matchesSafely(Preference preference) {
                if (this.expectedText == null) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(n);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {}
                }
                if (this.expectedText != null) {
                    return this.expectedText.equals(preference.getSummary().toString());
                }
                return false;
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withSummaryText(String string) {
        return PreferenceMatchers.withSummaryText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withSummaryText(final Matcher<String> matcher) {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with summary matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference object) {
                object = object.getSummary();
                object = object.toString();
                return matcher.matches(object);
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withTitle(final int n) {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            public void describeTo(Description description) {
                description.appendText(" with title string from resource id: ");
                description.appendValue((Object)n);
                if (this.resourceName != null) {
                    description.appendText("[");
                    description.appendText(this.resourceName);
                    description.appendText("]");
                }
                if (this.expectedText != null) {
                    description.appendText(" value: ");
                    description.appendText(this.expectedText);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean matchesSafely(Preference preference) {
                if (this.expectedText == null) {
                    try {
                        this.expectedText = preference.getContext().getResources().getString(n);
                        this.resourceName = preference.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {}
                }
                if (this.expectedText != null && preference.getTitle() != null) {
                    return this.expectedText.equals(preference.getTitle().toString());
                }
                return false;
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withTitleText(String string) {
        return PreferenceMatchers.withTitleText((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withTitleText(final Matcher<String> matcher) {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" a preference with title matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference object) {
                if (object.getTitle() == null) {
                    return false;
                }
                object = object.getTitle();
                object = object.toString();
                return matcher.matches(object);
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> isEnabled() {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" is an enabled preference");
            }

            public boolean matchesSafely(Preference preference) {
                return preference.isEnabled();
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withKey(String string) {
        return PreferenceMatchers.withKey((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Preference> withKey(final Matcher<String> matcher) {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" preference with key matching: ");
                matcher.describeTo(description);
            }

            public boolean matchesSafely(Preference preference) {
                return matcher.matches((Object)preference.getKey());
            }
        };
        return typeSafeMatcher;
    }
}

