/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.test.annotation.Beta;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Beta
public final class HasBackgroundMatcher
extends TypeSafeMatcher<View> {
    private static final String TAG = "HasBackgroundMatcher";
    private final int drawableId;

    public HasBackgroundMatcher(int n) {
        this.drawableId = n;
    }

    protected boolean matchesSafely(View view) {
        return HasBackgroundMatcher.assertDrawable(view.getBackground(), this.drawableId, view);
    }

    public void describeTo(Description description) {
        int n = this.drawableId;
        StringBuilder stringBuilder = new StringBuilder(44);
        description.appendText(stringBuilder.append("has background with drawable ID: ").append(n).toString());
    }

    static boolean compareBitmaps(Bitmap bitmap, Bitmap bitmap2) {
        if (bitmap.getWidth() == bitmap2.getWidth() && bitmap.getHeight() == bitmap2.getHeight()) {
            int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
            int[] nArray2 = new int[bitmap2.getWidth() * bitmap2.getHeight()];
            bitmap.getPixels(nArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
            bitmap2.getPixels(nArray2, 0, bitmap2.getWidth(), 0, 0, bitmap2.getWidth(), bitmap2.getHeight());
            return Arrays.equals(nArray, nArray2);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean assertDrawable(Drawable var0, int var1_10, View var2_12) {
        if (var0 != null && var0 instanceof BitmapDrawable) {
            block16: {
                block14: {
                    block15: {
                        var1_11 = BitmapFactory.decodeResource((Resources)var2_12.getContext().getResources(), (int)var1_10);
                        var2_13 = Build.VERSION.SDK_INT;
                        if (var2_13 < 12) break block14;
                        var0_1 = ((BitmapDrawable)var0).getBitmap().sameAs(var1_11);
                        if (var1_11 == null) break block15;
                        var1_11.recycle();
                    }
                    return var0_1;
                }
                var0_2 = HasBackgroundMatcher.compareBitmaps(((BitmapDrawable)var0).getBitmap(), var1_11);
                if (var1_11 == null) break block16;
                var1_11.recycle();
            }
            return var0_2;
        }
        return false;
        catch (OutOfMemoryError var0_3) {
            var1_11 = null;
lbl23:
            // 2 sources

            while (true) {
                block17: {
                    Log.e((String)"HasBackgroundMatcher", (String)var0_4.getMessage(), (Throwable)var0_4.getCause());
                    if (var1_11 == null) break block17;
                    var1_11.recycle();
                }
                return false;
            }
        }
        catch (Throwable var0_5) {
            var2_12 = null;
lbl33:
            // 3 sources

            while (true) {
                if (var2_12 != null) {
                    var2_12.recycle();
                }
                throw var0_6;
            }
        }
        catch (OutOfMemoryError var0_7) {
            ** continue;
        }
        catch (Throwable var0_8) {
            var2_12 = var1_11;
            ** GOTO lbl33
        }
        {
            catch (Throwable var0_9) {
                var2_12 = var1_11;
                ** continue;
            }
        }
    }
}

