/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.BoundedMatcher;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public final class CursorMatchers {
    private static final int COLUMN_NOT_FOUND = -1;
    private static final int MULTIPLE_COLUMNS_FOUND = -2;
    private static final int USE_COLUMN_PICKER = -3;
    private static final MatcherApplier BLOB_MATCHER_APPLIER;
    private static final MatcherApplier LONG_MATCHER_APPLIER;
    private static final MatcherApplier SHORT_MATCHER_APPLIER;
    private static final MatcherApplier INT_MATCHER_APPLIER;
    private static final MatcherApplier FLOAT_MATCHER_APPLIER;
    private static final MatcherApplier DOUBLE_MATCHER_APPLIER;
    private static final MatcherApplier STRING_MATCHER_APPLIER;

    private CursorMatchers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findColumnIndex(Matcher<String> matcher, Cursor cursor) {
        String[] stringArray = cursor.getColumnNames();
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (matcher.matches((Object)stringArray[n2])) {
                if (n != -1) {
                    return -2;
                }
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static CursorMatcher withRowShort(int n, short s) {
        return CursorMatchers.withRowShort(n, (Matcher<Short>)Matchers.is((Object)s));
    }

    public static CursorMatcher withRowShort(int n, Matcher<Short> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, SHORT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowShort(String string, short s) {
        return CursorMatchers.withRowShort(string, (Matcher<Short>)Matchers.is((Object)s));
    }

    public static CursorMatcher withRowShort(String string, Matcher<Short> matcher) {
        return CursorMatchers.withRowShort((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowShort(Matcher<String> matcher, Matcher<Short> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, SHORT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowInt(int n, int n2) {
        return CursorMatchers.withRowInt(n, (Matcher<Integer>)Matchers.is((Object)n2));
    }

    public static CursorMatcher withRowInt(int n, Matcher<Integer> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, INT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowInt(String string, int n) {
        return CursorMatchers.withRowInt(string, (Matcher<Integer>)Matchers.is((Object)n));
    }

    public static CursorMatcher withRowInt(String string, Matcher<Integer> matcher) {
        return CursorMatchers.withRowInt((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowInt(Matcher<String> matcher, Matcher<Integer> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, INT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowLong(int n, long l) {
        return CursorMatchers.withRowLong(n, (Matcher<Long>)Matchers.is((Object)l));
    }

    public static CursorMatcher withRowLong(int n, Matcher<Long> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, LONG_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowLong(String string, long l) {
        return CursorMatchers.withRowLong(string, (Matcher<Long>)Matchers.is((Object)l));
    }

    public static CursorMatcher withRowLong(String string, Matcher<Long> matcher) {
        return CursorMatchers.withRowLong((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowLong(Matcher<String> matcher, Matcher<Long> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, LONG_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowFloat(int n, float f) {
        return CursorMatchers.withRowFloat(n, (Matcher<Float>)Matchers.is((Object)Float.valueOf(f)));
    }

    public static CursorMatcher withRowFloat(int n, Matcher<Float> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, FLOAT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowFloat(String string, float f) {
        return CursorMatchers.withRowFloat(string, (Matcher<Float>)Matchers.is((Object)Float.valueOf(f)));
    }

    public static CursorMatcher withRowFloat(String string, Matcher<Float> matcher) {
        return CursorMatchers.withRowFloat((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowFloat(Matcher<String> matcher, Matcher<Float> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, FLOAT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowDouble(int n, double d) {
        return CursorMatchers.withRowDouble(n, (Matcher<Double>)Matchers.is((Object)d));
    }

    public static CursorMatcher withRowDouble(int n, Matcher<Double> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, DOUBLE_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowDouble(String string, double d) {
        return CursorMatchers.withRowDouble(string, (Matcher<Double>)Matchers.is((Object)d));
    }

    public static CursorMatcher withRowDouble(String string, Matcher<Double> matcher) {
        return CursorMatchers.withRowDouble((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowDouble(Matcher<String> matcher, Matcher<Double> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, DOUBLE_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowString(int n, String string) {
        return CursorMatchers.withRowString(n, (Matcher<String>)Matchers.is((Object)string));
    }

    public static CursorMatcher withRowString(int n, Matcher<String> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, STRING_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowString(String string, String string2) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)string), (Matcher<String>)Matchers.is((Object)string2));
    }

    public static CursorMatcher withRowString(String string, Matcher<String> matcher) {
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowString(Matcher<String> matcher, Matcher<String> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, STRING_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowBlob(int n, byte[] byArray) {
        return CursorMatchers.withRowBlob(n, (Matcher<byte[]>)Matchers.is((Object)byArray));
    }

    public static CursorMatcher withRowBlob(int n, Matcher<byte[]> matcher) {
        CursorMatcher cursorMatcher = new CursorMatcher(n, matcher, BLOB_MATCHER_APPLIER);
        return cursorMatcher;
    }

    public static CursorMatcher withRowBlob(String string, byte[] byArray) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)string), (Matcher<byte[]>)Matchers.is((Object)byArray));
    }

    public static CursorMatcher withRowBlob(String string, Matcher<byte[]> matcher) {
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)string), matcher);
    }

    public static CursorMatcher withRowBlob(Matcher<String> matcher, Matcher<byte[]> matcher2) {
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, matcher2, BLOB_MATCHER_APPLIER);
        return cursorMatcher;
    }

    static {
        MatcherApplier matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getBlob(n));
            }

            public void describeTo(Description description) {
                description.appendText("with Blob");
            }
        };
        BLOB_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getLong(n));
            }

            public void describeTo(Description description) {
                description.appendText("with Long");
            }
        };
        LONG_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getShort(n));
            }

            public void describeTo(Description description) {
                description.appendText("with Short");
            }
        };
        SHORT_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getInt(n));
            }

            public void describeTo(Description description) {
                description.appendText("with Int");
            }
        };
        INT_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)Float.valueOf(cursor.getFloat(n)));
            }

            public void describeTo(Description description) {
                description.appendText("with Float");
            }
        };
        FLOAT_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getDouble(n));
            }

            public void describeTo(Description description) {
                description.appendText("with Double");
            }
        };
        DOUBLE_MATCHER_APPLIER = matcherApplier;
        matcherApplier = new MatcherApplier(){

            @Override
            public boolean apply(Cursor cursor, int n, Matcher<?> matcher) {
                return matcher.matches((Object)cursor.getString(n));
            }

            public void describeTo(Description description) {
                description.appendText("with String");
            }
        };
        STRING_MATCHER_APPLIER = matcherApplier;
    }

    private static interface MatcherApplier
    extends SelfDescribing {
        public boolean apply(Cursor var1, int var2, Matcher<?> var3);
    }

    public static class CursorMatcher
    extends BoundedMatcher<Object, Cursor> {
        private final int columnIndex;
        private final Matcher<String> columnNameMatcher;
        private final Matcher<?> valueMatcher;
        private final MatcherApplier applier;
        private boolean checkColumns = true;

        /*
         * Enabled aggressive block sorting
         */
        private CursorMatcher(int n, Matcher<?> matcher, MatcherApplier matcherApplier) {
            super(Cursor.class);
            boolean bl = n >= 0;
            Preconditions.checkArgument(bl);
            this.columnIndex = n;
            this.valueMatcher = Preconditions.checkNotNull(matcher);
            this.applier = Preconditions.checkNotNull(matcherApplier);
            this.columnNameMatcher = null;
        }

        private CursorMatcher(Matcher<String> matcher, Matcher<?> matcher2, MatcherApplier matcherApplier) {
            super(Cursor.class);
            this.columnNameMatcher = Preconditions.checkNotNull(matcher);
            this.valueMatcher = Preconditions.checkNotNull(matcher2);
            this.applier = Preconditions.checkNotNull(matcherApplier);
            this.columnIndex = -3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matchesSafely(Cursor object) {
            Object object3;
            Object object2;
            int n = object2.columnIndex;
            if (n < 0 && (n = CursorMatchers.findColumnIndex((Matcher<String>)object2.columnNameMatcher, (Cursor)object)) < 0) {
                object3 = new StringDescription();
                object2.columnNameMatcher.describeTo((Description)object3);
                if (n == -1) {
                    if (!object2.checkColumns) return false;
                    object = String.valueOf(Arrays.asList(object.getColumnNames()));
                    String string = object3.toString();
                    object3 = String.valueOf(object);
                    int n2 = ((String)object3).length();
                    String string2 = String.valueOf(string);
                    int n3 = string2.length();
                    StringBuilder stringBuilder = new StringBuilder(n2 + 34 + n3);
                    object2 = new IllegalArgumentException(stringBuilder.append("Couldn't find column in ").append((String)object).append(" matching ").append(string).toString());
                    throw object2;
                }
            } else {
                try {
                    return object2.applier.apply((Cursor)object, n, object2.valueMatcher);
                }
                catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                    if (!object2.checkColumns) return false;
                    object2 = new IllegalArgumentException("Column index is invalid", cursorIndexOutOfBoundsException);
                    throw object2;
                }
            }
            if (n == -2) {
                object = String.valueOf(Arrays.asList(object.getColumnNames()));
                String string = object3.toString();
                object3 = String.valueOf(object);
                int n4 = ((String)object3).length();
                String string3 = String.valueOf(string);
                int n5 = string3.length();
                StringBuilder stringBuilder = new StringBuilder(n4 + 27 + n5);
                object2 = new IllegalArgumentException(stringBuilder.append("Multiple columns in ").append((String)object).append(" match ").append(string).toString());
                throw object2;
            }
            object = String.valueOf(Arrays.asList(object.getColumnNames()));
            String string = String.valueOf(object);
            n = string.length();
            object3 = new StringBuilder(n + 24);
            object2 = new IllegalArgumentException(((StringBuilder)object3).append("Couldn't find column in ").append((String)object).toString());
            throw object2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void describeTo(Description description) {
            description.appendText("Rows with column: ");
            if (this.columnIndex < 0) {
                this.columnNameMatcher.describeTo(description);
            } else {
                int n = this.columnIndex;
                StringBuilder stringBuilder = new StringBuilder(21);
                description.appendText(stringBuilder.append(" index = ").append(n).append(" ").toString());
            }
            this.applier.describeTo(description);
            description.appendText(" ");
            this.valueMatcher.describeTo(description);
        }

        public CursorMatcher withStrictColumnChecks(boolean bl) {
            this.checkColumns = bl;
            return this;
        }
    }
}

