/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import org.hamcrest.BaseMatcher;

public abstract class BoundedMatcher<T, S extends T>
extends BaseMatcher<T> {
    private final Class<?> expectedType;
    private final Class<?>[] interfaceTypes;

    public BoundedMatcher(Class<? extends S> clazz) {
        this.expectedType = Preconditions.checkNotNull(clazz);
        this.interfaceTypes = new Class[0];
    }

    public BoundedMatcher(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        this.expectedType = Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(classArray);
        this.interfaceTypes = new Class[classArray.length + 1];
        this.interfaceTypes[0] = Preconditions.checkNotNull(clazz2);
        Preconditions.checkArgument(clazz2.isInterface());
        int n = classArray.length;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz3 = classArray[i];
            this.interfaceTypes[n2] = Preconditions.checkNotNull(clazz3);
            Preconditions.checkArgument(clazz3.isInterface());
            ++n2;
        }
    }

    protected abstract boolean matchesSafely(S var1);

    public final boolean matches(Object object) {
        if (object == null) {
            return false;
        }
        if (this.expectedType.isInstance(object)) {
            Class<?>[] classArray = this.interfaceTypes;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                if (classArray[i].isInstance(object)) {
                    continue;
                }
                return false;
            }
            return this.matchesSafely(object);
        }
        return false;
    }
}

