/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Uninterruptibles {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            try {
                v = future.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            return v;
            break;
        }
    }
}

