/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable INTERRUPTING;
    private static final Runnable PARKED;

    InterruptibleTask() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        block25: {
            var6_1 = Thread.currentThread();
            if (!this.compareAndSet(null, var6_1)) {
                return;
            }
            if (this.isDone()) break block25;
            var1_2 = true;
lbl6:
            // 2 sources

            while (true) {
                block26: {
                    if (!var1_2) break block26;
                    var2_3 = this.runInterruptibly();
lbl10:
                    // 2 sources

                    while (true) {
                        block27: {
                            if (this.compareAndSet(var6_1, InterruptibleTask.DONE)) break block27;
                            var5_5 = (Runnable)this.get();
                            var3_7 = false;
                            var4_9 = 0;
                            block4: while (var5_5 == InterruptibleTask.INTERRUPTING) {
                                while (true) {
                                    block28: {
                                        block29: {
                                            if (++var4_9 <= 1000) break block28;
                                            if (var5_5 != InterruptibleTask.PARKED && !this.compareAndSet(InterruptibleTask.INTERRUPTING, InterruptibleTask.PARKED)) ** GOTO lbl24
                                            if (!Thread.interrupted()) break block29;
                                            while (true) {
                                                var3_7 = true;
lbl22:
                                                // 2 sources

                                                while (true) {
                                                    LockSupport.park(this);
lbl24:
                                                    // 3 sources

                                                    while (true) {
                                                        var5_5 = (Runnable)this.get();
                                                        continue block4;
                                                        break;
                                                    }
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        if (var3_7) ** continue;
                                        var3_7 = false;
                                        ** continue;
                                    }
                                    Thread.yield();
                                    ** continue;
                                    break;
                                }
                            }
                            if (var5_5 == InterruptibleTask.PARKED) ** continue;
                            if (var3_7) {
                                var6_1.interrupt();
                            }
                        }
                        if (var1_2) {
                            this.afterRanInterruptibly(var2_3, null);
                            return;
                        }
                        return;
                    }
                }
                var2_3 = null;
                ** continue;
                break;
            }
        }
        var1_2 = false;
        ** while (true)
        catch (Throwable var5_6) {
            block30: {
                if (this.compareAndSet(var6_1, InterruptibleTask.DONE)) break block30;
                var4_10 = (Runnable)this.get();
                var2_4 = false;
                var3_8 = 0;
                block10: while (var4_10 == InterruptibleTask.INTERRUPTING) {
                    while (true) {
                        block31: {
                            block32: {
                                if (++var3_8 <= 1000) break block31;
                                if (var4_10 != InterruptibleTask.PARKED && !this.compareAndSet(InterruptibleTask.INTERRUPTING, InterruptibleTask.PARKED)) ** GOTO lbl63
                                if (!Thread.interrupted()) break block32;
                                while (true) {
                                    var2_4 = true;
lbl61:
                                    // 2 sources

                                    while (true) {
                                        LockSupport.park(this);
lbl63:
                                        // 3 sources

                                        while (true) {
                                            var4_10 = (Runnable)this.get();
                                            continue block10;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            if (var2_4) ** continue;
                            var2_4 = false;
                            ** continue;
                        }
                        Thread.yield();
                        ** continue;
                        break;
                    }
                }
                if (var4_10 == InterruptibleTask.PARKED) ** continue;
                if (var2_4) {
                    var6_1.interrupt();
                }
            }
            if (!var1_2) ** continue;
            this.afterRanInterruptibly(null, var5_6);
            return;
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(T var1, Throwable var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread) || !this.compareAndSet(runnable, INTERRUPTING)) return;
        try {
            ((Thread)runnable).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(DONE) != PARKED) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(DONE) != PARKED) return;
        LockSupport.unpark((Thread)runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        CharSequence charSequence;
        Object object = (Runnable)((AtomicReference)((Object)string)).get();
        if (object == DONE) {
            object = "running=[DONE]";
        } else if (object == INTERRUPTING) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            object = ((Thread)object).getName();
            String string = String.valueOf(object);
            int n = string.length();
            charSequence = new StringBuilder(n + 21);
            object = ((StringBuilder)charSequence).append("running=[RUNNING ON ").append((String)object).append("]").toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        String string = ((InterruptibleTask)((Object)string)).toPendingString();
        String string2 = String.valueOf(object);
        int n = string2.length();
        charSequence = String.valueOf(string);
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n + 2 + n2);
        return stringBuilder.append((String)object).append(", ").append(string).toString();
    }

    abstract String toPendingString();

    static {
        DoNothingRunnable doNothingRunnable = new DoNothingRunnable();
        DONE = doNothingRunnable;
        doNothingRunnable = new DoNothingRunnable();
        INTERRUPTING = doNothingRunnable;
        doNothingRunnable = new DoNothingRunnable();
        PARKED = doNothingRunnable;
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

