/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.FluentFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

abstract class AbstractTransformFuture<I, O, F, T>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    ListenableFuture<? extends I> inputFuture;
    F function;

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> transformFuture = new TransformFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(transformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, transformFuture));
        return transformFuture;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> listenableFuture, F f) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(f);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        I i;
        F f;
        block16: {
            void var1_7;
            void var1_5;
            ListenableFuture<I> listenableFuture = this.inputFuture;
            f = this.function;
            int n = this.isCancelled();
            if (listenableFuture == null) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            n |= var1_5;
            if (f == null) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            if ((n | var1_7) != 0) {
                return;
            }
            this.inputFuture = null;
            if (listenableFuture.isCancelled()) {
                this.setFuture(listenableFuture);
                return;
            }
            i = Futures.getDone(listenableFuture);
            try {}
            catch (Throwable throwable) {
                try {
                    this.setException(throwable);
                    return;
                }
                finally {
                    this.function = null;
                }
            }
            break block16;
            catch (CancellationException cancellationException) {
                this.cancel(false);
                return;
            }
            catch (ExecutionException executionException) {
                this.setException(executionException.getCause());
                return;
            }
            catch (RuntimeException runtimeException) {
                this.setException(runtimeException);
                return;
            }
            catch (Error error) {
                this.setException(error);
                return;
            }
        }
        T t = this.doTransform(f, i);
        this.function = null;
        this.setResult(t);
    }

    abstract T doTransform(F var1, I var2) throws Exception;

    abstract void setResult(T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String pendingToString() {
        StringBuilder stringBuilder;
        Object object = ((AbstractTransformFuture)object3).inputFuture;
        Object object2 = ((AbstractTransformFuture)object3).function;
        String string = super.pendingToString();
        Object object3 = "";
        if (object != null) {
            object3 = String.valueOf(object);
            object = String.valueOf(object3);
            int n = ((String)object).length();
            stringBuilder = new StringBuilder(n + 16);
            object3 = stringBuilder.append("inputFuture=[").append((String)object3).append("], ").toString();
        }
        if (object2 != null) {
            object = String.valueOf(object2);
            object2 = String.valueOf(object3);
            int n = ((String)object2).length();
            string = String.valueOf(object);
            int n2 = string.length();
            stringBuilder = new StringBuilder(n + 11 + n2);
            return stringBuilder.append((String)object3).append("function=[").append((String)object).append("]").toString();
        }
        if (string == null) return null;
        object3 = String.valueOf(object3);
        object = String.valueOf(string);
        if (((String)object).length() != 0) return ((String)object3).concat((String)object);
        object = new String((String)object3);
        return object;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> listenableFuture, Function<? super I, ? extends O> function) {
            super(listenableFuture, function);
        }

        @Override
        O doTransform(Function<? super I, ? extends O> function, I i) {
            return function.apply(i);
        }

        @Override
        void setResult(O o) {
            this.set(o);
        }
    }
}

