/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.DirectExecutor;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.internal.InternalFutureFailureAccess;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.internal.InternalFutures;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    /*
     * Enabled aggressive block sorting
     */
    private void removeWaiter(Waiter waiter) {
        waiter.thread = null;
        Waiter waiter2;
        block0: while ((waiter2 = this.waiters) != Waiter.TOMBSTONE) {
            waiter = null;
            while (true) {
                if (waiter2 == null) {
                    return;
                }
                Waiter waiter3 = waiter2.next;
                if (waiter2.thread == null) {
                    if (waiter != null) {
                        waiter.next = waiter3;
                        if (waiter.thread == null) continue block0;
                    } else if (!ATOMIC_HELPER.casWaiters(this, waiter2, waiter3)) {
                        continue block0;
                    }
                } else {
                    waiter = waiter2;
                }
                waiter2 = waiter3;
            }
            break;
        }
        return;
    }

    protected AbstractFuture() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V get(long l, TimeUnit object) throws InterruptedException, TimeoutException, ExecutionException {
        String string;
        Object object2;
        Object object3;
        block21: {
            Object object4;
            boolean bl;
            long l2;
            String string2;
            block20: {
                block19: {
                    block18: {
                        long l3;
                        long l4;
                        boolean bl2;
                        long l5 = ((TimeUnit)((Object)object)).toNanos(l);
                        if (Thread.interrupted()) {
                            object3 = new InterruptedException();
                            throw object3;
                        }
                        Object object5 = ((AbstractFuture)object3).value;
                        boolean bl3 = object5 != null;
                        if (bl3 & (bl2 = !(object5 instanceof SetFuture))) {
                            return super.getDoneValue(object5);
                        }
                        long l6 = l5 > 0L ? (l4 = System.nanoTime() + l5) : 0L;
                        if (l5 < 1000L) {
                            l3 = l5;
                        } else {
                            Waiter waiter = ((AbstractFuture)object3).waiters;
                            if (waiter == Waiter.TOMBSTONE) return super.getDoneValue(((AbstractFuture)object3).value);
                            Waiter waiter2 = new Waiter();
                            Waiter waiter3 = waiter;
                            while (true) {
                                waiter2.setNext(waiter3);
                                if (ATOMIC_HELPER.casWaiters((AbstractFuture<?>)object3, waiter3, waiter2)) break;
                                waiter = ((AbstractFuture)object3).waiters;
                                if (waiter == Waiter.TOMBSTONE) return super.getDoneValue(((AbstractFuture)object3).value);
                                waiter3 = waiter;
                            }
                            long l7 = l5;
                            while (true) {
                                LockSupport.parkNanos(object3, l7);
                                if (Thread.interrupted()) {
                                    super.removeWaiter(waiter2);
                                    object3 = new InterruptedException();
                                    throw object3;
                                }
                                object2 = ((AbstractFuture)object3).value;
                                boolean bl4 = object2 != null;
                                if (bl4 & (bl2 = !(object2 instanceof SetFuture))) {
                                    return super.getDoneValue(object2);
                                }
                                long l8 = l6 - System.nanoTime();
                                if (l8 < 1000L) {
                                    super.removeWaiter(waiter2);
                                    l3 = l8;
                                    break;
                                }
                                l7 = l8;
                            }
                        }
                        while (l3 > 0L) {
                            long l9;
                            object2 = ((AbstractFuture)object3).value;
                            boolean bl5 = object2 != null;
                            if (bl5 & (bl2 = !(object2 instanceof SetFuture))) {
                                return super.getDoneValue(object2);
                            }
                            if (Thread.interrupted()) {
                                object3 = new InterruptedException();
                                throw object3;
                            }
                            l3 = l9 = l6 - System.nanoTime();
                        }
                        string = ((AbstractFuture)object3).toString();
                        string2 = ((Enum)object).toString().toLowerCase(Locale.ROOT);
                        object2 = ((Enum)object).toString().toLowerCase(Locale.ROOT);
                        String string3 = String.valueOf(object2);
                        int n = string3.length();
                        StringBuilder stringBuilder = new StringBuilder(n + 28);
                        object2 = stringBuilder.append("Waited ").append(l).append(" ").append((String)object2).toString();
                        if (l3 + 1000L >= 0L) break block18;
                        object2 = String.valueOf(object2).concat(" (plus ");
                        l = -l3;
                        long l10 = ((TimeUnit)((Object)object)).convert(l, TimeUnit.NANOSECONDS);
                        l2 = l - ((TimeUnit)((Object)object)).toNanos(l10);
                        bl = l10 == 0L || l2 > 1000L;
                        if (l10 <= 0L) break block19;
                        object2 = String.valueOf(object2);
                        String string4 = String.valueOf(object2);
                        n = string4.length();
                        String string5 = String.valueOf(string2);
                        int n2 = string5.length();
                        StringBuilder stringBuilder2 = new StringBuilder(n + 21 + n2);
                        string2 = stringBuilder2.append((String)object2).append(l10).append(" ").append(string2).toString();
                        if (bl) {
                            string2 = String.valueOf(string2).concat(",");
                            object4 = string2;
                        } else {
                            object4 = string2;
                        }
                        string2 = String.valueOf(object4).concat(" ");
                        object4 = string2;
                        break block20;
                    }
                    object = object2;
                    break block21;
                }
                object4 = object2;
            }
            if (bl) {
                object = String.valueOf(object4);
                string2 = String.valueOf(object);
                int n = string2.length();
                object2 = new StringBuilder(n + 33);
                object = ((StringBuilder)object2).append((String)object).append(l2).append(" nanoseconds ").toString();
            } else {
                object = object4;
            }
            object = String.valueOf(object).concat("delay)");
        }
        if (((AbstractFuture)object3).isDone()) {
            object3 = new TimeoutException(String.valueOf(object).concat(" but future completed as timeout expired"));
            throw object3;
        }
        String string6 = String.valueOf(object);
        int n = string6.length();
        object2 = String.valueOf(string);
        int n3 = ((String)object2).length();
        StringBuilder stringBuilder = new StringBuilder(n + 5 + n3);
        object3 = new TimeoutException(stringBuilder.append((String)object).append(" for ").append(string).toString());
        throw object3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        block5: {
            if (Thread.interrupted()) {
                object3 = new InterruptedException();
                throw object3;
            }
            object2 = ((AbstractFuture)object3).value;
            boolean bl3 = object2 != null;
            if (bl3 & (bl2 = !(object2 instanceof SetFuture))) {
                return super.getDoneValue(object2);
            }
            Waiter waiter = ((AbstractFuture)object3).waiters;
            if (waiter != Waiter.TOMBSTONE) {
                object2 = new Waiter();
                do {
                    ((Waiter)object2).setNext(waiter);
                    if (ATOMIC_HELPER.casWaiters((AbstractFuture<?>)object3, waiter, (Waiter)object2)) break block5;
                } while ((waiter = ((AbstractFuture)object3).waiters) != Waiter.TOMBSTONE);
            }
            return super.getDoneValue(((AbstractFuture)object3).value);
        }
        do {
            LockSupport.park(object3);
            if (!Thread.interrupted()) continue;
            super.removeWaiter((Waiter)object2);
            object3 = new InterruptedException();
            throw object3;
        } while (!((bl = (object = ((AbstractFuture)object3).value) != null) & (bl2 = !(object instanceof SetFuture))));
        return super.getDoneValue(object);
    }

    private V getDoneValue(Object object) throws ExecutionException {
        if (object instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
        }
        if (object instanceof Failure) {
            Object object2 = new ExecutionException(((Failure)object).exception);
            throw object2;
        }
        if (object == NULL) {
            return null;
        }
        return (V)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDone() {
        boolean bl;
        Object object = this.value;
        boolean bl2 = object != null;
        if (!(object instanceof SetFuture)) {
            bl = true;
            return bl2 & bl;
        }
        bl = false;
        return bl2 & bl;
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean cancel(boolean bl) {
        Cancellation cancellation;
        Object object = ((AbstractFuture)listenableFuture).value;
        boolean bl2 = object == null;
        if (!(bl2 | object instanceof SetFuture)) {
            return false;
        }
        if (GENERATE_CANCELLATION_CAUSES) {
            CancellationException cancellationException = new CancellationException("Future.cancel() was called.");
            cancellation = new Cancellation(bl, cancellationException);
        } else {
            cancellation = bl ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED;
        }
        boolean bl3 = false;
        AbstractFuture abstractFuture = listenableFuture;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                if (bl) {
                    abstractFuture.interruptTask();
                }
                AbstractFuture.complete(abstractFuture);
                if (!(object instanceof SetFuture)) {
                    return true;
                }
                ListenableFuture<Object> listenableFuture = ((SetFuture)object).future;
                if (!(listenableFuture instanceof Trusted)) {
                    listenableFuture.cancel(bl);
                    return true;
                }
                abstractFuture = listenableFuture;
                object = abstractFuture.value;
                boolean bl4 = object == null;
                if (!(bl4 | object instanceof SetFuture)) {
                    return true;
                }
                bl3 = true;
                continue;
            }
            object = abstractFuture.value;
            if (!(object instanceof SetFuture)) break;
        }
        return bl3;
    }

    protected void interruptTask() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean wasInterrupted() {
        Object object = ((AbstractFuture)object).value;
        if (!(object instanceof Cancellation)) return false;
        if (!((Cancellation)object).wasInterrupted) return false;
        return true;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        block3: {
            Listener listener;
            Preconditions.checkNotNull(runnable, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            if (!this.isDone() && (listener = this.listeners) != Listener.TOMBSTONE) {
                block2: {
                    Listener listener2 = new Listener(runnable, executor);
                    do {
                        listener2.next = listener;
                        if (ATOMIC_HELPER.casListeners(this, listener, listener2)) break block2;
                    } while ((listener = this.listeners) != Listener.TOMBSTONE);
                    break block3;
                }
                return;
            }
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    protected boolean set(V object) {
        if (object == null) {
            object = NULL;
        }
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        Failure failure = new Failure(Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, failure)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setFuture(ListenableFuture<? extends V> object) {
        Object object2;
        Preconditions.checkNotNull(object);
        SetFuture setFuture = ((AbstractFuture)object2).value;
        if (setFuture == null) {
            if (object.isDone()) {
                if (!ATOMIC_HELPER.casValue((AbstractFuture<?>)object2, null, object = AbstractFuture.getFutureValue(object))) return false;
                AbstractFuture.complete(object2);
                return true;
            }
            setFuture = new SetFuture(object2, object);
            if (ATOMIC_HELPER.casValue((AbstractFuture<?>)object2, null, setFuture)) {
                object.addListener(setFuture, DirectExecutor.INSTANCE);
                return true;
            }
            object2 = ((AbstractFuture)object2).value;
        } else {
            object2 = setFuture;
        }
        if (!(object2 instanceof Cancellation)) return false;
        object.cancel(((Cancellation)object2).wasInterrupted);
        return false;
        catch (Throwable throwable) {
            Failure failure;
            try {
                Failure failure2;
                failure = failure2 = new Failure(throwable);
            }
            catch (Throwable throwable2) {
                failure = Failure.FALLBACK_INSTANCE;
            }
            ATOMIC_HELPER.casValue((AbstractFuture<?>)object2, setFuture, failure);
            return true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getFutureValue(ListenableFuture<?> object) {
        IllegalArgumentException illegalArgumentException;
        String string;
        void var1_5;
        Throwable throwable;
        if (object instanceof Trusted) {
            object = ((AbstractFuture)object).value;
            if (!(object instanceof Cancellation)) return object;
            Cancellation cancellation = (Cancellation)object;
            if (!cancellation.wasInterrupted) return object;
            if (cancellation.cause == null) return Cancellation.CAUSELESS_CANCELLED;
            return new Cancellation(false, cancellation.cause);
        }
        if (object instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)object)) != null) {
            return new Failure(throwable);
        }
        int n = object.isCancelled();
        if (!GENERATE_CANCELLATION_CAUSES) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        if ((var1_5 & n) != 0) {
            return Cancellation.CAUSELESS_CANCELLED;
        }
        try {
            Object v = AbstractFuture.getUninterruptibly(object);
            if (n != 0) {
                string = String.valueOf(object);
                int n2 = String.valueOf(string).length();
                StringBuilder stringBuilder = new StringBuilder(n2 += 84);
                illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string).toString());
                return new Cancellation(false, illegalArgumentException);
            }
            if (v != null) return v;
            Object object2 = NULL;
            return object2;
        }
        catch (ExecutionException executionException) {
            if (n == 0) return new Failure(executionException.getCause());
            object = String.valueOf(object);
            string = String.valueOf(object);
            int n3 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 84);
            illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append((String)object).toString(), executionException);
            return new Cancellation(false, illegalArgumentException);
        }
        catch (CancellationException cancellationException) {
            if (n != 0) return new Cancellation(false, cancellationException);
            object = String.valueOf(object);
            string = String.valueOf(object);
            int n4 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 77);
            illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() threw CancellationException, despite reporting isCancelled() == false: ").append((String)object).toString(), cancellationException);
            return new Failure(illegalArgumentException);
        }
        catch (Throwable throwable2) {
            return new Failure(throwable2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            try {
                v = future.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            return v;
            break;
        }
    }

    private static void complete(AbstractFuture<?> object) {
        Listener listener = null;
        block0: while (true) {
            super.releaseWaiters();
            ((AbstractFuture)object).afterDone();
            object = super.clearListeners(listener);
            while (object != null) {
                listener = ((Listener)object).next;
                Object object2 = ((Listener)object).task;
                if (object2 instanceof SetFuture) {
                    object = (SetFuture)object2;
                    object2 = ((SetFuture)object).owner;
                    if (((AbstractFuture)object2).value == object) {
                        Object object3 = ((SetFuture)object).future;
                        if (!ATOMIC_HELPER.casValue((AbstractFuture<?>)object2, object, object3 = AbstractFuture.getFutureValue(object3))) {
                            object = listener;
                            continue;
                        }
                        object = object2;
                        continue block0;
                    }
                    object = listener;
                    continue;
                }
                AbstractFuture.executeListener((Runnable)object2, ((Listener)object).executor);
                object = listener;
            }
            break;
        }
    }

    protected void afterDone() {
    }

    @Override
    protected final Throwable tryInternalFastPathGetFailure() {
        if (this instanceof Trusted && (this = ((AbstractFuture)this).value) instanceof Failure) {
            return ((Failure)this).exception;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void maybePropagateCancellationTo(Future<?> future) {
        boolean bl = future != null;
        if (bl & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
            return;
        }
    }

    private void releaseWaiters() {
        Waiter waiter;
        while (!ATOMIC_HELPER.casWaiters((AbstractFuture<?>)object, waiter = ((AbstractFuture)object).waiters, Waiter.TOMBSTONE)) {
        }
        Object object = waiter;
        while (object != null) {
            ((Waiter)object).unpark();
            object = ((Waiter)object).next;
        }
    }

    private Listener clearListeners(Listener listener) {
        Object object;
        while (!ATOMIC_HELPER.casListeners((AbstractFuture<?>)object2, (Listener)(object = ((AbstractFuture)object2).listeners), Listener.TOMBSTONE)) {
        }
        Object object2 = object;
        object = listener;
        while (object2 != null) {
            listener = ((Listener)object2).next;
            ((Listener)object2).next = object;
            object = object2;
            object2 = listener;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = stringBuilder.append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
            return stringBuilder.append("]").toString();
        }
        if (this.isDone()) {
            this.addDoneString(stringBuilder);
            return stringBuilder.append("]").toString();
        }
        this.addPendingString(stringBuilder);
        return stringBuilder.append("]").toString();
    }

    protected String pendingToString() {
        if (object instanceof ScheduledFuture) {
            Object object = (ScheduledFuture)object;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            long l = object.getDelay(timeUnit);
            object = new StringBuilder(41);
            return ((StringBuilder)object).append("remaining delay=[").append(l).append(" ms]").toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPendingString(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        stringBuilder.append("PENDING");
        Object object = this.value;
        if (object instanceof SetFuture) {
            stringBuilder.append(", setFuture=[");
            this.appendUserObject(stringBuilder, ((SetFuture)object).future);
            stringBuilder.append("]");
        } else {
            try {
                object = Strings.emptyToNull(this.pendingToString());
            }
            catch (RuntimeException | StackOverflowError throwable) {
                object = String.valueOf(throwable.getClass());
                String string = String.valueOf(object);
                int n2 = string.length();
                StringBuilder stringBuilder2 = new StringBuilder(n2 + 38);
                object = stringBuilder2.append("Exception thrown from implementation: ").append((String)object).toString();
            }
            if (object != null) {
                stringBuilder.append(", info=[").append((String)object).append("]");
            }
        }
        if (this.isDone()) {
            stringBuilder.delete(n, stringBuilder.length());
            this.addDoneString(stringBuilder);
            return;
        }
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            V v = AbstractFuture.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            this.appendUserObject(stringBuilder, v);
            stringBuilder.append("]");
            return;
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendUserObject(StringBuilder var1_2, Object var2_3) {
        if (var2_3 != this) ** GOTO lbl6
        try {
            var1_2.append("this future");
            return;
lbl6:
            // 1 sources

            var1_2.append(var2_3);
            return;
        }
        catch (RuntimeException | StackOverflowError var0_1) {
            var1_2.append("Exception thrown from implementation: ").append(var0_1.getClass());
            return;
        }
    }

    private static void executeListener(Runnable object, Executor object2) {
        try {
            object2.execute((Runnable)object);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            object = String.valueOf(object);
            object2 = String.valueOf(object2);
            String string = String.valueOf(object);
            int n = string.length();
            String string2 = String.valueOf(object2);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 57 + n2);
            logger.logp(level, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "executeListener", stringBuilder.append("RuntimeException while executing runnable ").append((String)object).append(" with executor ").append((String)object2).toString(), runtimeException);
            return;
        }
    }

    private static CancellationException cancellationExceptionWithCause(String string, Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    static /* synthetic */ Waiter access$802(AbstractFuture abstractFuture, Waiter waiter) {
        abstractFuture.waiters = waiter;
        return waiter;
    }

    static /* synthetic */ Listener access$902(AbstractFuture abstractFuture, Listener listener) {
        abstractFuture.listeners = listener;
        return listener;
    }

    static /* synthetic */ Object access$402(AbstractFuture abstractFuture, Object object) {
        abstractFuture.value = object;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Class<Waiter> clazz;
        Throwable throwable;
        Object object;
        boolean bl;
        try {
            bl = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl;
        log = Logger.getLogger(AbstractFuture.class.getName());
        try {
            object = new UnsafeAtomicHelper();
            throwable = null;
            clazz = null;
        }
        catch (Throwable throwable2) {
            try {
                clazz = Waiter.class;
                Class<Thread> clazz2 = Thread.class;
                String string = "thread";
                object = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(clazz, clazz2, string), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
                clazz = null;
            }
            catch (Throwable throwable3) {
                object = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = object;
        if (clazz != null) {
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", (Throwable)((Object)clazz));
        }
        NULL = object = new Object();
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            synchronized (abstractFuture) {
                Waiter waiter3 = ((AbstractFuture)abstractFuture).waiters;
                if (waiter3 != waiter) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$802(abstractFuture, waiter2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            synchronized (abstractFuture) {
                Listener listener3 = ((AbstractFuture)abstractFuture).listeners;
                if (listener3 != listener) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$902(abstractFuture, listener2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            synchronized (abstractFuture) {
                Object object3 = ((AbstractFuture)abstractFuture).value;
                if (object3 != object) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$402(abstractFuture, object2);
                    return true;
                }
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<AbstractFuture, Waiter> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<AbstractFuture, Listener> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<AbstractFuture, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return this.waitersUpdater.compareAndSet(abstractFuture, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return this.listenersUpdater.compareAndSet(abstractFuture, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(abstractFuture, object, object2);
        }
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        private UnsafeAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, VALUE_OFFSET, object, object2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            PrivilegedExceptionAction<Unsafe> privilegedExceptionAction;
            try {
                privilegedExceptionAction = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    privilegedExceptionAction = new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Object object2;
                            Class<Unsafe> clazz;
                            block2: {
                                clazz = Unsafe.class;
                                for (Field field : clazz.getDeclaredFields()) {
                                    field.setAccessible(true);
                                    object2 = field.get(null);
                                    if (!clazz.isInstance(object2)) {
                                        continue;
                                    }
                                    break block2;
                                }
                                NoSuchFieldError noSuchFieldError = new NoSuchFieldError("the Unsafe");
                                throw noSuchFieldError;
                            }
                            return (Unsafe)clazz.cast(object2);
                        }
                    };
                    privilegedExceptionAction = (Unsafe)AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    RuntimeException runtimeException = new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                    throw runtimeException;
                }
            }
            try {}
            catch (Exception exception) {
                Throwables.throwIfUnchecked(exception);
                RuntimeException runtimeException = new RuntimeException(exception);
                throw runtimeException;
            }
            Class<AbstractFuture> clazz = AbstractFuture.class;
            WAITERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("waiters"));
            LISTENERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("listeners"));
            VALUE_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("value"));
            WAITER_THREAD_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("thread"));
            WAITER_NEXT_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("next"));
            UNSAFE = privilegedExceptionAction;
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void putThread(Waiter var1, Thread var2);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract boolean casWaiters(AbstractFuture<?> var1, Waiter var2, Waiter var3);

        abstract boolean casListeners(AbstractFuture<?> var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractFuture<?> var1, Object var2, Object var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        SetFuture(AbstractFuture<V> abstractFuture, ListenableFuture<? extends V> listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = this.future;
            object = AbstractFuture.getFutureValue(object);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
                return;
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        Cancellation(boolean bl, Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                Cancellation cancellation;
                CAUSELESS_CANCELLED = cancellation = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = cancellation = new Cancellation(true, null);
            }
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE;
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = Preconditions.checkNotNull(throwable);
        }

        static {
            Failure failure;
            Throwable throwable = new Throwable("Failure occurred while trying to finish a future."){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
            FALLBACK_INSTANCE = failure = new Failure(throwable);
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE;
        final Runnable task;
        final Executor executor;
        Listener next;

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }

        static {
            Listener listener;
            TOMBSTONE = listener = new Listener(null, null);
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE;
        volatile Thread thread;
        volatile Waiter next;

        Waiter(boolean bl) {
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
                return;
            }
        }

        static {
            Waiter waiter;
            TOMBSTONE = waiter = new Waiter(false);
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        TrustedFuture() {
        }

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl) {
            return super.cancel(bl);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }
}

