/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;

final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    static final RegularImmutableSet<Object> EMPTY;
    final transient Object[] elements;
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;
    private final transient int size;

    RegularImmutableSet(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        this.elements = objectArray;
        this.table = objectArray2;
        this.mask = n2;
        this.hashCode = n;
        this.size = n3;
    }

    @Override
    public boolean contains(Object object) {
        Object[] objectArray = this.table;
        if (object != null && objectArray != null) {
            Object object2;
            int n = Hashing.smearedHash(object);
            while ((object2 = objectArray[n &= this.mask]) != null) {
                if (!object2.equals(object)) {
                    ++n;
                    continue;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.size;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        System.arraycopy(this.elements, 0, objectArray, n, this.size);
        return n + this.size;
    }

    @Override
    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.elements, this.size);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    static {
        RegularImmutableSet regularImmutableSet = new RegularImmutableSet(new Object[0], 0, null, 0, 0);
        EMPTY = regularImmutableSet;
    }
}

