/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY;
    private final transient Object hashTable;
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, Object[] objectArray) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(objectArray[0], objectArray[1]);
            RegularImmutableMap<K, V> regularImmutableMap = new RegularImmutableMap<K, V>(null, objectArray, 1);
            return regularImmutableMap;
        }
        Preconditions.checkPositionIndex(n, objectArray.length >> 1);
        int n2 = ImmutableSet.chooseTableSize(n);
        Object object = RegularImmutableMap.createHashTable(objectArray, n, n2, 0);
        RegularImmutableMap<K, V> regularImmutableMap = new RegularImmutableMap<K, V>(object, objectArray, n);
        return regularImmutableMap;
    }

    static Object createHashTable(Object[] objectArray, int n, int n2, int n3) {
        if (n != 1) {
            char c;
            Object object;
            Object object2;
            block13: {
                int n4;
                Object object3;
                Object object4;
                block12: {
                    int n5;
                    Object object5;
                    Object object6;
                    block14: {
                        int n6 = n2 + -1;
                        if (n2 <= 128) {
                            byte[] byArray = new byte[n2];
                            Arrays.fill(byArray, (byte)-1);
                            for (n2 = 0; n2 < n; ++n2) {
                                int n7 = n2 + n2 + n3;
                                object4 = objectArray[n7];
                                object3 = objectArray[n7 ^ 1];
                                CollectPreconditions.checkEntryNotNull(object4, object3);
                                int n8 = Hashing.smear(object4.hashCode());
                                while ((n4 = byArray[n8 &= n6] & 0xFF) != 255) {
                                    if (!objectArray[n4].equals(object4)) {
                                        ++n8;
                                        continue;
                                    }
                                    break block12;
                                }
                                byArray[n8] = (byte)n7;
                            }
                            return byArray;
                        }
                        if (n2 <= 32768) {
                            short[] sArray = new short[n2];
                            Arrays.fill(sArray, (short)-1);
                            for (n2 = 0; n2 < n; ++n2) {
                                int n9 = n2 + n2 + n3;
                                object2 = objectArray[n9];
                                object = objectArray[n9 ^ 1];
                                CollectPreconditions.checkEntryNotNull(object2, object);
                                int n10 = Hashing.smear(object2.hashCode());
                                while ((c = (char)sArray[n10 &= n6]) != '\uffff') {
                                    if (!objectArray[c].equals(object2)) {
                                        ++n10;
                                        continue;
                                    }
                                    break block13;
                                }
                                sArray[n10] = (short)n9;
                            }
                            return sArray;
                        }
                        int[] nArray = new int[n2];
                        Arrays.fill(nArray, -1);
                        for (n2 = 0; n2 < n; ++n2) {
                            int n11 = n2 + n2 + n3;
                            object6 = objectArray[n11];
                            object5 = objectArray[n11 ^ 1];
                            CollectPreconditions.checkEntryNotNull(object6, object5);
                            int n12 = Hashing.smear(object6.hashCode());
                            while ((n5 = nArray[n12 &= n6]) != -1) {
                                if (!objectArray[n5].equals(object6)) {
                                    ++n12;
                                    continue;
                                }
                                break block14;
                            }
                            nArray[n12] = n11;
                        }
                        return nArray;
                    }
                    throw RegularImmutableMap.duplicateKeyException(object6, object5, objectArray, n5);
                }
                throw RegularImmutableMap.duplicateKeyException(object4, object3, objectArray, n4);
            }
            throw RegularImmutableMap.duplicateKeyException(object2, object, objectArray, c);
        }
        CollectPreconditions.checkEntryNotNull(objectArray[n3], objectArray[n3 ^ 1]);
        return null;
    }

    private static IllegalArgumentException duplicateKeyException(Object object, Object object2, Object[] object3, int n) {
        object = String.valueOf(object);
        object2 = String.valueOf(object2);
        String string = String.valueOf(object3[n]);
        object3 = String.valueOf(object3[n ^ 1]);
        String string2 = String.valueOf(object);
        int n2 = string2.length();
        String string3 = String.valueOf(object2);
        int n3 = string3.length();
        String string4 = String.valueOf(string);
        int n4 = string4.length();
        String string5 = String.valueOf(object3);
        int n5 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 39 + n3 + n4 + n5);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("Multiple entries with same key: ").append((String)object).append("=").append((String)object2).append(" and ").append(string).append("=").append((String)object3).toString());
        return illegalArgumentException;
    }

    private RegularImmutableMap(Object object, Object[] objectArray, int n) {
        this.hashTable = object;
        this.alternatingKeysAndValues = objectArray;
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object object) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object get(Object object, Object[] objectArray, int n, int n2, Object object2) {
        int n3;
        if (object2 == null) {
            return null;
        }
        if (n == 1) {
            if (objectArray[n2].equals(object2)) return objectArray[n2 ^ 1];
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            int n4;
            byte[] byArray = (byte[])object;
            n2 = byArray.length + -1;
            int n5 = Hashing.smear(object2.hashCode());
            while ((n4 = byArray[n5 &= n2] & 0xFF) != 255) {
                if (objectArray[n4].equals(object2)) return objectArray[n4 ^ 1];
                ++n5;
            }
            return null;
        }
        if (object instanceof short[]) {
            char c;
            short[] sArray = (short[])object;
            n2 = sArray.length + -1;
            int n6 = Hashing.smear(object2.hashCode());
            while ((c = (char)sArray[n6 &= n2]) != '\uffff') {
                if (objectArray[c].equals(object2)) return objectArray[c ^ '\u0001'];
                ++n6;
            }
            return null;
        }
        int[] nArray = (int[])object;
        n2 = nArray.length + -1;
        int n7 = Hashing.smear(object2.hashCode());
        while ((n3 = nArray[n7 &= n2]) != -1) {
            if (objectArray[n3].equals(object2)) return objectArray[n3 ^ 1];
            ++n7;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        EntrySet entrySet = new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
        return entrySet;
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        KeySet<Object> keySet = new KeySet<Object>(this, keysOrValuesAsList);
        return keySet;
    }

    @Override
    ImmutableCollection<V> createValues() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
        return keysOrValuesAsList;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static {
        RegularImmutableMap<Object, Object> regularImmutableMap = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
        EMPTY = regularImmutableMap;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> immutableMap, ImmutableList<K> immutableList) {
            this.map = immutableMap;
            this.list = immutableList;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (this.map.get(object) == null) return false;
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] objectArray, int n, int n2) {
            this.alternatingKeysAndValues = objectArray;
            this.offset = n;
            this.size = n2;
        }

        @Override
        public Object get(int n) {
            Preconditions.checkElementIndex(n, this.size);
            return this.alternatingKeysAndValues[n + n + this.offset];
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> immutableMap, Object[] objectArray, int n, int n2) {
            this.map = immutableMap;
            this.alternatingKeysAndValues = objectArray;
            this.keyOffset = n;
            this.size = n2;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            ImmutableList immutableList = new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int n) {
                    Preconditions.checkElementIndex(n, size);
                    Object object = immutableCollection.this;
                    object = ((EntrySet)object).alternatingKeysAndValues;
                    EntrySet entrySet = immutableCollection.this;
                    int n2 = entrySet.keyOffset;
                    object = object[n + n + n2];
                    Object[] objectArray = immutableCollection.this;
                    objectArray = ((EntrySet)objectArray).alternatingKeysAndValues;
                    ImmutableCollection immutableCollection = immutableCollection.this;
                    int n3 = ((EntrySet)immutableCollection).keyOffset;
                    Object object2 = objectArray[n + n + (n3 ^ 1)];
                    AbstractMap.SimpleImmutableEntry<Object[], Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object[], Object>((Object[])object, object2);
                    return simpleImmutableEntry;
                }

                @Override
                public int size() {
                    return size;
                }
            };
            return immutableList;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) return false;
            object = (Map.Entry)object;
            Object k = object.getKey();
            if ((object = object.getValue()) == null) return false;
            if (!object.equals(this.map.get(k))) return false;
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

