/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Cut;
import androidx.test.espresso.core.internal.deps.guava.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;

public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL;
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    static <C extends Comparable<?>> Range<C> create(Cut<C> cut, Cut<C> cut2) {
        Range<C> range = new Range<C>(cut, cut2);
        return range;
    }

    public static <C extends Comparable<?>> Range<C> closed(C c, C c2) {
        return Range.create(Cut.belowValue(c), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Range(Cut<C> object, Cut<C> cut) {
        ((Range)object2).lowerBound = (Cut)Preconditions.checkNotNull(object);
        ((Range)object2).upperBound = Preconditions.checkNotNull(cut);
        if (((Cut)object).compareTo(cut) <= 0 && object != Cut.aboveAll() && cut != Cut.belowAll()) {
            return;
        }
        Object object2 = String.valueOf(Range.toString(object, cut));
        object = "Invalid range: ";
        object2 = ((String)object2).length() == 0 ? new String((String)object) : ((String)object).concat((String)object2);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object2);
        throw illegalArgumentException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(C c) {
        Preconditions.checkNotNull(c);
        if (!this.lowerBound.isLessThan(c)) return false;
        if (this.upperBound.isLessThan(c)) return false;
        return true;
    }

    @Override
    @Deprecated
    public boolean apply(C c) {
        return this.contains(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Range)) return false;
        object = (Range)object;
        if (!this.lowerBound.equals(((Range)object).lowerBound)) return false;
        if (!this.upperBound.equals(((Range)object).upperBound)) return false;
        return true;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut<?> cut, Cut<?> cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append("..");
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    static {
        Range range = new Range(Cut.belowAll(), Cut.aboveAll());
        ALL = range;
    }
}

