/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Maps;
import androidx.test.espresso.core.internal.deps.guava.collect.Ordering;
import androidx.test.espresso.core.internal.deps.guava.collect.RegularImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.Sets;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap immutableMap;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap) && !(immutableMap = (ImmutableMap)map).isPartialView()) {
            return immutableMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <K, V> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        int n = iterable instanceof Collection ? ((Collection)iterable).size() : 4;
        Builder builder = new Builder(n);
        builder.putAll(iterable);
        return builder.build();
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final V remove(Object object) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final void clear() {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        if (this.size() != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsKey(Object object) {
        if (this.get(object) == null) return false;
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        return ((ImmutableCollection)this.values()).contains(object);
    }

    @Override
    public abstract V get(Object var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getOrDefault(Object object, V v) {
        void var1_2;
        V v2 = this.get(var1_2);
        if (v2 == null) {
            void var2_3;
            return var2_3;
        }
        return v2;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        if (immutableSet == null) {
            this.entrySet = immutableSet = this.createEntrySet();
            return immutableSet;
        }
        return immutableSet;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        if (immutableSet == null) {
            this.keySet = immutableSet = this.createKeySet();
            return immutableSet;
        }
        return immutableSet;
    }

    abstract ImmutableSet<K> createKeySet();

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        if (immutableCollection == null) {
            this.values = immutableCollection = this.createValues();
            return immutableCollection;
        }
        return immutableCollection;
    }

    abstract ImmutableCollection<V> createValues();

    @Override
    public boolean equals(Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this);
        return serializedForm;
    }

    static class SerializedForm
    implements Serializable {
        private final Object[] keys;
        private final Object[] values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, ?> immutableMap) {
            this.keys = new Object[immutableMap.size()];
            this.values = new Object[immutableMap.size()];
            Iterator iterator = ((ImmutableSet)immutableMap.entrySet()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.keys[n] = entry.getKey();
                this.values[n] = entry.getValue();
                ++n;
            }
        }

        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>(this.keys.length);
            return this.createMap(builder);
        }

        Object createMap(Builder<Object, Object> builder) {
            for (int i = 0; i < this.keys.length; ++i) {
                builder.put(this.keys[i], this.values[i]);
            }
            return builder.build();
        }
    }

    public static class Builder<K, V> {
        Comparator<? super V> valueComparator;
        Object[] alternatingKeysAndValues;
        int size;
        boolean entriesUsed;

        public Builder() {
            this(4);
        }

        Builder(int n) {
            this.alternatingKeysAndValues = new Object[n + n];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int n) {
            if (n + n > this.alternatingKeysAndValues.length) {
                this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, ImmutableCollection.Builder.expandedCapacity(this.alternatingKeysAndValues.length, n + n));
                this.entriesUsed = false;
                return;
            }
        }

        public Builder<K, V> put(K object, V v) {
            this.ensureCapacity(this.size + 1);
            CollectPreconditions.checkEntryNotNull(object, v);
            Object[] objectArray = this.alternatingKeysAndValues;
            int n = this.size;
            objectArray[n + n] = object;
            object = this.alternatingKeysAndValues;
            int n2 = this.size++;
            object[n2 + n2 + 1] = v;
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> object) {
            if (object instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)object).size());
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.put((Map.Entry)object.next());
            }
            return this;
        }

        public ImmutableMap<K, V> build() {
            this.sortEntries();
            this.entriesUsed = true;
            return RegularImmutableMap.create(this.size, this.alternatingKeysAndValues);
        }

        void sortEntries() {
            if (this.valueComparator != null) {
                int n;
                if (this.entriesUsed) {
                    Object[] objectArray = this.alternatingKeysAndValues;
                    int n2 = this.size;
                    this.alternatingKeysAndValues = Arrays.copyOf(objectArray, n2 + n2);
                }
                Map.Entry[] entryArray = new Map.Entry[this.size];
                for (n = 0; n < this.size; ++n) {
                    AbstractMap.SimpleImmutableEntry<Object, Object> simpleImmutableEntry;
                    entryArray[n] = simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(this.alternatingKeysAndValues[n + n], this.alternatingKeysAndValues[n + n + 1]);
                }
                Arrays.sort(entryArray, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
                for (n = 0; n < this.size; ++n) {
                    this.alternatingKeysAndValues[n + n] = entryArray[n].getKey();
                    this.alternatingKeysAndValues[n + n + 1] = entryArray[n].getValue();
                }
            }
        }
    }
}

