/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Ordering;
import java.io.Serializable;

final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(F f, F f2) {
        return this.ordering.compare(this.function.apply(f), this.function.apply(f2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByFunctionOrdering)) return false;
        object = (ByFunctionOrdering)object;
        if (!this.function.equals(((ByFunctionOrdering)object).function)) return false;
        if (!this.ordering.equals(((ByFunctionOrdering)object).ordering)) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.function, this.ordering};
        return Objects.hashCode(objectArray);
    }

    public String toString() {
        String string = String.valueOf(((ByFunctionOrdering)((Object)string2)).ordering);
        String string2 = String.valueOf(((ByFunctionOrdering)((Object)string2)).function);
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 13 + n2);
        return stringBuilder.append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

