/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.cache;

import androidx.test.espresso.core.internal.deps.guava.base.Equivalence;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Stopwatch;
import androidx.test.espresso.core.internal.deps.guava.base.Ticker;
import androidx.test.espresso.core.internal.deps.guava.cache.AbstractCache$StatsCounter;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheLoader;
import androidx.test.espresso.core.internal.deps.guava.cache.ForwardingCache;
import androidx.test.espresso.core.internal.deps.guava.cache.ReferenceEntry;
import androidx.test.espresso.core.internal.deps.guava.cache.RemovalCause;
import androidx.test.espresso.core.internal.deps.guava.cache.RemovalListener;
import androidx.test.espresso.core.internal.deps.guava.cache.RemovalNotification;
import androidx.test.espresso.core.internal.deps.guava.cache.Weigher;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractSequentialIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.primitives.Ints;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.SettableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long maxWeight;
    final Weigher<K, V> weigher;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final Ticker ticker;
    final EntryFactory entryFactory;
    final AbstractCache$StatsCounter globalStatsCounter;
    final CacheLoader<? super K, V> defaultLoader;
    static final ValueReference<Object, Object> UNSET;
    static final Queue<?> DISCARDING_QUEUE;
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;

    /*
     * Enabled aggressive block sorting
     */
    LocalCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        int n;
        this.concurrencyLevel = Math.min(cacheBuilder.getConcurrencyLevel(), 65536);
        this.keyStrength = cacheBuilder.getKeyStrength();
        this.valueStrength = cacheBuilder.getValueStrength();
        this.keyEquivalence = cacheBuilder.getKeyEquivalence();
        this.valueEquivalence = cacheBuilder.getValueEquivalence();
        this.maxWeight = cacheBuilder.getMaximumWeight();
        this.weigher = cacheBuilder.getWeigher();
        this.expireAfterAccessNanos = cacheBuilder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = cacheBuilder.getExpireAfterWriteNanos();
        this.refreshNanos = cacheBuilder.getRefreshNanos();
        this.removalListener = cacheBuilder.getRemovalListener();
        ConcurrentLinkedQueue<RemovalNotification<K, V>> concurrentLinkedQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? LocalCache.discardingQueue() : new ConcurrentLinkedQueue<RemovalNotification<K, V>>();
        this.removalNotificationQueue = concurrentLinkedQueue;
        this.ticker = cacheBuilder.getTicker(this.recordsTime());
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = cacheBuilder.getStatsCounterSupplier().get();
        this.defaultLoader = cacheLoader;
        int n2 = Math.min(cacheBuilder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            n2 = (int)Math.min((long)n2, this.maxWeight);
        }
        int n3 = 0;
        for (n = 1; !(n >= this.concurrencyLevel || this.evictsBySize() && (long)(n * 20) > this.maxWeight); ++n3, n += n) {
        }
        this.segmentShift = 32 - n3;
        this.segmentMask = n + -1;
        this.segments = this.newSegmentArray(n);
        n3 = n2 / n;
        n2 = n3 * n < n2 ? n3 + 1 : n3;
        for (n3 = 1; n3 < n2; n3 += n3) {
        }
        if (this.evictsBySize()) {
            long l = this.maxWeight / (long)n + 1L;
            long l2 = this.maxWeight % (long)n;
            for (n2 = 0; n2 < this.segments.length; ++n2) {
                long l3 = (long)n2 != l2 ? l : l + -1L;
                this.segments[n2] = this.createSegment(n3, l3, cacheBuilder.getStatsCounterSupplier().get());
                l = l3;
            }
            return;
        }
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = this.createSegment(n3, -1L, cacheBuilder.getStatsCounterSupplier().get());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean evictsBySize() {
        if (this.maxWeight < 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean customWeigher() {
        if (this.weigher == CacheBuilder.OneWeigher.INSTANCE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean expiresAfterWrite() {
        if (this.expireAfterWriteNanos <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean expiresAfterAccess() {
        if (this.expireAfterAccessNanos <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean refreshes() {
        if (this.refreshNanos <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesAccessQueue() {
        if (this.expiresAfterAccess()) {
            return true;
        }
        if (this.evictsBySize()) return true;
        return false;
    }

    boolean usesWriteQueue() {
        return this.expiresAfterWrite();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean recordsWrite() {
        if (this.expiresAfterWrite()) {
            return true;
        }
        if (this.refreshes()) return true;
        return false;
    }

    boolean recordsAccess() {
        return this.expiresAfterAccess();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean recordsTime() {
        if (this.recordsWrite()) {
            return true;
        }
        if (this.recordsAccess()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesWriteEntries() {
        if (this.usesWriteQueue()) {
            return true;
        }
        if (this.recordsWrite()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesAccessEntries() {
        if (this.usesAccessQueue()) {
            return true;
        }
        if (this.recordsAccess()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesKeyReferences() {
        if (this.keyStrength == Strength.STRONG) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesValueReferences() {
        if (this.valueStrength == Strength.STRONG) return false;
        return true;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    int hash(Object object) {
        return LocalCache.rehash(this.keyEquivalence.hash(object));
    }

    void reclaimValue(ValueReference<K, V> valueReference) {
        ReferenceEntry<K, V> referenceEntry = valueReference.getEntry();
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimValue(referenceEntry.getKey(), n, valueReference);
    }

    void reclaimKey(ReferenceEntry<K, V> referenceEntry) {
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimKey(referenceEntry, n);
    }

    Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    Segment<K, V> createSegment(int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        Segment segment = new Segment(this, n, l, abstractCache$StatsCounter);
        return segment;
    }

    V getLiveValue(ReferenceEntry<K, V> referenceEntry, long l) {
        if (referenceEntry.getKey() == null) {
            return null;
        }
        V v = referenceEntry.getValueReference().get();
        if (v == null) {
            return null;
        }
        if (this.isExpired(referenceEntry, l)) {
            return null;
        }
        return v;
    }

    boolean isExpired(ReferenceEntry<K, V> referenceEntry, long l) {
        Preconditions.checkNotNull(referenceEntry);
        if (this.expiresAfterAccess() && l - referenceEntry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && l - referenceEntry.getWriteTime() >= this.expireAfterWriteNanos;
    }

    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry2.setPreviousInAccessQueue(referenceEntry);
    }

    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> referenceEntry) {
        ReferenceEntry<K, V> referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry.setPreviousInAccessQueue(referenceEntry2);
    }

    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry2.setPreviousInWriteQueue(referenceEntry);
    }

    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> referenceEntry) {
        ReferenceEntry<K, V> referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry.setPreviousInWriteQueue(referenceEntry2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processPendingNotifications() {
        RemovalNotification<K, V> removalNotification;
        while ((removalNotification = this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Throwable throwable) {
                logger.logp(Level.WARNING, "androidx.test.espresso.core.internal.deps.guava.cache.LocalCache", "processPendingNotifications", "Exception thrown by removal listener", throwable);
            }
        }
    }

    final Segment<K, V>[] newSegmentArray(int n) {
        return new Segment[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) return false;
            l += (long)segmentArray[n].modCount;
        }
        if (l == 0L) return true;
        long l2 = l;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) return false;
            l2 -= (long)segmentArray[n].modCount;
        }
        if (l2 != 0L) return 0 != 0;
        return 1 != 0;
    }

    long longSize() {
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        for (int i = 0; i < segmentArray.length; ++i) {
            l += (long)Math.max(0, segmentArray[i].count);
        }
        return l;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V getIfPresent(Object object) {
        int n = this.hash(Preconditions.checkNotNull(object));
        if ((object = this.segmentFor(n).get(object, n)) == null) {
            this.globalStatsCounter.recordMisses(1);
            return (V)object;
        }
        this.globalStatsCounter.recordHits(1);
        return (V)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getOrDefault(Object object, V v) {
        void var1_2;
        V v2 = this.get(var1_2);
        if (v2 == null) {
            void var2_3;
            return var2_3;
        }
        return v2;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        long l = this.ticker.read();
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = -1L;
        for (int i = 0; i < 3; ++i) {
            int n = segmentArray.length;
            long l3 = 0L;
            for (int j = 0; j < n; ++j) {
                Segment segment = segmentArray[j];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray atomicReferenceArray = segment.table;
                block2: for (int k = 0; k < atomicReferenceArray.length(); ++k) {
                    ReferenceEntry referenceEntry = atomicReferenceArray.get(k);
                    while (true) {
                        if (referenceEntry == null) {
                            continue block2;
                        }
                        V v = segment.getLiveValue(referenceEntry, l);
                        if (v != null && this.valueEquivalence.equivalent(object, v)) break;
                        referenceEntry = referenceEntry.getNext();
                    }
                    return true;
                }
                l3 += (long)segment.modCount;
            }
            if (l3 == l2) break;
            l2 = l3;
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v);
        int n = this.hash(k);
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v);
        int n = this.hash(k);
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object != null && object2 != null) {
            int n = this.hash(object);
            return this.segmentFor(n).remove(object, n, object2);
        }
        return false;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v2);
        if (v == null) {
            return false;
        }
        int n = this.hash(k);
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v);
        int n = this.hash(k);
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        Segment<K, V>[] segmentArray = this.segments;
        int n = segmentArray.length;
        for (int i = 0; i < n; ++i) {
            segmentArray[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet(this);
            return keySet;
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        if (values == null) {
            this.values = values = new Values(this);
            return values;
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet(this);
            return entrySet;
        }
        return entrySet;
    }

    private static <E> ArrayList<E> toArrayList(Collection<E> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    static {
        AbstractQueue<Object> abstractQueue = new ValueReference<Object, Object>(){

            @Override
            public Object get() {
                return null;
            }

            @Override
            public int getWeight() {
                return 0;
            }

            @Override
            public ReferenceEntry<Object, Object> getEntry() {
                return null;
            }

            @Override
            public ValueReference<Object, Object> copyFor(ReferenceQueue<Object> referenceQueue, Object object, ReferenceEntry<Object, Object> referenceEntry) {
                return this;
            }

            @Override
            public boolean isLoading() {
                return false;
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public void notifyNewValue(Object object) {
            }
        };
        UNSET = abstractQueue;
        abstractQueue = new AbstractQueue<Object>(){

            @Override
            public boolean offer(Object object) {
                return true;
            }

            @Override
            public Object peek() {
                return null;
            }

            @Override
            public Object poll() {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Iterator<Object> iterator() {
                return ImmutableSet.of().iterator();
            }
        };
        DISCARDING_QUEUE = abstractQueue;
    }

    static class LocalManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        final LocalCache<K, V> localCache;
        private static final long serialVersionUID = 1L;

        LocalManualCache(CacheBuilder<? super K, ? super V> cacheBuilder) {
            LocalCache<? super K, ? super V> localCache = new LocalCache<K, V>(cacheBuilder, null);
            this(localCache);
        }

        private LocalManualCache(LocalCache<K, V> localCache) {
            this.localCache = localCache;
        }

        @Override
        public V getIfPresent(Object object) {
            return this.localCache.getIfPresent(object);
        }

        @Override
        public void put(K k, V v) {
            this.localCache.put(k, v);
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        Object writeReplace() {
            ManualSerializationProxy<K, V> manualSerializationProxy = new ManualSerializationProxy<K, V>(this.localCache);
            return manualSerializationProxy;
        }
    }

    static class ManualSerializationProxy<K, V>
    extends ForwardingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final long maxWeight;
        final Weigher<K, V> weigher;
        final int concurrencyLevel;
        final RemovalListener<? super K, ? super V> removalListener;
        final Ticker ticker;
        final CacheLoader<? super K, V> loader;
        transient Cache<K, V> delegate;

        ManualSerializationProxy(LocalCache<K, V> localCache) {
            this(localCache.keyStrength, localCache.valueStrength, localCache.keyEquivalence, localCache.valueEquivalence, localCache.expireAfterWriteNanos, localCache.expireAfterAccessNanos, localCache.maxWeight, localCache.weigher, localCache.concurrencyLevel, localCache.removalListener, localCache.ticker, localCache.defaultLoader);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private ManualSerializationProxy(Strength object, Strength strength, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, long l, long l2, long l3, Weigher<K, V> weigher, int n, RemovalListener<? super K, ? super V> removalListener, Ticker ticker, CacheLoader<? super K, V> cacheLoader) {
            void var15_15;
            void var1_3;
            void var14_14;
            void var13_13;
            void var12_12;
            void var11_11;
            void var9_10;
            void var7_9;
            void var5_8;
            void var4_7;
            void var3_6;
            void var2_5;
            this.keyStrength = object;
            this.valueStrength = var2_5;
            this.keyEquivalence = var3_6;
            this.valueEquivalence = var4_7;
            this.expireAfterWriteNanos = var5_8;
            this.expireAfterAccessNanos = var7_9;
            this.maxWeight = var9_10;
            this.weigher = var11_11;
            this.concurrencyLevel = var12_12;
            this.removalListener = var13_13;
            if (var14_14 != Ticker.systemTicker() && var14_14 != CacheBuilder.NULL_TICKER) {
                void var1_4 = var14_14;
            } else {
                Object var1_2 = null;
            }
            this.ticker = var1_3;
            this.loader = var15_15;
        }

        /*
         * Enabled aggressive block sorting
         */
        CacheBuilder<K, V> recreateCacheBuilder() {
            CacheBuilder<K, V> cacheBuilder = CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel).removalListener(this.removalListener);
            cacheBuilder.strictParsing = false;
            if (this.expireAfterWriteNanos > 0L) {
                cacheBuilder.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                cacheBuilder.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.weigher != CacheBuilder.OneWeigher.INSTANCE) {
                cacheBuilder.weigher(this.weigher);
                if (this.maxWeight != -1L) {
                    cacheBuilder.maximumWeight(this.maxWeight);
                }
            } else if (this.maxWeight != -1L) {
                cacheBuilder.maximumSize(this.maxWeight);
            }
            if (this.ticker != null) {
                cacheBuilder.ticker(this.ticker);
            }
            return cacheBuilder;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.delegate = this.recreateCacheBuilder().build();
        }

        private Object readResolve() {
            return this.delegate;
        }

        @Override
        protected Cache<K, V> delegate() {
            return this.delegate;
        }
    }

    final class EntrySet
    extends AbstractCacheSet<Map.Entry<K, V>> {
        EntrySet(ConcurrentMap<?, ?> concurrentMap) {
            super(LocalCache.this, concurrentMap);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            EntryIterator entryIterator = new EntryIterator(LocalCache.this);
            return entryIterator;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = (object = (Map.Entry)object).getKey();
            if (k == null) {
                return false;
            }
            Object v = LocalCache.this.get(k);
            if (v == null) return false;
            if (!LocalCache.this.valueEquivalence.equivalent(object.getValue(), v)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = (object = (Map.Entry)object).getKey();
            if (k == null) return false;
            if (!LocalCache.this.remove(k, object.getValue())) return false;
            return true;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final ConcurrentMap<?, ?> map;

        Values(ConcurrentMap<?, ?> concurrentMap) {
            this.map = concurrentMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<V> iterator() {
            ValueIterator valueIterator = new ValueIterator(LocalCache.this);
            return valueIterator;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    final class KeySet
    extends AbstractCacheSet<K> {
        KeySet(ConcurrentMap<?, ?> concurrentMap) {
            super(LocalCache.this, concurrentMap);
        }

        @Override
        public Iterator<K> iterator() {
            KeyIterator keyIterator = new KeyIterator(LocalCache.this);
            return keyIterator;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            if (this.map.remove(object) == null) return false;
            return true;
        }
    }

    abstract class AbstractCacheSet<T>
    extends AbstractSet<T> {
        final ConcurrentMap<?, ?> map;

        AbstractCacheSet(LocalCache localCache, ConcurrentMap<?, ?> concurrentMap) {
            this.map = concurrentMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator(LocalCache localCache) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) return false;
            if (!this.key.equals((object = (Map.Entry)object).getKey())) return false;
            if (!this.value.equals(object.getValue())) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V v) {
            LocalCache localCache = LocalCache.this;
            Object k = this.key;
            localCache = localCache.put(k, v);
            this.value = v;
            return localCache;
        }

        public String toString() {
            String string = String.valueOf(((WriteThroughEntry)((Object)string2)).getKey());
            String string2 = String.valueOf(((WriteThroughEntry)((Object)string2)).getValue());
            String string3 = String.valueOf(string);
            int n = string3.length();
            String string4 = String.valueOf(string2);
            int n2 = string4.length();
            StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
            return stringBuilder.append(string).append("=").append(string2).toString();
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        ValueIterator(LocalCache localCache) {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        KeyIterator(LocalCache localCache) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment<K, V> currentSegment;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = LocalCache.this.segments.length + -1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (!this.nextInTable()) {
                while (this.nextSegmentIndex >= 0) {
                    Segment<K, V>[] segmentArray = LocalCache.this;
                    segmentArray = segmentArray.segments;
                    int n = this.nextSegmentIndex;
                    this.nextSegmentIndex = n + -1;
                    this.currentSegment = segmentArray[n];
                    if (this.currentSegment.count == 0) continue;
                    this.currentTable = this.currentSegment.table;
                    this.nextTableIndex = this.currentTable.length() + -1;
                    if (!this.nextInTable()) continue;
                    return;
                }
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (!this.advanceTo(this.nextEntry)) {
                        this.nextEntry = this.nextEntry.getNext();
                        continue;
                    }
                    return true;
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                Object object = this.currentTable;
                int n = this.nextTableIndex;
                this.nextTableIndex = n + -1;
                this.nextEntry = object = ((AtomicReferenceArray)object).get(n);
                if (object == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        boolean advanceTo(ReferenceEntry<K, V> referenceEntry) {
            block4: {
                Object object = LocalCache.this;
                object = ((LocalCache)object).ticker;
                long l = ((Ticker)object).read();
                object = referenceEntry.getKey();
                referenceEntry = LocalCache.this.getLiveValue(referenceEntry, l);
                if (referenceEntry == null) break block4;
                try {
                    WriteThroughEntry writeThroughEntry;
                    this.nextExternal = writeThroughEntry = new WriteThroughEntry(object, referenceEntry);
                    return true;
                }
                finally {
                    this.currentSegment.postReadCleanup();
                }
            }
            this.currentSegment.postReadCleanup();
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            if (this.nextExternal == null) return false;
            return true;
        }

        WriteThroughEntry nextEntry() {
            if (((HashIterator)object).nextExternal == null) {
                Object object = new NoSuchElementException();
                throw object;
            }
            ((HashIterator)object).lastReturned = ((HashIterator)object).nextExternal;
            ((HashIterator)object).advance();
            return ((HashIterator)object).lastReturned;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            Preconditions.checkState(bl);
            LocalCache.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head;

        AccessQueue() {
            AbstractReferenceEntry abstractReferenceEntry;
            this.head = abstractReferenceEntry = new AbstractReferenceEntry<K, V>(this){
                ReferenceEntry<K, V> nextAccess = this;
                ReferenceEntry<K, V> previousAccess = this;

                @Override
                public long getAccessTime() {
                    return Long.MAX_VALUE;
                }

                @Override
                public void setAccessTime(long l) {
                }

                @Override
                public ReferenceEntry<K, V> getNextInAccessQueue() {
                    return this.nextAccess;
                }

                @Override
                public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
                    this.nextAccess = referenceEntry;
                }

                @Override
                public ReferenceEntry<K, V> getPreviousInAccessQueue() {
                    return this.previousAccess;
                }

                @Override
                public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
                    this.previousAccess = referenceEntry;
                }
            };
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> referenceEntry) {
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry.getNextInAccessQueue());
            LocalCache.connectAccessOrder(this.head.getPreviousInAccessQueue(), referenceEntry);
            LocalCache.connectAccessOrder(referenceEntry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            return referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object referenceEntry) {
            ReferenceEntry referenceEntry2 = referenceEntry;
            referenceEntry = referenceEntry2.getPreviousInAccessQueue();
            ReferenceEntry referenceEntry3 = referenceEntry2.getNextInAccessQueue();
            LocalCache.connectAccessOrder(referenceEntry, referenceEntry3);
            LocalCache.nullifyAccessOrder(referenceEntry2);
            if (referenceEntry3 == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (((ReferenceEntry)object).getNextInAccessQueue() == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEmpty() {
            if (this.head.getNextInAccessQueue() != this.head) return false;
            return true;
        }

        @Override
        public int size() {
            int n = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInAccessQueue()) {
                ++n;
            }
            return n;
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue();
            while (referenceEntry != this.head) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            AbstractSequentialIterator abstractSequentialIterator = new AbstractSequentialIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> referenceEntry) {
                    if ((referenceEntry = referenceEntry.getNextInAccessQueue()) == head) {
                        return null;
                    }
                    return referenceEntry;
                }
            };
            return abstractSequentialIterator;
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head;

        WriteQueue() {
            AbstractReferenceEntry abstractReferenceEntry;
            this.head = abstractReferenceEntry = new AbstractReferenceEntry<K, V>(this){
                ReferenceEntry<K, V> nextWrite = this;
                ReferenceEntry<K, V> previousWrite = this;

                @Override
                public long getWriteTime() {
                    return Long.MAX_VALUE;
                }

                @Override
                public void setWriteTime(long l) {
                }

                @Override
                public ReferenceEntry<K, V> getNextInWriteQueue() {
                    return this.nextWrite;
                }

                @Override
                public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
                    this.nextWrite = referenceEntry;
                }

                @Override
                public ReferenceEntry<K, V> getPreviousInWriteQueue() {
                    return this.previousWrite;
                }

                @Override
                public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
                    this.previousWrite = referenceEntry;
                }
            };
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> referenceEntry) {
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry.getNextInWriteQueue());
            LocalCache.connectWriteOrder(this.head.getPreviousInWriteQueue(), referenceEntry);
            LocalCache.connectWriteOrder(referenceEntry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            return referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object referenceEntry) {
            ReferenceEntry referenceEntry2 = referenceEntry;
            referenceEntry = referenceEntry2.getPreviousInWriteQueue();
            ReferenceEntry referenceEntry3 = referenceEntry2.getNextInWriteQueue();
            LocalCache.connectWriteOrder(referenceEntry, referenceEntry3);
            LocalCache.nullifyWriteOrder(referenceEntry2);
            if (referenceEntry3 == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (((ReferenceEntry)object).getNextInWriteQueue() == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEmpty() {
            if (this.head.getNextInWriteQueue() != this.head) return false;
            return true;
        }

        @Override
        public int size() {
            int n = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInWriteQueue()) {
                ++n;
            }
            return n;
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue();
            while (referenceEntry != this.head) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextInWriteQueue(this.head);
            this.head.setPreviousInWriteQueue(this.head);
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            AbstractSequentialIterator abstractSequentialIterator = new AbstractSequentialIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> referenceEntry) {
                    if ((referenceEntry = referenceEntry.getNextInWriteQueue()) == head) {
                        return null;
                    }
                    return referenceEntry;
                }
            };
            return abstractSequentialIterator;
        }
    }

    static class LoadingValueReference<K, V>
    implements ValueReference<K, V> {
        volatile ValueReference<K, V> oldValue;
        final SettableFuture<V> futureValue = SettableFuture.create();
        final Stopwatch stopwatch = Stopwatch.createUnstarted();

        public LoadingValueReference() {
            this(LocalCache.unset());
        }

        public LoadingValueReference(ValueReference<K, V> valueReference) {
            this.oldValue = valueReference;
        }

        @Override
        public boolean isLoading() {
            return true;
        }

        @Override
        public boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public int getWeight() {
            return this.oldValue.getWeight();
        }

        public boolean set(V v) {
            return this.futureValue.set(v);
        }

        public boolean setException(Throwable throwable) {
            return this.futureValue.setException(throwable);
        }

        private ListenableFuture<V> fullyFailedFuture(Throwable throwable) {
            return Futures.immediateFailedFuture(throwable);
        }

        @Override
        public void notifyNewValue(V v) {
            if (v != null) {
                this.set(v);
                return;
            }
            this.oldValue = LocalCache.unset();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListenableFuture<V> loadFuture(K object, CacheLoader<? super K, V> function) {
            try {
                void var1_7;
                Function function2;
                this.stopwatch.start();
                V v = this.oldValue.get();
                if (v == null) {
                    ListenableFuture listenableFuture;
                    void var0_2;
                    Object v2 = ((CacheLoader)((Object)function2)).load(var1_7);
                    boolean bl = this.set(v2);
                    if (bl) {
                        SettableFuture<V> settableFuture;
                        SettableFuture<V> settableFuture2 = settableFuture = this.futureValue;
                        return var0_2;
                    }
                    ListenableFuture listenableFuture2 = listenableFuture = Futures.immediateFuture(v2);
                    return var0_2;
                }
                ListenableFuture<V> listenableFuture = ((CacheLoader)((Object)function2)).reload(var1_7, v);
                if (listenableFuture == null) {
                    return Futures.immediateFuture(null);
                }
                function2 = new Function<V, V>(){

                    @Override
                    public V apply(V v) {
                        this.set(v);
                        return v;
                    }
                };
                return Futures.transform(listenableFuture, function2, MoreExecutors.directExecutor());
            }
            catch (Throwable throwable) {
                void var0_5;
                if (this.setException(throwable)) {
                    SettableFuture<V> settableFuture = this.futureValue;
                } else {
                    ListenableFuture<V> listenableFuture = this.fullyFailedFuture(throwable);
                }
                if (!(throwable instanceof InterruptedException)) return var0_5;
                Thread.currentThread().interrupt();
                return var0_5;
            }
        }

        public long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        public V get() {
            return this.oldValue.get();
        }

        public ValueReference<K, V> getOldValue() {
            return this.oldValue;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            return this;
        }
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final LocalCache<K, V> map;
        volatile int count;
        long totalWeight;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final long maxSegmentWeight;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount;
        final Queue<ReferenceEntry<K, V>> writeQueue;
        final Queue<ReferenceEntry<K, V>> accessQueue;
        final AbstractCache$StatsCounter statsCounter;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        Segment(LocalCache<K, V> queue, int n, long l, AbstractCache$StatsCounter statsCounter) {
            void var2_10;
            void var2_8;
            void var2_6;
            void var2_4;
            void var5_16;
            void var3_15;
            AtomicInteger atomicInteger;
            this.readCount = atomicInteger = new AtomicInteger();
            this.map = queue;
            this.maxSegmentWeight = var3_15;
            this.statsCounter = (AbstractCache$StatsCounter)Preconditions.checkNotNull(var5_16);
            this.initTable(this.newEntryArray(n));
            if (((LocalCache)((Object)queue)).usesKeyReferences()) {
                ReferenceQueue referenceQueue = new ReferenceQueue();
            } else {
                Object var2_14 = null;
            }
            this.keyReferenceQueue = var2_4;
            if (((LocalCache)((Object)queue)).usesValueReferences()) {
                ReferenceQueue referenceQueue = new ReferenceQueue();
            } else {
                Object var2_13 = null;
            }
            this.valueReferenceQueue = var2_6;
            if (((LocalCache)((Object)queue)).usesAccessQueue()) {
                ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
            } else {
                Queue queue2 = LocalCache.discardingQueue();
            }
            this.recencyQueue = var2_8;
            if (((LocalCache)((Object)queue)).usesWriteQueue()) {
                WriteQueue writeQueue = new WriteQueue();
            } else {
                Queue queue3 = LocalCache.discardingQueue();
            }
            this.writeQueue = var2_10;
            queue = ((LocalCache)((Object)queue)).usesAccessQueue() ? new AccessQueue() : LocalCache.discardingQueue();
            this.accessQueue = queue;
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int n) {
            Serializable serializable = new AtomicReferenceArray(n);
            return serializable;
        }

        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray) {
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (!this.map.customWeigher() && (long)this.threshold == this.maxSegmentWeight) {
                ++this.threshold;
            }
            this.table = atomicReferenceArray;
        }

        ReferenceEntry<K, V> newEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(k), n, referenceEntry);
        }

        ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            if (referenceEntry.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            V v = valueReference.get();
            if (v == null && valueReference.isActive()) {
                return null;
            }
            referenceEntry = this.map.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
            referenceEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, v, referenceEntry));
            return referenceEntry;
        }

        /*
         * Enabled aggressive block sorting
         */
        void setValue(ReferenceEntry<K, V> referenceEntry, K k, V v, long l) {
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            int n = this.map.weigher.weigh(k, v);
            boolean bl = n >= 0;
            Preconditions.checkState(bl, "Weights must be non-negative");
            referenceEntry.setValueReference(this.map.valueStrength.referenceValue(this, referenceEntry, v, n));
            this.recordWrite(referenceEntry, n, l);
            valueReference.notifyNewValue(v);
        }

        V get(Object referenceEntry, int n) {
            block8: {
                long l;
                block9: {
                    int n2 = this.count;
                    if (n2 == 0) break block8;
                    l = this.map.ticker.read();
                    referenceEntry = this.getLiveEntry(referenceEntry, n, l);
                    if (referenceEntry != null) break block9;
                    this.postReadCleanup();
                    return null;
                }
                try {
                    V v = referenceEntry.getValueReference().get();
                    if (v != null) {
                        this.recordRead(referenceEntry, l);
                        referenceEntry = this.scheduleRefresh(referenceEntry, referenceEntry.getKey(), n, v, l, this.map.defaultLoader);
                        return (V)referenceEntry;
                    }
                    this.tryDrainReferenceQueues();
                }
                finally {
                    this.postReadCleanup();
                }
            }
            return null;
        }

        ListenableFuture<V> loadAsync(final K k, final int n, final LoadingValueReference<K, V> loadingValueReference, CacheLoader<? super K, V> object) {
            object = loadingValueReference.loadFuture((K)k, (CacheLoader<? super K, V>)object);
            Runnable runnable = new Runnable((ListenableFuture)object){
                final /* synthetic */ ListenableFuture val$loadingFuture;
                {
                    this.val$loadingFuture = listenableFuture;
                }

                @Override
                public void run() {
                    try {
                        this.getAndRecordStats(k, n, loadingValueReference, this.val$loadingFuture);
                        return;
                    }
                    catch (Throwable throwable) {
                        logger.logp(Level.WARNING, "androidx.test.espresso.core.internal.deps.guava.cache.LocalCache$Segment$1", "run", "Exception thrown during refresh", throwable);
                        loadingValueReference.setException(throwable);
                        return;
                    }
                }
            };
            object.addListener(runnable, MoreExecutors.directExecutor());
            return object;
        }

        /*
         * Unable to fully structure code
         */
        V getAndRecordStats(K var1_1, int var2_2, LoadingValueReference<K, V> var3_3, ListenableFuture<V> var4_4) throws ExecutionException {
            block7: {
                var5_8 = Uninterruptibles.getUninterruptibly(var4_4);
                if (var5_8 != null) ** GOTO lbl14
                try {
                    var6_9 = String.valueOf(var1_1);
                    var7_10 = String.valueOf(var6_9).length();
                    var7_10 += 35;
                }
                catch (Throwable var4_7) {
                    ** continue;
                }
                var8_11 = new StringBuilder(var7_10);
                var4_4 = new CacheLoader.InvalidCacheLoadException(var8_11.append("CacheLoader returned null for key ").append(var6_9).append(".").toString());
                throw var4_4;
lbl14:
                // 1 sources

                this.statsCounter.recordLoadSuccess(var3_3.elapsedNanos());
                this.storeLoadedValue(var1_1, var2_2, var3_3, var5_8);
                if (var5_8 != null) break block7;
                this.statsCounter.recordLoadException(var3_3.elapsedNanos());
                this.removeLoadingValue(var1_1, var2_2, var3_3);
            }
            return var5_8;
            catch (Throwable var4_5) {
                var5_8 = null;
lbl25:
                // 2 sources

                while (true) {
                    if (var5_8 == null) {
                        this.statsCounter.recordLoadException(var3_3.elapsedNanos());
                        this.removeLoadingValue(var1_1, var2_2, var3_3);
                    }
                    throw var4_6;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        V scheduleRefresh(ReferenceEntry<K, V> referenceEntry, K k, int n, V v, long l, CacheLoader<? super K, V> cacheLoader) {
            void var4_5;
            void var7_7;
            void var3_4;
            void var2_3;
            V v2;
            void var1_2;
            void var5_6;
            if (this.map.refreshes() && var5_6 - var1_2.getWriteTime() > this.map.refreshNanos && !var1_2.getValueReference().isLoading() && (v2 = this.refresh(var2_3, (int)var3_4, (CacheLoader<? super K, V>)var7_7, true)) != null) {
                return v2;
            }
            return var4_5;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V refresh(K k, int n, CacheLoader<? super K, V> cacheLoader, boolean bl) {
            Object object;
            LoadingValueReference<K, V> loadingValueReference = ((Segment)object).insertLoadingValueReference(k, n, bl);
            if (loadingValueReference == null) {
                return null;
            }
            if (!(object = ((Segment)object).loadAsync(k, n, loadingValueReference, cacheLoader)).isDone()) return null;
            try {
                object = Uninterruptibles.getUninterruptibly(object);
                return (V)object;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        LoadingValueReference<K, V> insertLoadingValueReference(K object, int n, boolean bl) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                int n3 = n & n2 + -1;
                for (ReferenceEntry referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    boolean bl2;
                    K k = referenceEntry2.getKey();
                    int n4 = referenceEntry2.getHash();
                    if (n4 != n || k == null || !(bl2 = this.map.keyEquivalence.equivalent(object, k))) continue;
                    object = referenceEntry2.getValueReference();
                    n = object.isLoading() ? 1 : 0;
                    if (n != 0) return null;
                    if (bl) {
                        long l2;
                        long l3 = referenceEntry2.getWriteTime();
                        long l4 = l - l3;
                        if (l4 < (l2 = this.map.refreshNanos)) return null;
                    }
                    ++this.modCount;
                    LoadingValueReference loadingValueReference = new LoadingValueReference(object);
                    referenceEntry2.setValueReference(loadingValueReference);
                    return loadingValueReference;
                }
                ++this.modCount;
                LoadingValueReference loadingValueReference = new LoadingValueReference();
                object = this.newEntry(object, n, referenceEntry);
                object.setValueReference(loadingValueReference);
                atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                return loadingValueReference;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void drainReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.drainKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.drainValueReferenceQueue();
                return;
            }
        }

        void drainKeyReferenceQueue() {
            Object object;
            int n = 0;
            while ((object = this.keyReferenceQueue.poll()) != null) {
                object = (ReferenceEntry)object;
                this.map.reclaimKey((ReferenceEntry<K, V>)object);
                if (++n != 16) continue;
            }
        }

        void drainValueReferenceQueue() {
            Object object;
            int n = 0;
            while ((object = this.valueReferenceQueue.poll()) != null) {
                object = (ValueReference)object;
                this.map.reclaimValue((ValueReference<K, V>)object);
                if (++n != 16) continue;
            }
        }

        void clearReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.clearKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.clearValueReferenceQueue();
                return;
            }
        }

        void clearKeyReferenceQueue() {
            while (this.keyReferenceQueue.poll() != null) {
            }
        }

        void clearValueReferenceQueue() {
            while (this.valueReferenceQueue.poll() != null) {
            }
        }

        void recordRead(ReferenceEntry<K, V> referenceEntry, long l) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            this.recencyQueue.add(referenceEntry);
        }

        void recordLockedRead(ReferenceEntry<K, V> referenceEntry, long l) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            this.accessQueue.add(referenceEntry);
        }

        void recordWrite(ReferenceEntry<K, V> referenceEntry, int n, long l) {
            this.drainRecencyQueue();
            this.totalWeight += (long)n;
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            if (this.map.recordsWrite()) {
                referenceEntry.setWriteTime(l);
            }
            this.accessQueue.add(referenceEntry);
            this.writeQueue.add(referenceEntry);
        }

        void drainRecencyQueue() {
            ReferenceEntry<K, V> referenceEntry;
            while ((referenceEntry = this.recencyQueue.poll()) != null) {
                if (!this.accessQueue.contains(referenceEntry)) continue;
                this.accessQueue.add(referenceEntry);
            }
        }

        void tryExpireEntries(long l) {
            if (this.tryLock()) {
                try {
                    this.expireEntries(l);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void expireEntries(long l) {
            Object object;
            ReferenceEntry<K, V> referenceEntry;
            ((Segment)object).drainRecencyQueue();
            while ((referenceEntry = ((Segment)object).writeQueue.peek()) != null && ((Segment)object).map.isExpired(referenceEntry, l)) {
                if (((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) continue;
                object = new AssertionError();
                throw object;
            }
            while ((referenceEntry = ((Segment)object).accessQueue.peek()) != null && ((Segment)object).map.isExpired(referenceEntry, l)) {
                if (((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) continue;
                object = new AssertionError();
                throw object;
            }
        }

        void enqueueNotification(K object, int n, V v, int n2, RemovalCause removalCause) {
            this.totalWeight -= (long)n2;
            if (removalCause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                object = RemovalNotification.create(object, v, removalCause);
                this.map.removalNotificationQueue.offer(object);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void evictEntries(ReferenceEntry<K, V> referenceEntry) {
            Object object;
            if (!((Segment)object).map.evictsBySize()) {
                return;
            }
            ((Segment)object).drainRecencyQueue();
            if ((long)referenceEntry.getValueReference().getWeight() > ((Segment)object).maxSegmentWeight && !((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                object = new AssertionError();
                throw object;
            }
            do {
                if (((Segment)object).totalWeight > ((Segment)object).maxSegmentWeight) continue;
                return;
            } while (((Segment)object).removeEntry(referenceEntry = ((Segment)object).getNextEvictable(), referenceEntry.getHash(), RemovalCause.SIZE));
            object = new AssertionError();
            throw object;
        }

        ReferenceEntry<K, V> getNextEvictable() {
            ReferenceEntry referenceEntry22;
            block1: {
                Object object;
                for (ReferenceEntry referenceEntry22 : ((Segment)object).accessQueue) {
                    if (referenceEntry22.getValueReference().getWeight() <= 0) continue;
                    break block1;
                }
                object = new AssertionError();
                throw object;
            }
            return referenceEntry22;
        }

        ReferenceEntry<K, V> getFirst(int n) {
            Serializable serializable = ((Segment)serializable).table;
            return (ReferenceEntry)((AtomicReferenceArray)serializable).get(n & ((AtomicReferenceArray)serializable).length() + -1);
        }

        /*
         * Enabled aggressive block sorting
         */
        ReferenceEntry<K, V> getEntry(Object object, int n) {
            ReferenceEntry<K, V> referenceEntry = this.getFirst(n);
            while (referenceEntry != null) {
                if (referenceEntry.getHash() == n) {
                    K k = referenceEntry.getKey();
                    if (k == null) {
                        this.tryDrainReferenceQueues();
                    } else if (this.map.keyEquivalence.equivalent(object, k)) {
                        return referenceEntry;
                    }
                }
                referenceEntry = referenceEntry.getNext();
            }
            return null;
        }

        ReferenceEntry<K, V> getLiveEntry(Object referenceEntry, int n, long l) {
            if ((referenceEntry = this.getEntry(referenceEntry, n)) == null) {
                return null;
            }
            if (this.map.isExpired(referenceEntry, l)) {
                this.tryExpireEntries(l);
                return null;
            }
            return referenceEntry;
        }

        V getLiveValue(ReferenceEntry<K, V> referenceEntry, long l) {
            if (referenceEntry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V v = referenceEntry.getValueReference().get();
            if (v == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired(referenceEntry, l)) {
                this.tryExpireEntries(l);
                return null;
            }
            return v;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean containsKey(Object referenceEntry, int n) {
            block5: {
                void var1_5;
                block6: {
                    ReferenceEntry<K, V> referenceEntry2;
                    try {
                        void var2_9;
                        int n2 = this.count;
                        if (n2 == 0) break block5;
                        referenceEntry2 = this.getLiveEntry(referenceEntry, (int)var2_9, this.map.ticker.read());
                        if (referenceEntry2 == null) {
                            this.postReadCleanup();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        this.postReadCleanup();
                        throw throwable;
                    }
                    {
                        V v = referenceEntry2.getValueReference().get();
                        if (v != null) {
                            boolean bl = true;
                            break block6;
                        }
                        boolean bl = false;
                    }
                }
                this.postReadCleanup();
                return (boolean)var1_5;
            }
            this.postReadCleanup();
            return false;
        }

        /*
         * Exception decompiling
         */
        V put(K var1_1, int var2_4, V var3_6, boolean var4_7) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[FORLOOP]], but top level block is 12[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         */
        void expand() {
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n = atomicReferenceArray.length();
            if (n >= 0x40000000) {
                return;
            }
            int n2 = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray2 = this.newEntryArray(n + n);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n3 = atomicReferenceArray2.length() + -1;
            int n4 = 0;
            while (true) {
                if (n4 >= n) {
                    this.table = atomicReferenceArray2;
                    this.count = n2;
                    return;
                }
                ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(n4);
                if (referenceEntry != null) {
                    ReferenceEntry<K, V> referenceEntry2;
                    int n5 = referenceEntry.getHash() & n3;
                    if (referenceEntry2 == null) {
                        atomicReferenceArray2.set(n5, referenceEntry);
                    } else {
                        ReferenceEntry<K, V> referenceEntry3 = referenceEntry;
                        for (referenceEntry2 = referenceEntry.getNext(); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                            int n6 = referenceEntry2.getHash() & n3;
                            if (n6 != n5) {
                                referenceEntry3 = referenceEntry2;
                            } else {
                                n6 = n5;
                            }
                            n5 = n6;
                        }
                        atomicReferenceArray2.set(n5, referenceEntry3);
                        for (ReferenceEntry<K, V> referenceEntry4 = referenceEntry; referenceEntry4 != referenceEntry3; referenceEntry4 = referenceEntry4.getNext()) {
                            int n7 = referenceEntry4.getHash() & n3;
                            ReferenceEntry<K, V> referenceEntry5 = this.copyEntry(referenceEntry4, atomicReferenceArray2.get(n7));
                            if (referenceEntry5 != null) {
                                atomicReferenceArray2.set(n7, referenceEntry5);
                                continue;
                            }
                            this.removeCollectedEntry(referenceEntry4);
                            --n2;
                        }
                    }
                }
                ++n4;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean replace(K object, int n, V object2, V v) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n2;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n4);
                while (referenceEntry2 != null) {
                    K k = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 == n2 && k != null && (n5 = (int)(this.map.keyEquivalence.equivalent(object, k) ? 1 : 0)) != 0) {
                        void var3_5;
                        ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                        V v2 = valueReference.get();
                        if (v2 == null) {
                            boolean bl = valueReference.isActive();
                            if (!bl) return false;
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry, referenceEntry2, k, n2, v2, valueReference, RemovalCause.COLLECTED);
                            n2 = this.count;
                            atomicReferenceArray.set(n4, (ReferenceEntry<K, V>)object);
                            this.count = --n2;
                            return false;
                        }
                        object2 = this.map.valueEquivalence.equivalent(var3_5, v2);
                        if (object2 != false) {
                            void var4_7;
                            ++this.modCount;
                            object2 = valueReference.getWeight();
                            this.enqueueNotification(object, n2, v2, (int)object2, RemovalCause.REPLACED);
                            this.setValue(referenceEntry2, object, var4_7, l);
                            this.evictEntries(referenceEntry2);
                            return true;
                        }
                        this.recordLockedRead(referenceEntry2, l);
                        return false;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V replace(K object, int n, V v) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n2;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n4);
                while (referenceEntry2 != null) {
                    K k = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 == n2 && k != null && (n5 = (int)(this.map.keyEquivalence.equivalent(object, k) ? 1 : 0)) != 0) {
                        void var3_5;
                        ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                        V v2 = valueReference.get();
                        if (v2 == null) {
                            boolean bl = valueReference.isActive();
                            if (!bl) return null;
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry, referenceEntry2, k, n2, v2, valueReference, RemovalCause.COLLECTED);
                            n2 = this.count;
                            atomicReferenceArray.set(n4, (ReferenceEntry<K, V>)object);
                            this.count = --n2;
                            return null;
                        }
                        ++this.modCount;
                        int n6 = valueReference.getWeight();
                        this.enqueueNotification(object, n2, v2, n6, RemovalCause.REPLACED);
                        this.setValue(referenceEntry2, object, var3_5, l);
                        this.evictEntries(referenceEntry2);
                        return v2;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V remove(Object object, int n) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                this.preWriteCleanup(this.map.ticker.read());
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                int n3 = n & n2 + -1;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3);
                while (referenceEntry2 != null) {
                    K k = referenceEntry2.getKey();
                    int n4 = referenceEntry2.getHash();
                    if (n4 == n && k != null && (n4 = (int)(this.map.keyEquivalence.equivalent(object, k) ? 1 : 0)) != 0) {
                        ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                        V v = valueReference.get();
                        if (v != null) {
                            object = RemovalCause.EXPLICIT;
                        } else {
                            boolean bl = valueReference.isActive();
                            if (!bl) return null;
                            object = RemovalCause.COLLECTED;
                        }
                        ++this.modCount;
                        object = this.removeValueFromChain(referenceEntry, referenceEntry2, k, n, v, valueReference, (RemovalCause)((Object)object));
                        n = this.count;
                        atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                        this.count = --n;
                        return v;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean remove(Object var1_1, int var2_6, Object var3_8) {
            block9: {
                block10: {
                    block8: {
                        this.lock();
                        try {
                            this.preWriteCleanup(this.map.ticker.read());
                            var5_10 = this.table;
                            var4_11 = var5_10.length();
                            var6_13 = var2_6 & var4_11 + -1;
                            var4_12 = var7_14 = var5_10.get(var6_13);
lbl9:
                            // 2 sources

                            while (var4_12 != null) {
                                var8_15 = var4_12.getKey();
                                var9_16 = var4_12.getHash();
                                if (var9_16 != var2_6 || var8_15 == null || (var9_16 = (int)this.map.keyEquivalence.equivalent(var1_1, var8_15)) == 0) ** GOTO lbl-1000
                                var9_17 = var4_12.getValueReference();
                                var10_18 = var9_17.get();
                                var1_2 = this.map.valueEquivalence.equivalent(var3_8, var10_18);
                                if (var1_2) {
                                    var1_3 = RemovalCause.EXPLICIT;
                                    break block8;
                                }
                                ** GOTO lbl-1000
                            }
                            break block9;
                        }
                        catch (Throwable var1_5) {
                            this.unlock();
                            this.postWriteCleanup();
                            throw var1_5;
                        }
                    }
lbl26:
                    // 2 sources

                    while (true) {
                        ++this.modCount;
                        var2_7 /* !! */  = this.removeValueFromChain(var7_14, var4_12, var8_15, var2_6, var10_18, var9_17, var1_3);
                        var3_9 = this.count;
                        var5_10.set(var6_13, var2_7 /* !! */ );
                        this.count = --var3_9;
                        var2_7 /* !! */  = RemovalCause.EXPLICIT;
                        var1_4 = var1_3 == var2_7 /* !! */ ;
                        this.unlock();
                        this.postWriteCleanup();
                        return var1_4;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var10_18 != null || !(var1_2 = var9_17.isActive())) break block10;
                        var1_3 = RemovalCause.COLLECTED;
                        ** continue;
                    }
                }
                this.unlock();
                this.postWriteCleanup();
                return false;
lbl-1000:
                // 1 sources

                {
                    var4_12 = var4_12.getNext();
                    ** GOTO lbl9
                }
            }
            this.unlock();
            this.postWriteCleanup();
            return false;
        }

        /*
         * Exception decompiling
         */
        boolean storeLoadedValue(K var1_1, int var2_3, LoadingValueReference<K, V> var3_5, V var4_6) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void clear() {
            if (this.count == 0) return;
            this.lock();
            this.preWriteCleanup(this.map.ticker.read());
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n = 0;
            block5: while (true) {
                int n2;
                if (n >= (n2 = atomicReferenceArray.length())) {
                    for (n = 0; n < (n2 = atomicReferenceArray.length()); ++n) {
                        atomicReferenceArray.set(n, null);
                    }
                    this.clearReferenceQueues();
                    this.writeQueue.clear();
                    this.accessQueue.clear();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                    return;
                }
                ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(n);
                while (true) {
                    if (referenceEntry == null) {
                        ++n;
                        continue block5;
                    }
                    boolean bl = referenceEntry.getValueReference().isActive();
                    if (bl) {
                        K k = referenceEntry.getKey();
                        V v = referenceEntry.getValueReference().get();
                        RemovalCause removalCause = k != null && v != null ? RemovalCause.EXPLICIT : RemovalCause.COLLECTED;
                        this.enqueueNotification(k, referenceEntry.getHash(), v, referenceEntry.getValueReference().getWeight(), removalCause);
                    }
                    referenceEntry = referenceEntry.getNext();
                }
                break;
            }
        }

        ReferenceEntry<K, V> removeValueFromChain(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2, K k, int n, V v, ValueReference<K, V> valueReference, RemovalCause removalCause) {
            this.enqueueNotification(k, n, v, valueReference.getWeight(), removalCause);
            this.writeQueue.remove(referenceEntry2);
            this.accessQueue.remove(referenceEntry2);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return referenceEntry;
            }
            return this.removeEntryFromChain(referenceEntry, referenceEntry2);
        }

        /*
         * Enabled aggressive block sorting
         */
        ReferenceEntry<K, V> removeEntryFromChain(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            int n = this.count;
            ReferenceEntry<K, V> referenceEntry3 = referenceEntry2.getNext();
            ReferenceEntry<K, V> referenceEntry4 = referenceEntry;
            while (true) {
                int n2;
                if (referenceEntry4 == referenceEntry2) {
                    this.count = n;
                    return referenceEntry3;
                }
                referenceEntry = this.copyEntry(referenceEntry4, referenceEntry3);
                if (referenceEntry == null) {
                    this.removeCollectedEntry(referenceEntry4);
                    n2 = n + -1;
                } else {
                    referenceEntry3 = referenceEntry;
                    n2 = n;
                }
                referenceEntry4 = referenceEntry4.getNext();
                n = n2;
            }
        }

        void removeCollectedEntry(ReferenceEntry<K, V> referenceEntry) {
            this.enqueueNotification(referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry.getValueReference().get(), referenceEntry.getValueReference().getWeight(), RemovalCause.COLLECTED);
            this.writeQueue.remove(referenceEntry);
            this.accessQueue.remove(referenceEntry);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean reclaimKey(ReferenceEntry<K, V> referenceEntry, int n) {
            ReferenceEntry<K, V> referenceEntry2;
            ReferenceEntry<K, V> referenceEntry3;
            int n2;
            int n3;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            this.lock();
            try {
                atomicReferenceArray = this.table;
                int n4 = atomicReferenceArray.length();
                n2 = n3 & n4 + -1;
                referenceEntry2 = referenceEntry3 = atomicReferenceArray.get(n2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
            while (true) {
                if (referenceEntry2 == null) {
                    this.unlock();
                    this.postWriteCleanup();
                    return false;
                }
                if (referenceEntry2 == referenceEntry) {
                    ++this.modCount;
                    K k = referenceEntry2.getKey();
                    V v = referenceEntry2.getValueReference().get();
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    ReferenceEntry<K, V> referenceEntry4 = this.removeValueFromChain(referenceEntry3, referenceEntry2, k, n3, v, valueReference, RemovalCause.COLLECTED);
                    n3 = this.count;
                    atomicReferenceArray.set(n2, referenceEntry4);
                    this.count = --n3;
                    return true;
                }
                referenceEntry2 = referenceEntry2.getNext();
                continue;
                break;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean reclaimValue(K object, int n, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n2;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n4); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    void var3_8;
                    K k = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 != n2 || k == null || (n5 = (int)(this.map.keyEquivalence.equivalent(object, k) ? 1 : 0)) == 0) break block7;
                    ValueReference<K, V> valueReference2 = referenceEntry2.getValueReference();
                    if (valueReference2 != var3_8) break block8;
                    ++this.modCount;
                    Object v = var3_8.get();
                    ReferenceEntry<K, V> referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, k, n2, v, (ValueReference<K, V>)var3_8, RemovalCause.COLLECTED);
                    n2 = this.count;
                    atomicReferenceArray.set(n4, referenceEntry3);
                    this.count = --n2;
                }
            }
            catch (Throwable throwable) {
                this.unlock();
                if (this.isHeldByCurrentThread()) {
                    throw throwable;
                }
                this.postWriteCleanup();
                throw throwable;
            }
            {
                block7: {
                    block8: {
                        this.unlock();
                        if (this.isHeldByCurrentThread()) return true;
                        this.postWriteCleanup();
                        return true;
                    }
                    this.unlock();
                    if (this.isHeldByCurrentThread()) return false;
                    this.postWriteCleanup();
                    return false;
                }
                continue;
            }
            this.unlock();
            if (this.isHeldByCurrentThread()) return false;
            this.postWriteCleanup();
            return false;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean removeLoadingValue(K object, int n, LoadingValueReference<K, V> loadingValueReference) {
            block9: {
                ReferenceEntry referenceEntry;
                void var2_5;
                this.lock();
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                int n3 = var2_5 & n2 + -1;
                for (ReferenceEntry referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    void var3_6;
                    boolean bl;
                    K k = referenceEntry2.getKey();
                    int n4 = referenceEntry2.getHash();
                    if (n4 != var2_5 || k == null || !(bl = this.map.keyEquivalence.equivalent(object, k))) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    if (valueReference == var3_6) {
                        boolean bl2 = var3_6.isActive();
                        if (bl2) {
                            referenceEntry2.setValueReference(var3_6.getOldValue());
                            return true;
                        }
                        atomicReferenceArray.set(n3, this.removeEntryFromChain(referenceEntry, referenceEntry2));
                        return true;
                    }
                    break block9;
                }
                this.unlock();
                this.postWriteCleanup();
                return false;
            }
            this.unlock();
            this.postWriteCleanup();
            return false;
        }

        boolean removeEntry(ReferenceEntry<K, V> referenceEntry, int n, RemovalCause removalCause) {
            ReferenceEntry<K, V> referenceEntry2;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() + -1;
            for (ReferenceEntry<K, V> referenceEntry3 = referenceEntry2 = atomicReferenceArray.get(n2); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                if (referenceEntry3 != referenceEntry) {
                    continue;
                }
                ++this.modCount;
                referenceEntry = referenceEntry3.getKey();
                ValueReference<K, V> valueReference = referenceEntry3.getValueReference();
                valueReference = valueReference.get();
                ValueReference<K, V> valueReference2 = referenceEntry3.getValueReference();
                referenceEntry = this.removeValueFromChain(referenceEntry2, referenceEntry3, referenceEntry, n, valueReference, valueReference2, removalCause);
                n = this.count;
                atomicReferenceArray.set(n2, referenceEntry);
                this.count = n + -1;
                return true;
            }
            return false;
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
                return;
            }
        }

        void preWriteCleanup(long l) {
            this.runLockedCleanup(l);
        }

        void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        void cleanUp() {
            this.runLockedCleanup(this.map.ticker.read());
            this.runUnlockedCleanup();
        }

        void runLockedCleanup(long l) {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries(l);
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
                return;
            }
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        final int weight;

        WeightedStrongValueReference(V v, int n) {
            super(v);
            this.weight = n;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedSoftValueReference<K, V>
    extends SoftValueReference<K, V> {
        final int weight;

        WeightedSoftValueReference(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry, int n) {
            super(referenceQueue, v, referenceEntry);
            this.weight = n;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            WeightedSoftValueReference<K, V> weightedSoftValueReference = new WeightedSoftValueReference<K, V>(referenceQueue, v, referenceEntry, this.weight);
            return weightedSoftValueReference;
        }
    }

    static final class WeightedWeakValueReference<K, V>
    extends WeakValueReference<K, V> {
        final int weight;

        WeightedWeakValueReference(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry, int n) {
            super(referenceQueue, v, referenceEntry);
            this.weight = n;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            WeightedWeakValueReference<K, V> weightedWeakValueReference = new WeightedWeakValueReference<K, V>(referenceQueue, v, referenceEntry, this.weight);
            return weightedWeakValueReference;
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V v) {
            this.referent = v;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void notifyNewValue(V v) {
        }
    }

    static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V v) {
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            SoftValueReference<K, V> softValueReference = new SoftValueReference<K, V>(referenceQueue, v, referenceEntry);
            return softValueReference;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V v) {
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v, ReferenceEntry<K, V> referenceEntry) {
            WeakValueReference<K, V> weakValueReference = new WeakValueReference<K, V>(referenceQueue, v, referenceEntry);
            return weakValueReference;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    static final class WeakAccessWriteEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        WeakAccessWriteEntry(ReferenceQueue<K> referenceQueue, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k, n, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }
    }

    static final class WeakWriteEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        WeakWriteEntry(ReferenceQueue<K> referenceQueue, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }
    }

    static final class WeakAccessEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        WeakAccessEntry(ReferenceQueue<K> referenceQueue, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k, n, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        WeakEntry(ReferenceQueue<K> referenceQueue, K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(k, referenceQueue);
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public long getAccessTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setAccessTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getWriteTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setWriteTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongAccessWriteEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        StrongAccessWriteEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(k, n, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }
    }

    static final class StrongWriteEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        StrongWriteEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        StrongAccessEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            super(k, n, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static class StrongEntry<K, V>
    extends AbstractReferenceEntry<K, V> {
        final K key;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        StrongEntry(K k, int n, ReferenceEntry<K, V> referenceEntry) {
            this.key = k;
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public int getHash() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public K getKey() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getAccessTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setAccessTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getWriteTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setWriteTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }
    }

    private static final class NullEntry
    extends Enum<NullEntry>
    implements ReferenceEntry<Object, Object> {
        public static final /* enum */ NullEntry INSTANCE;
        private static final /* synthetic */ NullEntry[] $VALUES;

        public static NullEntry[] values() {
            return (NullEntry[])$VALUES.clone();
        }

        @Override
        public ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public long getAccessTime() {
            return 0L;
        }

        @Override
        public void setAccessTime(long l) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public void setWriteTime(long l) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        static {
            NullEntry[] nullEntryArray = new NullEntry();
            INSTANCE = nullEntryArray;
            nullEntryArray = new NullEntry[]{INSTANCE};
            $VALUES = nullEntryArray;
        }
    }

    static interface ValueReference<K, V> {
        public V get();

        public int getWeight();

        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, V var2, ReferenceEntry<K, V> var3);

        public void notifyNewValue(V var1);

        public boolean isLoading();

        public boolean isActive();
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        public static final /* enum */ EntryFactory STRONG;
        public static final /* enum */ EntryFactory STRONG_ACCESS;
        public static final /* enum */ EntryFactory STRONG_WRITE;
        public static final /* enum */ EntryFactory STRONG_ACCESS_WRITE;
        public static final /* enum */ EntryFactory WEAK;
        public static final /* enum */ EntryFactory WEAK_ACCESS;
        public static final /* enum */ EntryFactory WEAK_WRITE;
        public static final /* enum */ EntryFactory WEAK_ACCESS_WRITE;
        static final EntryFactory[] factories;
        private static final /* synthetic */ EntryFactory[] $VALUES;

        public static EntryFactory[] values() {
            return (EntryFactory[])$VALUES.clone();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        static EntryFactory getFactory(Strength strength, boolean bl, boolean bl2) {
            void var2_7;
            void var1_4;
            int n = strength == Strength.WEAK ? 4 : 0;
            if (bl) {
                boolean bl3 = true;
            } else {
                boolean bl4 = false;
            }
            int n2 = n | var1_4;
            if (var2_7 != false) {
                n = 2;
                return factories[n2 | n];
            }
            n = 0;
            return factories[n2 | n];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, ReferenceEntry<K, V> var4);

        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            return this.newEntry(segment, referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry2);
        }

        <K, V> void copyAccessEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            referenceEntry2.setAccessTime(referenceEntry.getAccessTime());
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry2);
            LocalCache.connectAccessOrder(referenceEntry2, referenceEntry.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(referenceEntry);
        }

        <K, V> void copyWriteEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            referenceEntry2.setWriteTime(referenceEntry.getWriteTime());
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry2);
            LocalCache.connectWriteOrder(referenceEntry2, referenceEntry.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(referenceEntry);
        }

        static {
            EntryFactory[] entryFactoryArray;
            STRONG = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new StrongEntry(k, n, referenceEntry);
                    return object;
                }
            };
            STRONG_ACCESS = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new StrongAccessEntry(k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    return object;
                }
            };
            STRONG_WRITE = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new StrongWriteEntry(k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }
            };
            STRONG_ACCESS_WRITE = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new StrongAccessWriteEntry(k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }
            };
            WEAK = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new WeakEntry(segment.keyReferenceQueue, k, n, referenceEntry);
                    return object;
                }
            };
            WEAK_ACCESS = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new WeakAccessEntry(segment.keyReferenceQueue, k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    return object;
                }
            };
            WEAK_WRITE = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new WeakWriteEntry(segment.keyReferenceQueue, k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }
            };
            WEAK_ACCESS_WRITE = entryFactoryArray = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k, int n, ReferenceEntry<K, V> referenceEntry) {
                    Object object = new WeakAccessWriteEntry(segment.keyReferenceQueue, k, n, referenceEntry);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }
            };
            entryFactoryArray = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
            $VALUES = entryFactoryArray;
            entryFactoryArray = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
            factories = entryFactoryArray;
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG;
        public static final /* enum */ Strength SOFT;
        public static final /* enum */ Strength WEAK;
        private static final /* synthetic */ Strength[] $VALUES;

        public static Strength[] values() {
            return (Strength[])$VALUES.clone();
        }

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);

        abstract Equivalence<Object> defaultEquivalence();

        static {
            Strength strength;
            STRONG = strength = new Strength(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> referenceEntry, V v, int n) {
                    void var0_2;
                    void var3_6;
                    void var4_7;
                    if (var4_7 == true) {
                        StrongValueReference strongValueReference = new StrongValueReference(var3_6);
                        return var0_2;
                    }
                    WeightedStrongValueReference weightedStrongValueReference = new WeightedStrongValueReference(var3_6, (int)var4_7);
                    return var0_2;
                }

                @Override
                Equivalence<Object> defaultEquivalence() {
                    return Equivalence.equals();
                }
            };
            SOFT = strength = new Strength(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> referenceEntry, V v, int n) {
                    void var0_2;
                    void var2_5;
                    void var3_6;
                    void var1_4;
                    void var4_7;
                    if (var4_7 == true) {
                        SoftValueReference softValueReference = new SoftValueReference(var1_4.valueReferenceQueue, var3_6, var2_5);
                        return var0_2;
                    }
                    WeightedSoftValueReference weightedSoftValueReference = new WeightedSoftValueReference(var1_4.valueReferenceQueue, var3_6, var2_5, (int)var4_7);
                    return var0_2;
                }

                @Override
                Equivalence<Object> defaultEquivalence() {
                    return Equivalence.identity();
                }
            };
            WEAK = strength = new Strength(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> referenceEntry, V v, int n) {
                    void var0_2;
                    void var2_5;
                    void var3_6;
                    void var1_4;
                    void var4_7;
                    if (var4_7 == true) {
                        WeakValueReference weakValueReference = new WeakValueReference(var1_4.valueReferenceQueue, var3_6, var2_5);
                        return var0_2;
                    }
                    WeightedWeakValueReference weightedWeakValueReference = new WeightedWeakValueReference(var1_4.valueReferenceQueue, var3_6, var2_5, (int)var4_7);
                    return var0_2;
                }

                @Override
                Equivalence<Object> defaultEquivalence() {
                    return Equivalence.identity();
                }
            };
            strength = new Strength[]{STRONG, SOFT, WEAK};
            $VALUES = strength;
        }
    }
}

