/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.cache;

import androidx.test.espresso.core.internal.deps.guava.base.Ascii;
import androidx.test.espresso.core.internal.deps.guava.base.Equivalence;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Supplier;
import androidx.test.espresso.core.internal.deps.guava.base.Suppliers;
import androidx.test.espresso.core.internal.deps.guava.base.Ticker;
import androidx.test.espresso.core.internal.deps.guava.cache.AbstractCache$SimpleStatsCounter;
import androidx.test.espresso.core.internal.deps.guava.cache.AbstractCache$StatsCounter;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheStats;
import androidx.test.espresso.core.internal.deps.guava.cache.LocalCache;
import androidx.test.espresso.core.internal.deps.guava.cache.RemovalListener;
import androidx.test.espresso.core.internal.deps.guava.cache.RemovalNotification;
import androidx.test.espresso.core.internal.deps.guava.cache.Weigher;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CacheBuilder<K, V> {
    static final Supplier<? extends AbstractCache$StatsCounter> NULL_STATS_COUNTER;
    static final CacheStats EMPTY_STATS;
    static final Supplier<AbstractCache$StatsCounter> CACHE_STATS_COUNTER;
    static final Ticker NULL_TICKER;
    private static final Logger logger;
    boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher<? super K, ? super V> weigher;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    RemovalListener<? super K, ? super V> removalListener;
    Ticker ticker;
    Supplier<? extends AbstractCache$StatsCounter> statsCounterSupplier = NULL_STATS_COUNTER;

    private CacheBuilder() {
    }

    public static CacheBuilder<Object, Object> newBuilder() {
        CacheBuilder<Object, Object> cacheBuilder = new CacheBuilder<Object, Object>();
        return cacheBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder<K, V> keyEquivalence(Equivalence<Object> equivalence) {
        boolean bl = this.keyEquivalence == null;
        Preconditions.checkState(bl, "key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = Preconditions.checkNotNull(equivalence);
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder<K, V> valueEquivalence(Equivalence<Object> equivalence) {
        boolean bl = this.valueEquivalence == null;
        Preconditions.checkState(bl, "value equivalence was already set to %s", this.valueEquivalence);
        this.valueEquivalence = Preconditions.checkNotNull(equivalence);
        return this;
    }

    Equivalence<Object> getValueEquivalence() {
        return MoreObjects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getInitialCapacity() {
        if (this.initialCapacity == -1) return 16;
        return this.initialCapacity;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> concurrencyLevel(int n) {
        boolean bl = this.concurrencyLevel == -1;
        Preconditions.checkState(bl, "concurrency level was already set to %s", this.concurrencyLevel);
        bl = n > 0;
        Preconditions.checkArgument(bl);
        this.concurrencyLevel = n;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getConcurrencyLevel() {
        if (this.concurrencyLevel == -1) return 4;
        return this.concurrencyLevel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> maximumSize(long l) {
        boolean bl = this.maximumSize == -1L;
        Preconditions.checkState(bl, "maximum size was already set to %s", this.maximumSize);
        bl = this.maximumWeight == -1L;
        Preconditions.checkState(bl, "maximum weight was already set to %s", this.maximumWeight);
        bl = this.weigher == null;
        Preconditions.checkState(bl, "maximum size can not be combined with weigher");
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "maximum size must not be negative");
        this.maximumSize = l;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> maximumWeight(long l) {
        boolean bl = this.maximumWeight == -1L;
        Preconditions.checkState(bl, "maximum weight was already set to %s", this.maximumWeight);
        bl = this.maximumSize == -1L;
        Preconditions.checkState(bl, "maximum size was already set to %s", this.maximumSize);
        this.maximumWeight = l;
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "maximum weight must not be negative");
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <K1 extends K, V1 extends V> CacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        boolean bl = this.weigher == null;
        Preconditions.checkState(bl);
        if (this.strictParsing) {
            bl = this.maximumSize == -1L;
            Preconditions.checkState(bl, "weigher can not be combined with maximum size", this.maximumSize);
        }
        this.weigher = Preconditions.checkNotNull(weigher);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getMaximumWeight() {
        if (this.expireAfterWriteNanos == 0L) return 0L;
        if (this.expireAfterAccessNanos == 0L) return 0L;
        if (this.weigher != null) return this.maximumWeight;
        return this.maximumSize;
    }

    <K1 extends K, V1 extends V> Weigher<K1, V1> getWeigher() {
        return MoreObjects.firstNonNull(this.weigher, OneWeigher.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder<K, V> setKeyStrength(LocalCache.Strength strength) {
        boolean bl = this.keyStrength == null;
        Preconditions.checkState(bl, "Key strength was already set to %s", (Object)this.keyStrength);
        this.keyStrength = Preconditions.checkNotNull(strength);
        return this;
    }

    LocalCache.Strength getKeyStrength() {
        return MoreObjects.firstNonNull(this.keyStrength, LocalCache.Strength.STRONG);
    }

    /*
     * Enabled aggressive block sorting
     */
    CacheBuilder<K, V> setValueStrength(LocalCache.Strength strength) {
        boolean bl = this.valueStrength == null;
        Preconditions.checkState(bl, "Value strength was already set to %s", (Object)this.valueStrength);
        this.valueStrength = Preconditions.checkNotNull(strength);
        return this;
    }

    LocalCache.Strength getValueStrength() {
        return MoreObjects.firstNonNull(this.valueStrength, LocalCache.Strength.STRONG);
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> expireAfterWrite(long l, TimeUnit timeUnit) {
        boolean bl = this.expireAfterWriteNanos == -1L;
        Preconditions.checkState(bl, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "duration cannot be negative: %s %s", l, (Object)timeUnit);
        this.expireAfterWriteNanos = timeUnit.toNanos(l);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getExpireAfterWriteNanos() {
        if (this.expireAfterWriteNanos == -1L) return 0L;
        return this.expireAfterWriteNanos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> expireAfterAccess(long l, TimeUnit timeUnit) {
        boolean bl = this.expireAfterAccessNanos == -1L;
        Preconditions.checkState(bl, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        bl = l >= 0L;
        Preconditions.checkArgument(bl, "duration cannot be negative: %s %s", l, (Object)timeUnit);
        this.expireAfterAccessNanos = timeUnit.toNanos(l);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getExpireAfterAccessNanos() {
        if (this.expireAfterAccessNanos != -1L) return this.expireAfterAccessNanos;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getRefreshNanos() {
        if (this.refreshNanos == -1L) return 0L;
        return this.refreshNanos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheBuilder<K, V> ticker(Ticker ticker) {
        boolean bl = this.ticker == null;
        Preconditions.checkState(bl);
        this.ticker = Preconditions.checkNotNull(ticker);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Ticker getTicker(boolean bl) {
        if (((CacheBuilder)this).ticker != null) {
            return ((CacheBuilder)this).ticker;
        }
        if (!bl) return NULL_TICKER;
        return Ticker.systemTicker();
    }

    /*
     * Enabled aggressive block sorting
     */
    public <K1 extends K, V1 extends V> CacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> removalListener) {
        boolean bl = this.removalListener == null;
        Preconditions.checkState(bl);
        this.removalListener = Preconditions.checkNotNull(removalListener);
        return this;
    }

    <K1 extends K, V1 extends V> RemovalListener<K1, V1> getRemovalListener() {
        return MoreObjects.firstNonNull(this.removalListener, NullListener.INSTANCE);
    }

    Supplier<? extends AbstractCache$StatsCounter> getStatsCounterSupplier() {
        return this.statsCounterSupplier;
    }

    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        this.checkWeightWithWeigher();
        this.checkNonLoadingCache();
        LocalCache.LocalManualCache localManualCache = new LocalCache.LocalManualCache(this);
        return localManualCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkNonLoadingCache() {
        boolean bl = this.refreshNanos == -1L;
        Preconditions.checkState(bl, "refreshAfterWrite requires a LoadingCache");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkWeightWithWeigher() {
        if (this.weigher == null) {
            boolean bl = this.maximumWeight == -1L;
            Preconditions.checkState(bl, "maximumWeight requires weigher");
            return;
        }
        if (this.strictParsing) {
            boolean bl = this.maximumWeight != -1L;
            Preconditions.checkState(bl, "weigher requires maximumWeight");
            return;
        }
        if (this.maximumWeight == -1L) {
            logger.logp(Level.WARNING, "androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder", "checkWeightWithWeigher", "ignoring weigher specified without maximumWeight");
            return;
        }
    }

    public String toString() {
        StringBuilder stringBuilder;
        long l;
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            toStringHelper.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            toStringHelper.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1L) {
            toStringHelper.add("maximumSize", this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            toStringHelper.add("maximumWeight", this.maximumWeight);
        }
        if (this.expireAfterWriteNanos != -1L) {
            l = this.expireAfterWriteNanos;
            stringBuilder = new StringBuilder(22);
            toStringHelper.add("expireAfterWrite", stringBuilder.append(l).append("ns").toString());
        }
        if (this.expireAfterAccessNanos != -1L) {
            l = this.expireAfterAccessNanos;
            stringBuilder = new StringBuilder(22);
            toStringHelper.add("expireAfterAccess", stringBuilder.append(l).append("ns").toString());
        }
        if (this.keyStrength != null) {
            toStringHelper.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            toStringHelper.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            toStringHelper.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            toStringHelper.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            toStringHelper.addValue("removalListener");
        }
        return toStringHelper.toString();
    }

    static {
        Ticker ticker = new AbstractCache$StatsCounter(){

            @Override
            public void recordHits(int n) {
            }

            @Override
            public void recordMisses(int n) {
            }

            @Override
            public void recordLoadSuccess(long l) {
            }

            @Override
            public void recordLoadException(long l) {
            }

            @Override
            public void recordEviction() {
            }
        };
        NULL_STATS_COUNTER = Suppliers.ofInstance(ticker);
        ticker = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
        EMPTY_STATS = ticker;
        ticker = new Supplier<AbstractCache$StatsCounter>(){

            @Override
            public AbstractCache$StatsCounter get() {
                Object object = new AbstractCache$SimpleStatsCounter();
                return object;
            }
        };
        CACHE_STATS_COUNTER = ticker;
        ticker = new Ticker(){

            @Override
            public long read() {
                return 0L;
            }
        };
        NULL_TICKER = ticker;
        logger = Logger.getLogger(CacheBuilder.class.getName());
    }

    static final class OneWeigher
    extends Enum<OneWeigher>
    implements Weigher<Object, Object> {
        public static final /* enum */ OneWeigher INSTANCE;
        private static final /* synthetic */ OneWeigher[] $VALUES;

        public static OneWeigher[] values() {
            return (OneWeigher[])$VALUES.clone();
        }

        @Override
        public int weigh(Object object, Object object2) {
            return 1;
        }

        static {
            OneWeigher[] oneWeigherArray = new OneWeigher();
            INSTANCE = oneWeigherArray;
            oneWeigherArray = new OneWeigher[]{INSTANCE};
            $VALUES = oneWeigherArray;
        }
    }

    static final class NullListener
    extends Enum<NullListener>
    implements RemovalListener<Object, Object> {
        public static final /* enum */ NullListener INSTANCE;
        private static final /* synthetic */ NullListener[] $VALUES;

        public static NullListener[] values() {
            return (NullListener[])$VALUES.clone();
        }

        @Override
        public void onRemoval(RemovalNotification<Object, Object> removalNotification) {
        }

        static {
            NullListener[] nullListenerArray = new NullListener();
            INSTANCE = nullListenerArray;
            nullListenerArray = new NullListener[]{INSTANCE};
            $VALUES = nullListenerArray;
        }
    }
}

