/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Throwables {
    private static final Object jla = Throwables.getJLA();
    private static final Method getStackTraceElementMethod;
    private static final Method getStackTraceDepthMethod;

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        RuntimeException runtimeException = new RuntimeException(throwable);
        throw runtimeException;
    }

    private static Object getJLA() {
        try {
            Object object = Class.forName("sun.misc.SharedSecrets", false, null).getMethod("getJavaLangAccess", new Class[0]);
            object = ((Method)object).invoke(null, new Object[0]);
            return object;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getGetMethod() {
        Class[] classArray = new Class[]{Throwable.class, Integer.TYPE};
        return Throwables.getJlaMethod("getStackTraceElement", classArray);
    }

    private static Method getSizeMethod() {
        Object object;
        Object object2;
        block3: {
            object2 = "getStackTraceDepth";
            object = new Class[]{Throwable.class};
            object2 = Throwables.getJlaMethod((String)object2, object);
            if (object2 != null) break block3;
            return null;
        }
        try {
            object = Throwables.getJLA();
            Object[] objectArray = new Object[1];
            Throwable throwable = new Throwable();
            objectArray[0] = throwable;
            ((Method)object2).invoke(object, objectArray);
            return object2;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    private static Method getJlaMethod(String object, Class<?> ... classArray) throws ThreadDeath {
        try {
            object = Class.forName("sun.misc.JavaLangAccess", false, null).getMethod((String)object, classArray);
            return object;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        Method method = jla != null ? Throwables.getGetMethod() : null;
        getStackTraceElementMethod = method;
        method = jla != null ? Throwables.getSizeMethod() : null;
        getStackTraceDepthMethod = method;
    }
}

