/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Platform;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static String emptyToNull(String string) {
        return Platform.emptyToNull(string);
    }

    public static String padStart(String string, int n, char c) {
        Preconditions.checkNotNull(string);
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String lenientFormat(String objectArray, Object ... objectArray2) {
        int n;
        String string = String.valueOf(objectArray);
        if (objectArray2 == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = Strings.lenientToString(objectArray2[i]);
            }
            objectArray = objectArray2;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + objectArray.length * 16);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string, n2, n);
            int n4 = n3 + 1;
            stringBuilder.append(objectArray[n3]);
            n2 = n + 2;
            n3 = n4;
        }
        stringBuilder.append(string, n2, string.length());
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            n2 = n3 + 1;
            stringBuilder.append(objectArray[n3]);
            while (n2 < objectArray.length) {
                stringBuilder.append(", ");
                n3 = n2 + 1;
                stringBuilder.append(objectArray[n2]);
                n2 = n3;
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String lenientToString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            String string = object.getClass().getName();
            object = Integer.toHexString(System.identityHashCode(object));
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(object);
            int n2 = string3.length();
            CharSequence charSequence = new StringBuilder(n + 1 + n2);
            string = ((StringBuilder)charSequence).append(string).append('@').append((String)object).toString();
            Object object2 = Logger.getLogger("androidx.test.espresso.core.internal.deps.guava.base.Strings");
            Serializable serializable = Level.WARNING;
            object = String.valueOf(string);
            charSequence = "Exception during lenientFormat for ";
            object = ((String)object).length() == 0 ? new String((String)charSequence) : ((String)charSequence).concat((String)object);
            ((Logger)object2).logp((Level)serializable, "androidx.test.espresso.core.internal.deps.guava.base.Strings", "lenientToString", (String)object, exception);
            object = exception.getClass().getName();
            String string4 = String.valueOf(string);
            int n3 = string4.length();
            object2 = String.valueOf(object);
            int n4 = ((String)object2).length();
            serializable = new StringBuilder(n3 + 9 + n4);
            return ((StringBuilder)serializable).append("<").append(string).append(" threw ").append((String)object).append(">").toString();
        }
    }
}

