/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Absent;
import androidx.test.espresso.core.internal.deps.guava.base.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Present;
import androidx.test.espresso.core.internal.deps.guava.base.Supplier;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T t) {
        Present<T> present = new Present<T>(Preconditions.checkNotNull(t));
        return present;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Optional<T> fromNullable(T object) {
        void var0_2;
        if (object != null) {
            Present<T> present;
            Present<T> present2 = present = new Present<T>(object);
            return var0_2;
        }
        Optional<T> optional = Optional.absent();
        return var0_2;
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T or(Supplier<? extends T> var1);

    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> iterable) {
        Preconditions.checkNotNull(iterable);
        Iterable iterable2 = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                AbstractIterator abstractIterator = new AbstractIterator<T>(){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(iterable.iterator());
                    }

                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
                return abstractIterator;
            }
        };
        return iterable2;
    }
}

