/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class WindowManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = WindowManagerEventInjectionStrategy.class.getSimpleName();
    private boolean initComplete;
    private Object wmInstance;
    private Method injectInputKeyEventMethod;
    private Method injectInputMotionEventMethod;

    /*
     * Enabled aggressive block sorting
     */
    WindowManagerEventInjectionStrategy() {
        boolean bl = Build.VERSION.SDK_INT >= 7 && Build.VERSION.SDK_INT <= 15;
        Preconditions.checkState(bl, "Unsupported API level.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize() {
        Object object;
        Object object2;
        Class clazz;
        if (this.initComplete) {
            return;
        }
        try {
            Log.d((String)TAG, (String)"Trying to create injection strategy.");
            clazz = Class.forName("android.os.ServiceManager");
            object2 = "getService";
            object = new Class[]{String.class};
            object2 = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            ((Method)object2).setAccessible(true);
            object = new Object[]{"window"};
            clazz = ((Method)object2).invoke((Object)clazz, (Object[])object);
            object2 = Class.forName("android.view.IWindowManager$Stub");
            object = "asInterface";
            Object[] objectArray = new Class[]{IBinder.class};
            object = ((Class)object2).getDeclaredMethod((String)object, (Class<?>[])objectArray);
            ((Method)object).setAccessible(true);
            objectArray = new Object[]{clazz};
            this.wmInstance = ((Method)object).invoke(object2, objectArray);
            clazz = this.wmInstance.getClass();
            object2 = "injectPointerEvent";
            object = new Class[]{MotionEvent.class, Boolean.TYPE};
            this.injectInputMotionEventMethod = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            this.injectInputMotionEventMethod.setAccessible(true);
            clazz = this.wmInstance.getClass();
            object2 = "injectKeyEvent";
            object = new Class[2];
            object[0] = KeyEvent.class;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = new Class(classNotFoundException);
            throw clazz;
        }
        catch (IllegalAccessException illegalAccessException) {
            clazz = new Class(illegalAccessException);
            throw clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            clazz = new Class(invocationTargetException);
            throw clazz;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = new Class(noSuchMethodException);
            throw clazz;
        }
        {
            object[1] = Boolean.TYPE;
            this.injectInputKeyEventMethod = clazz.getDeclaredMethod((String)object2, (Class<?>)object);
            this.injectInputKeyEventMethod.setAccessible(true);
            this.initComplete = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectKeyEvent(KeyEvent object) throws InjectEventSecurityException {
        Throwable throwable;
        block5: {
            try {
                Method method = ((WindowManagerEventInjectionStrategy)object2).injectInputKeyEventMethod;
                Object object2 = ((WindowManagerEventInjectionStrategy)object2).wmInstance;
                Object[] objectArray = new Object[]{object, true};
                return (Boolean)method.invoke(object2, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                RuntimeException runtimeException = new RuntimeException(illegalAccessException);
                throw runtimeException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (SecurityException securityException) {
                InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException(securityException);
                throw injectEventSecurityException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getCause();
                if (throwable instanceof SecurityException) break block5;
            }
            RuntimeException runtimeException = new RuntimeException(invocationTargetException);
            throw runtimeException;
        }
        InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException(throwable);
        throw injectEventSecurityException;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEvent(MotionEvent object, boolean bl) throws InjectEventSecurityException {
        Throwable throwable;
        block5: {
            try {
                void var2_12;
                Method method = ((WindowManagerEventInjectionStrategy)object2).injectInputMotionEventMethod;
                Object object2 = ((WindowManagerEventInjectionStrategy)object2).wmInstance;
                Object[] objectArray = new Object[]{object, (boolean)var2_12};
                return (Boolean)method.invoke(object2, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                RuntimeException runtimeException = new RuntimeException(illegalAccessException);
                throw runtimeException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (SecurityException securityException) {
                InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException(securityException);
                throw injectEventSecurityException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getCause();
                if (throwable instanceof SecurityException) break block5;
            }
            RuntimeException runtimeException = new RuntimeException(invocationTargetException);
            throw runtimeException;
        }
        InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException(throwable);
        throw injectEventSecurityException;
    }
}

