/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Looper;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.TreeIterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class ViewFinderImpl
implements ViewFinder {
    private final Matcher<View> viewMatcher;
    private final Provider<View> rootViewProvider;

    ViewFinderImpl(Matcher<View> matcher, Provider<View> provider) {
        this.viewMatcher = matcher;
        this.rootViewProvider = provider;
    }

    @Override
    public View getView() throws AmbiguousViewMatcherException, NoMatchingViewException {
        ArrayList<View> arrayList;
        block5: {
            Object object;
            View view;
            block4: {
                this.checkMainThread();
                arrayList = new MatcherPredicateAdapter(Preconditions.checkNotNull(this.viewMatcher));
                view = (View)this.rootViewProvider.get();
                object = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), arrayList).iterator();
                arrayList = null;
                while (object.hasNext()) {
                    if (arrayList == null) {
                        arrayList = object.next();
                        continue;
                    }
                    break block4;
                }
                if (arrayList == null) {
                    arrayList = new MatcherPredicateAdapter(ViewMatchers.isAssignableFrom(AdapterView.class));
                    arrayList = Lists.newArrayList(Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), arrayList).iterator());
                    if (arrayList.isEmpty()) {
                        arrayList = new NoMatchingViewException.Builder();
                        throw ((NoMatchingViewException.Builder)((Object)arrayList)).withViewMatcher(this.viewMatcher).withRootView(view).build();
                    }
                    object = Locale.ROOT;
                    Object object2 = new Object[]{Joiner.on("\n- ").join(arrayList)};
                    object = String.format((Locale)object, "\nIf the target view is not part of the view hierarchy, you may need to use Espresso.onData to load it from one of the following AdapterViews:%s", (Object[])object2);
                    object2 = new NoMatchingViewException.Builder();
                    throw ((NoMatchingViewException.Builder)object2).withViewMatcher(this.viewMatcher).withRootView(view).withAdapterViews((List<View>)arrayList).withAdapterViewWarning(EspressoOptional.of(object)).build();
                }
                break block5;
            }
            AmbiguousViewMatcherException.Builder builder = new AmbiguousViewMatcherException.Builder();
            throw builder.withViewMatcher(this.viewMatcher).withRootView(view).withView1((View)arrayList).withView2(object.next()).withOtherAmbiguousViews(Iterators.toArray(object, View.class)).build();
        }
        return arrayList;
    }

    private void checkMainThread() {
        Preconditions.checkState(Thread.currentThread().equals(Looper.getMainLooper().getThread()), "Executing a query on the view hierarchy outside of the main thread (on: %s)", Thread.currentThread().getName());
    }

    private static class MatcherPredicateAdapter<T>
    implements Predicate<T> {
        private final Matcher<? super T> matcher;

        private MatcherPredicateAdapter(Matcher<? super T> matcher) {
            this.matcher = Preconditions.checkNotNull(matcher);
        }

        @Override
        public boolean apply(T t) {
            return this.matcher.matches(t);
        }
    }
}

