/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.UiController$$CC;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.internal.platform.ServiceLoaderWrapper;

public class UiControllerModule {
    public UiController provideUiController(UiControllerImpl interruptableUiController) {
        Object object = ServiceLoaderWrapper.loadService(androidx.test.platform.ui.UiController.class);
        if (object.isEmpty()) {
            return interruptableUiController;
        }
        if (object.size() != 1) {
            object = new IllegalStateException("Found more than one androidx.test.internal.platform.UiController");
            throw object;
        }
        interruptableUiController = new EspressoUiControllerAdapter((androidx.test.platform.ui.UiController)object.get(0));
        return interruptableUiController;
    }

    private static class EspressoUiControllerAdapter
    implements InterruptableUiController {
        private final androidx.test.platform.ui.UiController platformUiController;

        private EspressoUiControllerAdapter(androidx.test.platform.ui.UiController uiController) {
            this.platformUiController = uiController;
        }

        @Override
        public boolean injectMotionEvent(MotionEvent object) throws InjectEventSecurityException {
            boolean bl;
            try {
                bl = this.platformUiController.injectMotionEvent(object);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                object = new InjectEventSecurityException(injectEventSecurityException);
                throw object;
            }
            return bl;
        }

        @Override
        public boolean injectKeyEvent(KeyEvent object) throws InjectEventSecurityException {
            boolean bl;
            try {
                bl = this.platformUiController.injectKeyEvent(object);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                object = new InjectEventSecurityException(injectEventSecurityException);
                throw object;
            }
            return bl;
        }

        @Override
        public boolean injectString(String object) throws InjectEventSecurityException {
            boolean bl;
            try {
                bl = this.platformUiController.injectString((String)object);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException injectEventSecurityException) {
                object = new InjectEventSecurityException(injectEventSecurityException);
                throw object;
            }
            return bl;
        }

        @Override
        public void loopMainThreadUntilIdle() {
            this.platformUiController.loopMainThreadUntilIdle();
        }

        @Override
        public void loopMainThreadForAtLeast(long l) {
            this.platformUiController.loopMainThreadForAtLeast(l);
        }

        @Override
        public void interruptEspressoTasks() {
            Log.w((String)"UiController", (String)"interruptEspressoTasks called, no-op");
        }

        public boolean injectMotionEventSequence(Iterable iterable) throws InjectEventSecurityException {
            return UiController$$CC.injectMotionEventSequence$$dflt$$(this, iterable);
        }
    }
}

