/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingUiController;
import androidx.test.espresso.base.Interrogator;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.inject.Provider;

final class UiControllerImpl
implements InterruptableUiController,
Handler.Callback,
IdlingUiController {
    private static final String TAG;
    private static final Callable<Void> NO_OP;
    private final EventInjector eventInjector;
    private final BitSet conditionSet;
    private final ExecutorService keyEventExecutor;
    private final Looper mainLooper;
    private final IdlingResourceRegistry idlingResourceRegistry;
    private Handler controllerHandler;
    private MainThreadInterrogation interrogation;
    private int generation;
    private IdleNotifier<Runnable> asyncIdle;
    private IdleNotifier<Runnable> compatIdle;
    private Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdleProvider;

    UiControllerImpl(EventInjector eventInjector, @SdkAsyncTask IdleNotifier<Runnable> idleNotifier, @CompatAsyncTask IdleNotifier<Runnable> idleNotifier2, Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> provider, Looper looper, IdlingResourceRegistry idlingResourceRegistry) {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        this.keyEventExecutor = Executors.newSingleThreadExecutor(threadFactoryBuilder.setNameFormat("Espresso Key Event #%d").build());
        this.generation = 0;
        this.eventInjector = Preconditions.checkNotNull(eventInjector);
        this.asyncIdle = Preconditions.checkNotNull(idleNotifier);
        this.compatIdle = Preconditions.checkNotNull(idleNotifier2);
        this.conditionSet = IdleCondition.createConditionSet();
        this.dynamicIdleProvider = Preconditions.checkNotNull(provider);
        this.mainLooper = Preconditions.checkNotNull(looper);
        this.idlingResourceRegistry = Preconditions.checkNotNull(idlingResourceRegistry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectKeyEvent(final KeyEvent object) throws InjectEventSecurityException {
        ExecutionException executionException2;
        block3: {
            Preconditions.checkNotNull(object);
            boolean bl = Looper.myLooper() == this.mainLooper;
            Preconditions.checkState(bl, "Expecting to be on main thread!");
            this.initialize();
            this.loopMainThreadUntilIdle();
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return UiControllerImpl.this.eventInjector.injectKeyEvent(object);
                }
            };
            SignalingTask<Boolean> signalingTask = new SignalingTask<Boolean>(callable, IdleCondition.KEY_INJECT_HAS_COMPLETED, this.generation);
            this.keyEventExecutor.submit(signalingTask);
            this.loopUntil(IdleCondition.KEY_INJECT_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
            try {
                Preconditions.checkState(signalingTask.isDone(), "Key injection was signaled - but it wasnt done.");
                return (Boolean)signalingTask.get();
            }
            catch (InterruptedException interruptedException) {
                RuntimeException runtimeException = new RuntimeException("impossible.", interruptedException);
                throw runtimeException;
            }
            catch (ExecutionException executionException2) {
                if (!(executionException2.getCause() instanceof InjectEventSecurityException)) break block3;
                throw (InjectEventSecurityException)((Object)executionException2.getCause());
            }
        }
        RuntimeException runtimeException = new RuntimeException(executionException2.getCause());
        throw runtimeException;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEvent(final MotionEvent motionEvent) throws InjectEventSecurityException {
        Preconditions.checkNotNull(motionEvent);
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        this.initialize();
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UiControllerImpl.this.eventInjector.injectMotionEvent(motionEvent);
            }
        };
        Object object = new SignalingTask(callable, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        this.keyEventExecutor.submit((Runnable)object);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(((FutureTask)object).isDone(), "Motion event injection was signaled - but it wasnt done.");
            boolean bl2 = (Boolean)((FutureTask)object).get();
            this.loopMainThreadUntilIdle();
            return bl2;
        }
        catch (ExecutionException executionException) {
            try {
                boolean bl3 = executionException.getCause() instanceof InjectEventSecurityException;
                if (bl3) {
                    throw (InjectEventSecurityException)((Object)executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    object = new RuntimeException(interruptedException);
                    throw object;
                }
            }
            catch (Throwable throwable2) {
                this.loopMainThreadUntilIdle();
                throw throwable2;
            }
        }
        {
            Throwable throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            Throwables.throwIfUnchecked(throwable);
            throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            callable = new Callable<Boolean>(throwable);
            throw callable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectMotionEventSequence(Iterable<MotionEvent> object) throws InjectEventSecurityException {
        Preconditions.checkNotNull(object);
        boolean bl = !Iterables.isEmpty(object);
        Preconditions.checkState(bl, "Expecting non-empty events to inject");
        bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        this.initialize();
        final Object object2 = object.iterator();
        object = Iterables.getFirst(object, null);
        object = (MotionEvent)object;
        long l = object.getEventTime();
        long l2 = SystemClock.uptimeMillis();
        Callable<Boolean> callable = new Callable<Boolean>(l2 - l){
            final /* synthetic */ long val$shift;
            {
                this.val$shift = l;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                boolean bl = true;
                while (true) {
                    if (!object2.hasNext()) {
                        boolean bl2;
                        if (!bl) {
                            bl2 = false;
                            return bl2;
                        }
                        bl2 = true;
                        return bl2;
                    }
                    MotionEvent motionEvent = (MotionEvent)object2.next();
                    long l = motionEvent.getEventTime() + this.val$shift - SystemClock.uptimeMillis();
                    if (l > 10L) {
                        SystemClock.sleep((long)l);
                    }
                    if (object2.hasNext()) {
                        bl &= UiControllerImpl.this.eventInjector.injectMotionEventAsync(motionEvent);
                        continue;
                    }
                    bl &= UiControllerImpl.this.eventInjector.injectMotionEvent(motionEvent);
                }
            }
        };
        object = new SignalingTask(callable, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        this.keyEventExecutor.submit((Runnable)object);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Preconditions.checkState(((FutureTask)object).isDone(), "MotionEvents injection was signaled - but it wasnt done.");
            boolean bl2 = (Boolean)((FutureTask)object).get();
            this.loopMainThreadUntilIdle();
            return bl2;
        }
        catch (ExecutionException executionException) {
            try {
                boolean bl3 = executionException.getCause() instanceof InjectEventSecurityException;
                if (bl3) {
                    throw (InjectEventSecurityException)((Object)executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    object2 = new RuntimeException(interruptedException);
                    throw object2;
                }
            }
            catch (Throwable throwable2) {
                this.loopMainThreadUntilIdle();
                throw throwable2;
            }
        }
        {
            Throwable throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            Throwables.throwIfUnchecked(throwable);
            throwable = executionException.getCause();
            throwable = throwable != null ? executionException.getCause() : executionException;
            callable = new Callable<Boolean>(throwable);
            throw callable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean injectString(String string) throws InjectEventSecurityException {
        Object object;
        Preconditions.checkNotNull(string);
        boolean bl = Looper.myLooper() == ((UiControllerImpl)object).mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        ((UiControllerImpl)object).initialize();
        if (string.isEmpty()) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return true;
        }
        KeyEvent[] keyEventArray = UiControllerImpl.getKeyCharacterMap().getEvents(string.toCharArray());
        if (keyEventArray == null) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{string};
            object = new RuntimeException(String.format(locale, "Failed to get key events for string %s (i.e. current IME does not understand how to translate the string into key events). As a workaround, you can use replaceText action to set the text directly in the EditText field.", objectArray));
            throw object;
        }
        String string2 = TAG;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{string};
        Log.d((String)string2, (String)String.format(locale, "Injecting string: \"%s\"", objectArray));
        int n = keyEventArray.length;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            locale = keyEventArray[n2];
            Locale locale2 = Locale.ROOT;
            objectArray = new Object[]{locale.getKeyCode(), locale.getUnicodeChar()};
            Preconditions.checkNotNull(locale, String.format(locale2, "Failed to get event for character (%c) with key code (%s)", objectArray));
            bl2 = false;
            for (int i = 0; !bl2 && i < 4; ++i) {
                locale = KeyEvent.changeTimeRepeat((KeyEvent)locale, (long)SystemClock.uptimeMillis(), (int)0);
                bl2 = ((UiControllerImpl)object).injectKeyEvent((KeyEvent)locale);
            }
            if (!bl2) {
                object = TAG;
                Locale locale3 = Locale.ROOT;
                Object[] objectArray2 = new Object[]{locale.getUnicodeChar(), locale.getKeyCode()};
                Log.e((String)object, (String)String.format(locale3, "Failed to inject event for character (%c) with key code (%s)", objectArray2));
                return bl2;
            }
            ++n2;
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"InlinedApi"})
    public static KeyCharacterMap getKeyCharacterMap() {
        if (Build.VERSION.SDK_INT >= 11) return KeyCharacterMap.load((int)-1);
        return KeyCharacterMap.load((int)0);
    }

    @Override
    public IdlingResourceRegistry getIdlingResourceRegistry() {
        return this.idlingResourceRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loopMainThreadUntilIdle() {
        this.initialize();
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        Object object = (IdleNotifier)this.dynamicIdleProvider.get();
        while (true) {
            Object object2;
            Object object3;
            Object object4 = EnumSet.noneOf(IdleCondition.class);
            if (!this.asyncIdle.isIdleNow()) {
                object3 = this.asyncIdle;
                object2 = new SignalingTask(NO_OP, IdleCondition.ASYNC_TASKS_HAVE_IDLED, this.generation);
                object3.registerNotificationCallback(object2);
                ((AbstractCollection)object4).add(IdleCondition.ASYNC_TASKS_HAVE_IDLED);
            }
            if (!this.compatIdle.isIdleNow()) {
                object3 = this.compatIdle;
                object2 = new SignalingTask(NO_OP, IdleCondition.COMPAT_TASKS_HAVE_IDLED, this.generation);
                object3.registerNotificationCallback(object2);
                ((AbstractCollection)object4).add(IdleCondition.COMPAT_TASKS_HAVE_IDLED);
            }
            if (!object.isIdleNow()) {
                object3 = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
                object2 = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
                SignalingTask<Void> signalingTask = new SignalingTask<Void>(NO_OP, IdleCondition.DYNAMIC_TASKS_HAVE_IDLED, this.generation);
                IdlingResourceRegistry.IdleNotificationCallback idleNotificationCallback = new IdlingResourceRegistry.IdleNotificationCallback((IdlingPolicy)object3, (IdlingPolicy)object2, signalingTask){
                    final /* synthetic */ IdlingPolicy val$warning;
                    final /* synthetic */ IdlingPolicy val$error;
                    final /* synthetic */ SignalingTask val$idleSignal;
                    {
                        this.val$warning = idlingPolicy;
                        this.val$error = idlingPolicy2;
                        this.val$idleSignal = signalingTask;
                    }

                    @Override
                    public void resourcesStillBusyWarning(List<String> list) {
                        this.val$warning.handleTimeout(list, "IdlingResources are still busy!");
                    }

                    @Override
                    public void resourcesHaveTimedOut(List<String> list) {
                        this.val$error.handleTimeout(list, "IdlingResources have timed out!");
                        UiControllerImpl.this.controllerHandler.post((Runnable)this.val$idleSignal);
                    }

                    @Override
                    public void allResourcesIdle() {
                        UiControllerImpl.this.controllerHandler.post((Runnable)this.val$idleSignal);
                    }
                };
                object.registerNotificationCallback(idleNotificationCallback);
                ((AbstractCollection)object4).add(IdleCondition.DYNAMIC_TASKS_HAVE_IDLED);
            }
            try {
                object4 = this.loopUntil((EnumSet<IdleCondition>)object4, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)object);
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                object4.cancelCallback();
                if (this.asyncIdle.isIdleNow()) {
                    if (this.compatIdle.isIdleNow()) {
                        if (object4.isIdleNow()) {
                            return;
                        }
                        object = object4;
                        continue;
                    }
                    object = object4;
                    continue;
                }
                object = object4;
            }
            catch (Throwable throwable) {
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                object.cancelCallback();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void loopMainThreadForAtLeast(long l) {
        this.initialize();
        boolean bl = Looper.myLooper() == this.mainLooper;
        Preconditions.checkState(bl, "Expecting to be on main thread!");
        bl = !IdleCondition.DELAY_HAS_PAST.isSignaled(this.conditionSet);
        Preconditions.checkState(bl, "recursion detected!");
        bl = l > 0L;
        Preconditions.checkArgument(bl);
        Handler handler = this.controllerHandler;
        SignalingTask<Void> signalingTask = new SignalingTask<Void>(NO_OP, IdleCondition.DELAY_HAS_PAST, this.generation);
        handler.postAtTime(signalingTask, (Object)this.generation, SystemClock.uptimeMillis() + l);
        this.loopUntil(IdleCondition.DELAY_HAS_PAST, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        this.loopMainThreadUntilIdle();
    }

    public boolean handleMessage(Message object) {
        if (!IdleCondition.handleMessage(object, ((UiControllerImpl)((Object)string)).conditionSet, ((UiControllerImpl)((Object)string)).generation)) {
            String string = TAG;
            object = String.valueOf(object);
            String string2 = String.valueOf(object);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            Log.i((String)string, (String)stringBuilder.append("Unknown message type: ").append((String)object).toString());
            return false;
        }
        return true;
    }

    private void loopUntil(IdleCondition idleCondition, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> idleNotifier) {
        this.loopUntil(EnumSet.of(idleCondition), idleNotifier);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> loopUntil(EnumSet<IdleCondition> var1_1, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> var2_2) {
        block12: {
            var3_4 = IdlingPolicies.getMasterIdlingPolicy();
            try {
                var4_5 = SystemClock.uptimeMillis();
                var6_6 = var3_4.getIdleTimeoutUnit().toMillis(var3_4.getIdleTimeout());
                var8_7 = new MainThreadInterrogation((EnumSet<IdleCondition>)var1_1, this.conditionSet, var4_5 += var6_6);
                this.interrogation = var8_7;
                var8_7 = this.interrogation;
                var8_7 = Interrogator.loopAndInterrogate(var8_7);
                var9_8 = InterrogationStatus.COMPLETED;
                if (var9_8 == var8_7) break block12;
            }
            catch (Throwable var2_3) {
                ++this.generation;
                var1_1 = var1_1.iterator();
                while (true) {
                    if (!var1_1.hasNext()) {
                        this.interrogation = null;
                        throw var2_3;
                    }
                    ((IdleCondition)var1_1.next()).reset(this.conditionSet);
                }
            }
            {
                var9_8 = InterrogationStatus.INTERRUPTED;
                if (var9_8 != var8_7) ** GOTO lbl27
            }
            {
                Log.w((String)UiControllerImpl.TAG, (String)"Espresso interrogation of the main thread is interrupted");
                var2_2 = new RuntimeException("Espresso interrogation of the main thread is interrupted");
                throw var2_2;
lbl27:
                // 1 sources

                var8_7 = Lists.newArrayList();
                var9_8 = var1_1.iterator();
                while ((var10_12 = var9_8.hasNext()) != 0) {
                    var10_11 = (IdleCondition)var9_8.next();
                    var11_14 = var10_11.isSignaled(this.conditionSet);
                    if (var11_14) continue;
                    var8_7.add(var10_11.name());
                }
                var9_9 = var8_7.isEmpty();
                if (!var9_9) ** GOTO lbl43
                var9_8 = this.interrogation.getMessage();
                var10_12 = String.valueOf(var9_8).length();
            }
            {
                var11_15 = new StringBuilder(var10_12 += 37);
                var8_7.add(var11_15.append("MAIN_LOOPER_HAS_IDLED(last message: ").append((String)var9_8).append(")").toString());
lbl43:
                // 2 sources

                var9_10 = Locale.ROOT;
                var10_13 = "Looped for %s iterations over %s %s.";
                var11_16 = new Object[]{MainThreadInterrogation.access$300(this.interrogation), var3_4.getIdleTimeout(), var3_4.getIdleTimeoutUnit().name()};
                var3_4.handleTimeout((List<String>)var8_7, String.format(var9_10, var10_13, var11_16));
                ++this.generation;
            }
            var1_1 = var1_1.iterator();
            while (true) {
                if (!var1_1.hasNext()) {
                    this.interrogation = null;
                    return var2_2;
                }
                ((IdleCondition)var1_1.next()).reset(this.conditionSet);
            }
        }
        ++this.generation;
        var1_1 = var1_1.iterator();
        while (true) {
            if (!var1_1.hasNext()) {
                this.interrogation = null;
                return var2_2;
            }
            ((IdleCondition)var1_1.next()).reset(this.conditionSet);
        }
    }

    @Override
    public void interruptEspressoTasks() {
        this.initialize();
        Handler handler = this.controllerHandler;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (UiControllerImpl.this.interrogation != null) {
                    UiControllerImpl.this.interrogation.interruptInterrogation();
                    UiControllerImpl.this.controllerHandler.removeCallbacksAndMessages((Object)UiControllerImpl.this.generation);
                    return;
                }
            }
        };
        handler.post(runnable);
    }

    private void initialize() {
        if (this.controllerHandler == null) {
            Handler handler;
            this.controllerHandler = handler = new Handler((Handler.Callback)this);
            return;
        }
    }

    static {
        Callable<Void> callable;
        TAG = UiControllerImpl.class.getSimpleName();
        NO_OP = callable = new Callable<Void>(){

            @Override
            public Void call() {
                return null;
            }
        };
    }

    private class SignalingTask<T>
    extends FutureTask<T> {
        private final IdleCondition condition;
        private final int myGeneration;

        public SignalingTask(Callable<T> callable, IdleCondition idleCondition, int n) {
            super(callable);
            this.condition = Preconditions.checkNotNull(idleCondition);
            this.myGeneration = n;
        }

        @Override
        protected void done() {
            UiControllerImpl.this.controllerHandler.sendMessage(this.condition.createSignal(UiControllerImpl.this.controllerHandler, this.myGeneration));
        }
    }

    private static final class MainThreadInterrogation
    implements Interrogator.InterrogationHandler<InterrogationStatus> {
        private final EnumSet<IdleCondition> conditions;
        private final BitSet conditionSet;
        private final long giveUpAtMs;
        private String lastMessage;
        private InterrogationStatus status = InterrogationStatus.COMPLETED;
        private int execCount = 0;

        MainThreadInterrogation(EnumSet<IdleCondition> enumSet, BitSet bitSet, long l) {
            this.conditions = enumSet;
            this.conditionSet = bitSet;
            this.giveUpAtMs = l;
        }

        @Override
        public void setMessage(Message message) {
            try {
                this.lastMessage = message.toString();
                return;
            }
            catch (NullPointerException nullPointerException) {
                String string = String.valueOf(nullPointerException);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 32);
                this.lastMessage = stringBuilder.append("NPE calling message toString(): ").append(string).toString();
                return;
            }
        }

        @Override
        public String getMessage() {
            return this.lastMessage;
        }

        @Override
        public void quitting() {
        }

        @Override
        public boolean barrierUp() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean queueEmpty() {
            return !this.conditionsMet();
        }

        @Override
        public boolean taskDueSoon() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean taskDueLong() {
            return !this.conditionsMet();
        }

        @Override
        public boolean beforeTaskDispatch() {
            ++this.execCount;
            return this.continueOrTimeout();
        }

        private boolean continueOrTimeout() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return false;
            }
            if (SystemClock.uptimeMillis() >= this.giveUpAtMs) {
                this.status = InterrogationStatus.TIMED_OUT;
                return false;
            }
            return true;
        }

        void interruptInterrogation() {
            this.status = InterrogationStatus.INTERRUPTED;
        }

        @Override
        public InterrogationStatus get() {
            return this.status;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean conditionsMet() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return true;
            }
            boolean bl = this.execCount > 0 && this.execCount % 100 == 0;
            Iterator iterator = this.conditions.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                IdleCondition idleCondition = (IdleCondition)((Object)iterator.next());
                if (idleCondition.isSignaled(this.conditionSet)) continue;
                if (!bl) {
                    return false;
                }
                String string = TAG;
                String string2 = idleCondition.name();
                int n = this.execCount;
                String string3 = String.valueOf(string2);
                int n2 = string3.length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 41);
                Log.w((String)string, (String)stringBuilder.append("Waiting for: ").append(string2).append(" for ").append(n).append(" iterations.").toString());
                bl2 = false;
            }
            return bl2;
        }

        static /* synthetic */ int access$300(MainThreadInterrogation mainThreadInterrogation) {
            return mainThreadInterrogation.execCount;
        }
    }

    private static final class InterrogationStatus
    extends Enum<InterrogationStatus> {
        public static final /* enum */ InterrogationStatus TIMED_OUT;
        public static final /* enum */ InterrogationStatus COMPLETED;
        public static final /* enum */ InterrogationStatus INTERRUPTED;
        private static final /* synthetic */ InterrogationStatus[] $VALUES;

        public static InterrogationStatus[] values() {
            return (InterrogationStatus[])$VALUES.clone();
        }

        public static InterrogationStatus valueOf(String string) {
            return Enum.valueOf(InterrogationStatus.class, string);
        }

        static {
            InterrogationStatus[] interrogationStatusArray = new InterrogationStatus();
            TIMED_OUT = interrogationStatusArray;
            interrogationStatusArray = new InterrogationStatus();
            COMPLETED = interrogationStatusArray;
            interrogationStatusArray = new InterrogationStatus();
            INTERRUPTED = interrogationStatusArray;
            interrogationStatusArray = new InterrogationStatus[]{TIMED_OUT, COMPLETED, INTERRUPTED};
            $VALUES = interrogationStatusArray;
        }
    }

    static final class IdleCondition
    extends Enum<IdleCondition> {
        public static final /* enum */ IdleCondition DELAY_HAS_PAST;
        public static final /* enum */ IdleCondition ASYNC_TASKS_HAVE_IDLED;
        public static final /* enum */ IdleCondition COMPAT_TASKS_HAVE_IDLED;
        public static final /* enum */ IdleCondition KEY_INJECT_HAS_COMPLETED;
        public static final /* enum */ IdleCondition MOTION_INJECTION_HAS_COMPLETED;
        public static final /* enum */ IdleCondition DYNAMIC_TASKS_HAVE_IDLED;
        private static final /* synthetic */ IdleCondition[] $VALUES;

        public static IdleCondition[] values() {
            return (IdleCondition[])$VALUES.clone();
        }

        public static IdleCondition valueOf(String string) {
            return Enum.valueOf(IdleCondition.class, string);
        }

        public boolean isSignaled(BitSet bitSet) {
            return bitSet.get(this.ordinal());
        }

        public void reset(BitSet bitSet) {
            bitSet.set(this.ordinal(), false);
        }

        public Message createSignal(Handler handler, int n) {
            return Message.obtain((Handler)handler, (int)this.ordinal(), (int)n, (int)0, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean handleMessage(Message message, BitSet object, int n) {
            Object object2 = IdleCondition.values();
            if (message.what < 0 || message.what >= ((IdleCondition[])object2).length) return false;
            object2 = object2[message.what];
            if (message.arg1 == n) {
                ((IdleCondition)((Object)object2)).signal((BitSet)object);
                return true;
            }
            object = TAG;
            object2 = String.valueOf(object2);
            int n2 = message.arg1;
            String string = String.valueOf(object2);
            int n3 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 90);
            Log.w((String)object, (String)stringBuilder.append("ignoring signal of: ").append((String)object2).append(" from previous generation: ").append(n2).append(" current generation: ").append(n).toString());
            return true;
        }

        public static BitSet createConditionSet() {
            BitSet bitSet = new BitSet(IdleCondition.values().length);
            return bitSet;
        }

        protected void signal(BitSet bitSet) {
            bitSet.set(this.ordinal());
        }

        static {
            IdleCondition[] idleConditionArray = new IdleCondition();
            DELAY_HAS_PAST = idleConditionArray;
            idleConditionArray = new IdleCondition();
            ASYNC_TASKS_HAVE_IDLED = idleConditionArray;
            idleConditionArray = new IdleCondition();
            COMPAT_TASKS_HAVE_IDLED = idleConditionArray;
            idleConditionArray = new IdleCondition();
            KEY_INJECT_HAS_COMPLETED = idleConditionArray;
            idleConditionArray = new IdleCondition();
            MOTION_INJECTION_HAS_COMPLETED = idleConditionArray;
            idleConditionArray = new IdleCondition();
            DYNAMIC_TASKS_HAVE_IDLED = idleConditionArray;
            idleConditionArray = new IdleCondition[]{DELAY_HAS_PAST, ASYNC_TASKS_HAVE_IDLED, COMPAT_TASKS_HAVE_IDLED, KEY_INJECT_HAS_COMPLETED, MOTION_INJECTION_HAS_COMPLETED, DYNAMIC_TASKS_HAVE_IDLED};
            $VALUES = idleConditionArray;
        }
    }
}

