/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.app.Activity;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.NoMatchingRootException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.RootViewPickerScope;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.LogUtil;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@RootViewPickerScope
public final class RootViewPicker
implements Provider<View> {
    private static final String TAG = RootViewPicker.class.getSimpleName();
    private static final ImmutableList<Integer> CREATED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(150), Integer.valueOf(250));
    private static final ImmutableList<Integer> RESUMED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(500), Integer.valueOf(2000), Integer.valueOf(30000));
    private final UiController uiController;
    private final ActivityLifecycleMonitor activityLifecycleMonitor;
    private final AtomicReference<Boolean> needsActivity;
    private final RootResultFetcher rootResultFetcher;
    private final ControlledLooper controlledLooper;

    RootViewPicker(UiController uiController, RootResultFetcher rootResultFetcher, ActivityLifecycleMonitor activityLifecycleMonitor, AtomicReference<Boolean> atomicReference, ControlledLooper controlledLooper) {
        this.uiController = uiController;
        this.rootResultFetcher = rootResultFetcher;
        this.activityLifecycleMonitor = activityLifecycleMonitor;
        this.needsActivity = atomicReference;
        this.controlledLooper = controlledLooper;
    }

    public View get() {
        Preconditions.checkState(Looper.getMainLooper().equals(Looper.myLooper()), "must be called on main thread.");
        if (this.needsActivity.get().booleanValue()) {
            this.waitForAtLeastOneActivityToBeResumed();
        }
        return this.pickRootView();
    }

    private Root waitForRootToBeReady(Root root) {
        block2: {
            long l = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            Object object = new RootReadyBackoff();
            while (System.currentTimeMillis() <= l) {
                if (!root.isReady()) {
                    ((RootViewPicker)object2).controlledLooper.simulateWindowFocus(root.getDecorView());
                    ((RootViewPicker)object2).uiController.loopMainThreadForAtLeast(((BackOff)object).getNextBackoffInMillis());
                    continue;
                }
                break block2;
            }
            object = Locale.ROOT;
            Object[] objectArray = new Object[]{root};
            Object object2 = new RuntimeException(String.format((Locale)object, "Waited for the root of the view hierarchy to have window focus and not request layout for 10 seconds. If you specified a non default root matcher, it may be picking a root that never takes focus. Root:\n%s", objectArray));
            throw object2;
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    private Root pickARoot() {
        var2_1 = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        var1_2 = this.rootResultFetcher.fetch();
        var4_3 = new NoActiveRootsBackoff();
        var5_4 = new NoMatchingRootBackoff();
        block5: while (System.currentTimeMillis() <= var2_1) {
            switch (1.$SwitchMap$androidx$test$espresso$base$RootViewPicker$RootResults$State[var1_2.getState().ordinal()]) lbl-1000:
            // 3 sources

            {
                default: {
                    var1_2 = this.rootResultFetcher.fetch();
                    continue block5;
                }
                case 3: {
                    this.uiController.loopMainThreadForAtLeast(var5_4.getNextBackoffInMillis());
                    ** GOTO lbl-1000
                }
                case 2: {
                    this.uiController.loopMainThreadForAtLeast(var4_3.getNextBackoffInMillis());
                    ** GOTO lbl-1000
                }
                case 1: 
            }
            return var1_2.getPickedRoot();
        }
        if (RootResults.State.ROOTS_PICKED != var1_2.getState()) {
            throw NoMatchingRootException.create((Matcher<Root>)RootResults.access$000(var1_2), RootResults.access$100(var1_2));
        }
        return var1_2.getPickedRoot();
    }

    private View pickRootView() {
        return this.waitForRootToBeReady(this.pickARoot()).getDecorView();
    }

    private void waitForAtLeastOneActivityToBeResumed() {
        Object object;
        List<Activity> list = ((RootViewPicker)object).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        if (list.isEmpty()) {
            ((RootViewPicker)object).uiController.loopMainThreadUntilIdle();
            list = ((RootViewPicker)object).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        }
        if (list.isEmpty()) {
            StringBuilder stringBuilder;
            long l;
            Object object2;
            list = ((RootViewPicker)object).getAllActiveActivities();
            if (list.isEmpty()) {
                object2 = CREATED_WAIT_TIMES.iterator();
                while (object2.hasNext()) {
                    l = ((Integer)object2.next()).intValue();
                    list = TAG;
                    stringBuilder = new StringBuilder(72);
                    Log.w((String)((Object)list), (String)stringBuilder.append("No activities found - waiting: ").append(l).append("ms for one to appear.").toString());
                    ((RootViewPicker)object).uiController.loopMainThreadForAtLeast(l);
                    list = super.getAllActiveActivities();
                    if (list.isEmpty()) continue;
                }
            }
            if (list.isEmpty()) {
                object = new RuntimeException("No activities found. Did you forget to launch the activity by calling getActivity() or startActivitySync or similar?");
                throw object;
            }
            list = RESUMED_WAIT_TIMES.iterator();
            while (list.hasNext()) {
                l = ((Integer)list.next()).intValue();
                object2 = TAG;
                stringBuilder = new StringBuilder(82);
                Log.w((String)object2, (String)stringBuilder.append("No activity currently resumed - waiting: ").append(l).append("ms for one to appear.").toString());
                ((RootViewPicker)object).uiController.loopMainThreadForAtLeast(l);
                if (((RootViewPicker)object).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED).isEmpty()) continue;
                return;
            }
        } else {
            return;
        }
        object = new NoActivityResumedException("No activities in stage RESUMED. Did you forget to launch the activity. (test.getActivity() or similar)?");
        throw object;
    }

    private List<Activity> getAllActiveActivities() {
        ArrayList<Activity> arrayList = Lists.newArrayList();
        for (Object e : EnumSet.range(Stage.PRE_ON_CREATE, Stage.RESTARTED)) {
            Stage object = (Stage)e;
            arrayList.addAll(this.activityLifecycleMonitor.getActivitiesInStage(object));
        }
        return arrayList;
    }

    private static final class RootReadyBackoff
    extends BackOff {
        private static final ImmutableList<Integer> ROOT_READY_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(800), Integer.valueOf(1000));

        public RootReadyBackoff() {
            super(ROOT_READY_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)string)).getBackoffForAttempt();
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{l};
            Log.d((String)string, (String)String.format(locale, "Root not ready - waiting: %sms for one to appear.", objectArray));
            return l;
        }
    }

    private static final class NoMatchingRootBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_MATCHING_ROOT_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(1000), Integer.valueOf(2000));

        public NoMatchingRootBackoff() {
            super(NO_MATCHING_ROOT_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)string)).getBackoffForAttempt();
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{l};
            Log.d((String)string, (String)String.format(locale, "No matching root available - waiting: %sms for one to appear.", objectArray));
            return l;
        }
    }

    private static final class NoActiveRootsBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_ACTIVE_ROOTS_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(30), Integer.valueOf(50), Integer.valueOf(80), Integer.valueOf(130), Integer.valueOf(210), Integer.valueOf(340));

        public NoActiveRootsBackoff() {
            super(NO_ACTIVE_ROOTS_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)string)).getBackoffForAttempt();
            String string = TAG;
            Object[] objectArray = new Object[]{l};
            LogUtil.logDebugWithProcess((String)string, (String)"No active roots available - waiting: %sms for one to appear.", (Object[])objectArray);
            return l;
        }
    }

    private static abstract class BackOff {
        private final List<Integer> backoffTimes;
        private final TimeUnit timeUnit;
        private int numberOfAttempts = 0;

        public BackOff(List<Integer> list, TimeUnit timeUnit) {
            this.backoffTimes = list;
            this.timeUnit = timeUnit;
        }

        protected abstract long getNextBackoffInMillis();

        protected final long getBackoffForAttempt() {
            if (this.numberOfAttempts < this.backoffTimes.size()) {
                Object object = this.backoffTimes;
                int n = this.numberOfAttempts++;
                object = object.get(n);
                object = (Integer)object;
                int n2 = (Integer)object;
                return this.timeUnit.toMillis(n2);
            }
            return this.backoffTimes.get(this.backoffTimes.size() + -1).intValue();
        }
    }

    static class RootResultFetcher {
        private final Matcher<Root> selector;
        private final ActiveRootLister activeRootLister;

        public RootResultFetcher(ActiveRootLister activeRootLister, AtomicReference<Matcher<Root>> atomicReference) {
            this.activeRootLister = activeRootLister;
            this.selector = atomicReference.get();
        }

        public RootResults fetch() {
            List<Root> list = this.activeRootLister.listActiveRoots();
            ArrayList<Root> arrayList = Lists.newArrayList();
            for (Root root : list) {
                if (!this.selector.matches((Object)root)) continue;
                arrayList.add(root);
            }
            Object object = new RootResults(list, arrayList, this.selector);
            return object;
        }
    }

    private static class RootResults {
        private final List<Root> allRoots;
        private final List<Root> pickedRoots;
        private final Matcher<Root> rootSelector;

        private RootResults(List<Root> list, List<Root> list2, Matcher<Root> matcher) {
            this.allRoots = list;
            this.pickedRoots = list2;
            this.rootSelector = matcher;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTopmostRoot(Root root, Root root2) {
            if (root2.getWindowLayoutParams().get().type <= root.getWindowLayoutParams().get().type) return false;
            return true;
        }

        public State getState() {
            if (this.allRoots.isEmpty()) {
                return State.NO_ROOTS_PRESENT;
            }
            if (this.pickedRoots.isEmpty()) {
                return State.NO_ROOTS_PICKED;
            }
            if (this.pickedRoots.size() > 0) {
                return State.ROOTS_PICKED;
            }
            return State.NO_ROOTS_PICKED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Root getRootFromMultipleRoots() {
            Root root = ((RootResults)object).pickedRoots.get(0);
            if (((RootResults)object).pickedRoots.size() <= 0) return root;
            Iterator<Root> iterator = ((RootResults)object).pickedRoots.iterator();
            Object object = root;
            while (iterator.hasNext()) {
                root = iterator.next();
                if (RootMatchers.isDialog().matches((Object)root)) return root;
                if (!RootResults.isTopmostRoot((Root)object, root)) continue;
                object = root;
            }
            return object;
        }

        public Root getPickedRoot() {
            if (this.pickedRoots.size() > 1) {
                String string = TAG;
                Object[] objectArray = new Object[]{this.pickedRoots};
                LogUtil.logDebugWithProcess((String)string, (String)"Multiple root windows detected: %s", (Object[])objectArray);
                return this.getRootFromMultipleRoots();
            }
            return this.pickedRoots.get(0);
        }

        static /* synthetic */ Matcher access$000(RootResults rootResults) {
            return rootResults.rootSelector;
        }

        static /* synthetic */ List access$100(RootResults rootResults) {
            return rootResults.allRoots;
        }

        static final class State
        extends Enum<State> {
            public static final /* enum */ State NO_ROOTS_PRESENT;
            public static final /* enum */ State NO_ROOTS_PICKED;
            public static final /* enum */ State ROOTS_PICKED;
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }

            static {
                State[] stateArray = new State();
                NO_ROOTS_PRESENT = stateArray;
                stateArray = new State();
                NO_ROOTS_PICKED = stateArray;
                stateArray = new State();
                ROOTS_PICKED = stateArray;
                stateArray = new State[]{NO_ROOTS_PRESENT, NO_ROOTS_PICKED, ROOTS_PICKED};
                $VALUES = stateArray;
            }
        }
    }
}

