/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.Interrogator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

class LooperIdlingResourceInterrogationHandler
implements Interrogator.InterrogationHandler<Void>,
IdlingResource {
    private static final ConcurrentHashMap<String, LooperIdlingResourceInterrogationHandler> insts;
    private final Interrogator.QueueInterrogationHandler<Boolean> queueHasNewTasks;
    private final String name;
    private volatile boolean started;
    private volatile MessageQueue queue;
    private volatile boolean idle;
    private volatile IdlingResource.ResourceCallback cb;

    private LooperIdlingResourceInterrogationHandler(String string) {
        Interrogator.QueueInterrogationHandler<Boolean> queueInterrogationHandler;
        this.queueHasNewTasks = queueInterrogationHandler = new Interrogator.QueueInterrogationHandler<Boolean>(this){
            private Boolean hasTasks = Boolean.FALSE;

            @Override
            public Boolean get() {
                return this.hasTasks;
            }

            @Override
            public boolean queueEmpty() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueLong() {
                this.hasTasks = Boolean.FALSE;
                return false;
            }

            @Override
            public boolean taskDueSoon() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }

            @Override
            public boolean barrierUp() {
                this.hasTasks = Boolean.TRUE;
                return false;
            }
        };
        this.started = false;
        this.queue = null;
        this.idle = true;
        this.cb = null;
        this.name = string;
    }

    static LooperIdlingResourceInterrogationHandler forLooper(Looper object) {
        Object object2 = Locale.ROOT;
        Object object3 = new Object[]{object.getThread().getId(), object.getThread().getName()};
        object2 = String.format((Locale)object2, "LooperIdlingResource-%s-%s", object3);
        object3 = new LooperIdlingResourceInterrogationHandler((String)object2);
        if ((object2 = insts.putIfAbsent((String)object2, (LooperIdlingResourceInterrogationHandler)object3)) != null) {
            return object2;
        }
        object2 = new Handler(object);
        object = new Runnable((LooperIdlingResourceInterrogationHandler)object3){
            final /* synthetic */ LooperIdlingResourceInterrogationHandler val$ir;
            {
                this.val$ir = looperIdlingResourceInterrogationHandler;
            }

            @Override
            public void run() {
                LooperIdlingResourceInterrogationHandler.access$002(this.val$ir, Looper.myQueue());
                LooperIdlingResourceInterrogationHandler.access$102(this.val$ir, true);
                Interrogator.loopAndInterrogate(this.val$ir);
            }
        };
        object2.post((Runnable)object);
        return object3;
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public void quitting() {
        this.transitionToIdle();
    }

    @Override
    public boolean queueEmpty() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean taskDueLong() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean beforeTaskDispatch() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean taskDueSoon() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean barrierUp() {
        this.idle = false;
        return true;
    }

    @Override
    public Void get() {
        return null;
    }

    public boolean isIdleNow() {
        if (!this.started) {
            return false;
        }
        if (this.idle) {
            return Boolean.FALSE.equals(Interrogator.peekAtQueueState(this.queue, this.queueHasNewTasks));
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
        this.cb = resourceCallback;
    }

    private void transitionToIdle() {
        this.idle = true;
        if (this.cb != null) {
            this.cb.onTransitionToIdle();
            return;
        }
    }

    static /* synthetic */ MessageQueue access$002(LooperIdlingResourceInterrogationHandler looperIdlingResourceInterrogationHandler, MessageQueue messageQueue) {
        looperIdlingResourceInterrogationHandler.queue = messageQueue;
        return messageQueue;
    }

    static /* synthetic */ boolean access$102(LooperIdlingResourceInterrogationHandler looperIdlingResourceInterrogationHandler, boolean bl) {
        looperIdlingResourceInterrogationHandler.started = bl;
        return bl;
    }

    static {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        insts = concurrentHashMap;
    }
}

