/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.LooperIdlingResourceInterrogationHandler;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class IdlingResourceRegistry {
    private static final String TAG = IdlingResourceRegistry.class.getSimpleName();
    private static final int DYNAMIC_RESOURCE_HAS_IDLED = 1;
    private static final int TIMEOUT_OCCURRED = 2;
    private static final int IDLE_WARNING_REACHED = 3;
    private static final int POSSIBLE_RACE_CONDITION_DETECTED = 4;
    private static final Object TIMEOUT_MESSAGE_TAG;
    private static final IdleNotificationCallback NO_OP_CALLBACK;
    private final List<IdlingState> idlingStates;
    private final Looper looper;
    private final Handler handler;
    private final Dispatcher dispatcher;
    private IdleNotificationCallback idleNotificationCallback;

    public IdlingResourceRegistry(Looper looper) {
        Object object = new ArrayList();
        this.idlingStates = object;
        this.idleNotificationCallback = NO_OP_CALLBACK;
        this.looper = looper;
        this.dispatcher = object = new Dispatcher();
        object = new Handler(looper, (Handler.Callback)this.dispatcher);
        this.handler = object;
    }

    public void sync(final Iterable<IdlingResource> arrayList, Iterable<Looper> object) {
        if (Looper.myLooper() != this.looper) {
            Callable<Void> callable = new Callable<Void>((Iterable)object){
                final /* synthetic */ Iterable val$loopers;
                {
                    this.val$loopers = iterable2;
                }

                @Override
                public Void call() {
                    IdlingResourceRegistry.this.sync(arrayList, this.val$loopers);
                    return null;
                }
            };
            this.runSynchronouslyOnMainThread(callable);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (IdlingResource object2 : arrayList) {
            if (hashMap.containsKey(object2.getName())) {
                this.logDuplicateRegistrationError(object2, (IdlingResource)hashMap.get(object2.getName()));
                continue;
            }
            hashMap.put(object2.getName(), object2);
        }
        arrayList = object.iterator();
        while (arrayList.hasNext()) {
            object = LooperIdlingResourceInterrogationHandler.forLooper((Looper)arrayList.next());
            if (hashMap.containsKey(object.getName())) {
                this.logDuplicateRegistrationError((IdlingResource)object, (IdlingResource)hashMap.get(object.getName()));
                continue;
            }
            hashMap.put(object.getName(), object);
        }
        arrayList = new ArrayList<IdlingResource>();
        for (IdlingState idlingState : this.idlingStates) {
            IdlingResource idlingResource = (IdlingResource)hashMap.remove(idlingState.resource.getName());
            if (idlingResource == null) {
                arrayList.add(idlingState.resource);
                continue;
            }
            if (idlingState.resource == idlingResource) continue;
            arrayList.add(idlingState.resource);
            hashMap.put(idlingResource.getName(), idlingResource);
        }
        this.unregisterResources(arrayList);
        this.registerResources(Lists.newArrayList(hashMap.values()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean registerResources(final List<? extends IdlingResource> list) {
        if (Looper.myLooper() != this.looper) {
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return IdlingResourceRegistry.this.registerResources(list);
                }
            };
            return this.runSynchronouslyOnMainThread(callable);
        }
        Iterator<? extends IdlingResource> iterator = list.iterator();
        boolean bl = true;
        while (true) {
            boolean bl2;
            IdlingResource idlingResource;
            block5: {
                if (!iterator.hasNext()) {
                    return bl;
                }
                idlingResource = iterator.next();
                Preconditions.checkNotNull(idlingResource.getName(), "IdlingResource.getName() should not be null");
                for (IdlingState idlingState : this.idlingStates) {
                    if (!idlingResource.getName().equals(idlingState.resource.getName())) continue;
                    this.logDuplicateRegistrationError(idlingResource, idlingState.resource);
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
            if (!bl2) {
                IdlingState idlingState = new IdlingState(idlingResource, this.handler);
                this.idlingStates.add(idlingState);
                idlingState.registerSelf();
                continue;
            }
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unregisterResources(final List<? extends IdlingResource> list) {
        if (Looper.myLooper() != this.looper) {
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return IdlingResourceRegistry.this.unregisterResources(list);
                }
            };
            return this.runSynchronouslyOnMainThread(callable);
        }
        Iterator<? extends IdlingResource> iterator = list.iterator();
        boolean bl = true;
        while (true) {
            int n;
            IdlingResource idlingResource;
            block5: {
                if (!iterator.hasNext()) {
                    return bl;
                }
                idlingResource = iterator.next();
                for (n = 0; n < this.idlingStates.size(); ++n) {
                    if (!this.idlingStates.get((int)n).resource.getName().equals(idlingResource.getName())) {
                        continue;
                    }
                    this.idlingStates.remove(n);
                    n = 1;
                    break block5;
                }
                n = 0;
            }
            if (n != 0) continue;
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{idlingResource.getName(), this.getResources()};
            Log.e((String)string, (String)String.format(locale, "Attempted to unregister resource that is not registered: '%s'. Resource list: %s", objectArray));
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerLooper(Looper looper, boolean bl) {
        Preconditions.checkNotNull(looper);
        bl = Looper.getMainLooper() != looper;
        Preconditions.checkArgument(bl, "Not intended for use with main looper!");
        LooperIdlingResourceInterrogationHandler[] looperIdlingResourceInterrogationHandlerArray = new LooperIdlingResourceInterrogationHandler[]{LooperIdlingResourceInterrogationHandler.forLooper(looper)};
        this.registerResources(Lists.newArrayList(looperIdlingResourceInterrogationHandlerArray));
    }

    public List<IdlingResource> getResources() {
        if (Looper.myLooper() != ((IdlingResourceRegistry)((Object)iterator)).looper) {
            Callable<List<IdlingResource>> callable = new Callable<List<IdlingResource>>(){

                @Override
                public List<IdlingResource> call() {
                    return IdlingResourceRegistry.this.getResources();
                }
            };
            return ((IdlingResourceRegistry)((Object)iterator)).runSynchronouslyOnMainThread(callable);
        }
        ImmutableList.Builder<IdlingResource> builder = ImmutableList.builder();
        Iterator<IdlingState> iterator = ((IdlingResourceRegistry)((Object)iterator)).idlingStates.iterator();
        while (iterator.hasNext()) {
            builder.add(((IdlingState)iterator.next()).resource);
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean allResourcesAreIdle() {
        IdlingState idlingState;
        boolean bl = Looper.myLooper() == ((IdlingResourceRegistry)((Object)iterator)).looper;
        Preconditions.checkState(bl);
        Iterator<IdlingState> iterator = ((IdlingResourceRegistry)((Object)iterator)).idlingStates.iterator();
        do {
            if (!iterator.hasNext()) {
                Log.d((String)TAG, (String)"All idling resources are idle.");
                return true;
            }
            idlingState = (IdlingState)iterator.next();
            if (!idlingState.idle) continue;
            idlingState.idle = idlingState.resource.isIdleNow();
        } while (idlingState.idle);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void notifyWhenAllResourcesAreIdle(IdleNotificationCallback idleNotificationCallback) {
        Preconditions.checkNotNull(idleNotificationCallback);
        boolean bl = Looper.myLooper() == this.looper;
        Preconditions.checkState(bl);
        bl = this.idleNotificationCallback == NO_OP_CALLBACK;
        Preconditions.checkState(bl, "Callback has already been registered.");
        if (this.allResourcesAreIdle()) {
            idleNotificationCallback.allResourcesIdle();
            return;
        }
        this.idleNotificationCallback = idleNotificationCallback;
        this.scheduleTimeoutMessages();
    }

    IdleNotifier<IdleNotificationCallback> asIdleNotifier() {
        IdleNotifier<IdleNotificationCallback> idleNotifier = new IdleNotifier<IdleNotificationCallback>(){

            @Override
            public boolean isIdleNow() {
                return IdlingResourceRegistry.this.allResourcesAreIdle();
            }

            @Override
            public void cancelCallback() {
                IdlingResourceRegistry.this.cancelIdleMonitor();
            }

            @Override
            public void registerNotificationCallback(IdleNotificationCallback idleNotificationCallback) {
                IdlingResourceRegistry.this.notifyWhenAllResourcesAreIdle(idleNotificationCallback);
            }
        };
        return idleNotifier;
    }

    void cancelIdleMonitor() {
        this.dispatcher.deregister();
    }

    private <T> T runSynchronouslyOnMainThread(Callable<T> object) {
        FutureTask<T> futureTask = new FutureTask<T>(object);
        idlingResourceRegistry.handler.post(futureTask);
        try {
            IdlingResourceRegistry idlingResourceRegistry = futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            object = new RuntimeException(interruptedException);
            throw object;
        }
        catch (CancellationException cancellationException) {
            object = new RuntimeException(cancellationException);
            throw object;
        }
        catch (ExecutionException executionException) {
            object = new RuntimeException(executionException);
            throw object;
        }
        return (T)idlingResourceRegistry;
    }

    private void scheduleTimeoutMessages() {
        IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
        Object object = this.handler;
        Object object2 = TIMEOUT_MESSAGE_TAG;
        object = object.obtainMessage(3, object2);
        this.handler.sendMessageDelayed((Message)object, idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
        idlingPolicy = this.handler;
        object = TIMEOUT_MESSAGE_TAG;
        idlingPolicy = idlingPolicy.obtainMessage(2, object);
        object = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
        this.handler.sendMessageDelayed((Message)idlingPolicy, ((IdlingPolicy)object).getIdleTimeoutUnit().toMillis(((IdlingPolicy)object).getIdleTimeout()));
    }

    private List<String> getBusyResources() {
        Message message = Lists.newArrayList();
        ArrayList<IdlingState> arrayList = Lists.newArrayList();
        for (IdlingState idlingState : this.idlingStates) {
            if (idlingState.idle) continue;
            if (idlingState.resource.isIdleNow()) {
                arrayList.add(idlingState);
                continue;
            }
            message.add(idlingState.resource.getName());
        }
        if (!arrayList.isEmpty()) {
            message = this.handler.obtainMessage(4, TIMEOUT_MESSAGE_TAG);
            message.obj = arrayList;
            this.handler.sendMessage(message);
            return null;
        }
        return message;
    }

    private void logDuplicateRegistrationError(IdlingResource idlingResource, IdlingResource idlingResource2) {
        String string = TAG;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{idlingResource.getName(), idlingResource, idlingResource2};
        Log.e((String)string, (String)String.format(locale, "Attempted to register resource with same names: %s. R1: %s R2: %s.\nDuplicate resource registration will be ignored.", objectArray));
    }

    static /* synthetic */ IdleNotificationCallback access$602(IdlingResourceRegistry idlingResourceRegistry, IdleNotificationCallback idleNotificationCallback) {
        idlingResourceRegistry.idleNotificationCallback = idleNotificationCallback;
        return idleNotificationCallback;
    }

    static {
        IdleNotificationCallback idleNotificationCallback = new Object();
        TIMEOUT_MESSAGE_TAG = idleNotificationCallback;
        idleNotificationCallback = new IdleNotificationCallback(){

            @Override
            public void allResourcesIdle() {
            }

            @Override
            public void resourcesStillBusyWarning(List<String> list) {
            }

            @Override
            public void resourcesHaveTimedOut(List<String> list) {
            }
        };
        NO_OP_CALLBACK = idleNotificationCallback;
    }

    private class Dispatcher
    implements Handler.Callback {
        private Dispatcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleMessage(Message object) {
            switch (object.what) {
                case 4: {
                    ((Dispatcher)((Object)string)).handleRaceCondition((Message)object);
                    return true;
                }
                case 3: {
                    ((Dispatcher)((Object)string)).handleTimeoutWarning();
                    return true;
                }
                case 2: {
                    ((Dispatcher)((Object)string)).handleTimeout();
                    return true;
                }
                case 1: {
                    ((Dispatcher)((Object)string)).handleResourceIdled((Message)object);
                    return true;
                }
            }
            String string = TAG;
            String string2 = String.valueOf(object);
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            Log.w((String)string, (String)stringBuilder.append("Unknown message type: ").append(string2).toString());
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleResourceIdled(Message message) {
            Object object = (IdlingState)message.obj;
            ((IdlingState)object).idle = true;
            Iterator iterator = ((Dispatcher)((Object)string)).IdlingResourceRegistry.this.idlingStates.iterator();
            boolean bl = true;
            boolean bl2 = true;
            while (iterator.hasNext()) {
                IdlingState idlingState = (IdlingState)iterator.next();
                bl2 = bl2 && idlingState.idle;
                if (!bl && !bl2) break;
                if (!bl || idlingState != object) continue;
                bl = false;
            }
            if (bl) {
                String string = TAG;
                String string2 = String.valueOf(((IdlingState)object).resource);
                String string3 = String.valueOf(string2);
                int n = string3.length();
                object = new StringBuilder(n + 45);
                Log.i((String)string, (String)((StringBuilder)object).append("Ignoring message from unregistered resource: ").append(string2).toString());
                return;
            }
            if (!bl2) return;
            try {
                ((Dispatcher)((Object)string)).IdlingResourceRegistry.this.idleNotificationCallback.allResourcesIdle();
                return;
            }
            finally {
                super.deregister();
            }
        }

        private void handleTimeoutWarning() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG));
                return;
            }
            IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
            IdlingResourceRegistry.this.idleNotificationCallback.resourcesStillBusyWarning(list);
            IdlingResourceRegistry.this.handler.sendMessageDelayed(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG), idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
        }

        private void handleTimeout() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(2, TIMEOUT_MESSAGE_TAG));
                return;
            }
            try {
                IdlingResourceRegistry.this.idleNotificationCallback.resourcesHaveTimedOut(list);
            }
            finally {
                this.deregister();
            }
        }

        private void handleRaceCondition(Message object) {
            Object object2 = ((List)object.obj).iterator();
            while (object2.hasNext()) {
                object = (IdlingState)object2.next();
                if (object.idle) continue;
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{object.resource.getName()};
                object2 = new IllegalStateException(String.format(locale, "Resource %s isIdleNow() is returning true, but a message indicating that the resource has transitioned from busy to idle was never sent.", objectArray));
                throw object2;
            }
        }

        private void deregister() {
            IdlingResourceRegistry.this.handler.removeCallbacksAndMessages(TIMEOUT_MESSAGE_TAG);
            IdlingResourceRegistry.access$602(IdlingResourceRegistry.this, NO_OP_CALLBACK);
        }
    }

    private static class IdlingState
    implements IdlingResource.ResourceCallback {
        final IdlingResource resource;
        final Handler handler;
        boolean idle;

        private IdlingState(IdlingResource idlingResource, Handler handler) {
            this.resource = idlingResource;
            this.handler = handler;
        }

        private void registerSelf() {
            this.resource.registerIdleTransitionCallback((IdlingResource.ResourceCallback)this);
            this.idle = this.resource.isIdleNow();
        }

        public void onTransitionToIdle() {
            Message message = this.handler.obtainMessage(1);
            message.obj = this;
            this.handler.sendMessage(message);
        }
    }

    static interface IdleNotificationCallback {
        public void allResourcesIdle();

        public void resourcesStillBusyWarning(List<String> var1);

        public void resourcesHaveTimedOut(List<String> var1);
    }
}

