/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

public final class DefaultFailureHandler
implements FailureHandler {
    private static final AtomicInteger failureCount;
    private final Context appContext;

    public DefaultFailureHandler(@TargetContext Context context) {
        this.appContext = Preconditions.checkNotNull(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handle(Throwable throwable, Matcher<View> matcher) {
        int n = failureCount.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder(29);
        TestOutputEmitter.takeScreenshot((String)stringBuilder.append("view-op-error-").append(n).append(".png").toString());
        stringBuilder = new StringBuilder(40);
        TestOutputEmitter.captureWindowHierarchy((String)stringBuilder.append("explore-window-hierarchy-").append(n).append(".xml").toString());
        if (!(throwable instanceof EspressoException || throwable instanceof AssertionFailedError || throwable instanceof AssertionError)) {
            Throwables.throwIfUnchecked(throwable);
            Object object = new RuntimeException(throwable);
            throw object;
        }
        Throwables.throwIfUnchecked(((DefaultFailureHandler)object).getUserFriendlyError(throwable, matcher));
        RuntimeException runtimeException = new RuntimeException(((DefaultFailureHandler)object).getUserFriendlyError(throwable, matcher));
        throw runtimeException;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Throwable getUserFriendlyError(Throwable throwable, Matcher<View> matcher) {
        Object object;
        if (throwable instanceof PerformException) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!DefaultFailureHandler.isAnimationAndTransitionDisabled(((DefaultFailureHandler)object).appContext)) {
                stringBuilder.append("Animations or transitions are enabled on the target device.\nFor more info check: https://developer.android.com/training/testing/espresso/setup#set-up-environment\n\n");
            }
            stringBuilder.append(matcher.toString());
            object = new PerformException.Builder();
            throw ((PerformException.Builder)object).from((PerformException)throwable).withViewDescription(stringBuilder.toString()).build();
        }
        object = throwable instanceof AssertionError ? new AssertionFailedWithCauseError(throwable.getMessage(), throwable) : throwable;
        ((Throwable)object).setStackTrace(Thread.currentThread().getStackTrace());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnimationAndTransitionDisabled(Context context) {
        context = context.getContentResolver();
        float f = DefaultFailureHandler.getTransitionAnimationScale((ContentResolver)context);
        boolean bl = DefaultFailureHandler.isEqualToZero(f);
        boolean bl2 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getWindowAnimationScale((ContentResolver)context));
        boolean bl3 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getAnimatorDurationScale((ContentResolver)context));
        if (!bl) {
            return false;
        }
        if (!bl2) return false;
        if (!bl3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEqualToZero(float f) {
        if (Float.compare(Math.abs(f), 0.0f) != 0) return false;
        return true;
    }

    private static float getTransitionAnimationScale(ContentResolver contentResolver) {
        return DefaultFailureHandler.getSetting(contentResolver, "transition_animation_scale", "transition_animation_scale");
    }

    private static float getWindowAnimationScale(ContentResolver contentResolver) {
        return DefaultFailureHandler.getSetting(contentResolver, "window_animation_scale", "window_animation_scale");
    }

    private static float getAnimatorDurationScale(ContentResolver contentResolver) {
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            return DefaultFailureHandler.getSetting(contentResolver, "animator_duration_scale", "animator_duration_scale");
        }
        return 0.0f;
    }

    private static float getSetting(ContentResolver contentResolver, String string, String string2) {
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            return DefaultFailureHandler.getGlobalSetting(contentResolver, string);
        }
        return DefaultFailureHandler.getSystemSetting(contentResolver, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isJellyBeanMR1OrHigher() {
        if (Build.VERSION.SDK_INT < 17) return false;
        return true;
    }

    private static float getGlobalSetting(ContentResolver contentResolver, String string) {
        try {
            float f = Settings.Global.getFloat((ContentResolver)contentResolver, (String)string);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    private static float getSystemSetting(ContentResolver contentResolver, String string) {
        try {
            float f = Settings.System.getFloat((ContentResolver)contentResolver, (String)string);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    static {
        AtomicInteger atomicInteger;
        failureCount = atomicInteger = new AtomicInteger(0);
    }

    private static final class AssertionFailedWithCauseError
    extends AssertionFailedError {
        public AssertionFailedWithCauseError(String string, Throwable throwable) {
            super(string);
            this.initCause(throwable);
        }
    }
}

