/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.AsyncTaskPoolMonitor;
import androidx.test.espresso.base.BaseLayerModule$$Lambda$0;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.Default;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.InputManagerEventInjectionStrategy;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.base.NoopRunnableIdleNotifier;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.base.WindowManagerEventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ThreadFactoryBuilder;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BaseLayerModule {
    public ActivityLifecycleMonitor provideLifecycleMonitor() {
        return ActivityLifecycleMonitorRegistry.getInstance();
    }

    @TargetContext
    public Context provideTargetContext() {
        return InstrumentationRegistry.getInstrumentation().getTargetContext();
    }

    public Looper provideMainLooper() {
        return Looper.getMainLooper();
    }

    @CompatAsyncTask
    public IdleNotifier<Runnable> provideCompatAsyncTaskMonitor(ThreadPoolExecutorExtractor object) {
        Optional<ThreadPoolExecutor> optional = ((ThreadPoolExecutorExtractor)object).getCompatAsyncTaskThreadPool();
        if (optional.isPresent()) {
            object = new AsyncTaskPoolMonitor((ThreadPoolExecutor)optional.get());
            return ((AsyncTaskPoolMonitor)object).asIdleNotifier();
        }
        optional = new NoopRunnableIdleNotifier();
        return optional;
    }

    @MainThread
    public Executor provideMainThreadExecutor(Looper object) {
        final Handler handler = new Handler(object);
        object = new Executor(this){

            @Override
            public void execute(Runnable runnable) {
                handler.post(runnable);
            }
        };
        return object;
    }

    public IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> provideDynamicNotifer(IdlingResourceRegistry idlingResourceRegistry) {
        idlingResourceRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
        return idlingResourceRegistry.asIdleNotifier();
    }

    @SdkAsyncTask
    public IdleNotifier<Runnable> provideSdkAsyncTaskMonitor(ThreadPoolExecutorExtractor threadPoolExecutorExtractor) {
        Object object = new AsyncTaskPoolMonitor(threadPoolExecutorExtractor.getAsyncTaskThreadPool());
        return ((AsyncTaskPoolMonitor)object).asIdleNotifier();
    }

    public ActiveRootLister provideActiveRootLister(RootsOracle rootsOracle) {
        return rootsOracle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventInjector provideEventInjector() {
        EventInjectionStrategy eventInjectionStrategy;
        int n = Build.VERSION.SDK_INT;
        if (n >= 16) {
            eventInjectionStrategy = new InputManagerEventInjectionStrategy();
            ((InputManagerEventInjectionStrategy)eventInjectionStrategy).initialize();
            return new EventInjector(eventInjectionStrategy);
        }
        if (n < 7) {
            StringBuilder stringBuilder = new StringBuilder(68);
            RuntimeException runtimeException = new RuntimeException(stringBuilder.append("API Level 6 and below is not supported. You are running: ").append(n).toString());
            throw runtimeException;
        }
        eventInjectionStrategy = new WindowManagerEventInjectionStrategy();
        ((WindowManagerEventInjectionStrategy)eventInjectionStrategy).initialize();
        return new EventInjector(eventInjectionStrategy);
    }

    FailureHandler provideFailureHandler(FailureHandlerHolder failureHandlerHolder) {
        return failureHandlerHolder.get();
    }

    public ListeningExecutorService provideRemoteExecutor() {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        Object object = new ThreadPoolExecutor(0, 5, 10L, timeUnit, linkedBlockingQueue, threadFactoryBuilder.setNameFormat("Espresso Remote #%d").build());
        return MoreExecutors.listeningDecorator((ExecutorService)object);
    }

    @Default
    FailureHandler provideFailureHander(DefaultFailureHandler defaultFailureHandler) {
        return defaultFailureHandler;
    }

    DefaultFailureHandler provideDefaultFailureHander(@TargetContext Context context) {
        Object object = new DefaultFailureHandler(context);
        return object;
    }

    public ControlledLooper provideControlledLooper() {
        return (ControlledLooper)ServiceLoaderWrapper.loadSingleService(ControlledLooper.class, (ServiceLoaderWrapper.Factory)BaseLayerModule$$Lambda$0.$instance);
    }

    static final /* synthetic */ ControlledLooper lambda$provideControlledLooper$0$BaseLayerModule() {
        return ControlledLooper.NO_OP_CONTROLLED_LOOPER;
    }

    public static class FailureHandlerHolder {
        private final AtomicReference<FailureHandler> holder;

        public FailureHandlerHolder(@Default FailureHandler failureHandler) {
            AtomicReference<FailureHandler> atomicReference = new AtomicReference<FailureHandler>(failureHandler);
            this.holder = atomicReference;
        }

        public void update(FailureHandler failureHandler) {
            this.holder.set(failureHandler);
        }

        public FailureHandler get() {
            return this.holder.get();
        }
    }
}

