/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class AsyncTaskPoolMonitor {
    private final AtomicReference<IdleMonitor> monitor;
    private final ThreadPoolExecutor pool;
    private final AtomicInteger activeBarrierChecks;

    AsyncTaskPoolMonitor(ThreadPoolExecutor threadPoolExecutor) {
        Serializable serializable = new Serializable(null);
        this.monitor = serializable;
        super(0);
        this.activeBarrierChecks = serializable;
        this.pool = Preconditions.checkNotNull(threadPoolExecutor);
    }

    IdleNotifier<Runnable> asIdleNotifier() {
        IdleNotifier<Runnable> idleNotifier = new IdleNotifier<Runnable>(){

            @Override
            public boolean isIdleNow() {
                return AsyncTaskPoolMonitor.this.isIdleNow();
            }

            @Override
            public void cancelCallback() {
                AsyncTaskPoolMonitor.this.cancelIdleMonitor();
            }

            @Override
            public void registerNotificationCallback(Runnable runnable) {
                AsyncTaskPoolMonitor.this.notifyWhenIdle(runnable);
            }
        };
        return idleNotifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isIdleNow() {
        if (!this.pool.getQueue().isEmpty()) {
            return false;
        }
        int n = this.pool.getActiveCount();
        int n2 = n != 0 ? (this.monitor.get() == null ? n - this.activeBarrierChecks.get() : n) : n;
        if (n2 != 0) return 0 != 0;
        return 1 != 0;
    }

    void notifyWhenIdle(Runnable runnable) {
        Preconditions.checkNotNull(runnable);
        IdleMonitor idleMonitor = new IdleMonitor(runnable);
        Preconditions.checkState(this.monitor.compareAndSet(null, idleMonitor), "cannot monitor for idle recursively!");
        idleMonitor.monitorForIdle();
    }

    void cancelIdleMonitor() {
        IdleMonitor idleMonitor = ((AsyncTaskPoolMonitor)((Object)idleMonitor)).monitor.getAndSet(null);
        if (idleMonitor != null) {
            idleMonitor.poison();
            return;
        }
    }

    private static class BarrierRestarter {
        private final CyclicBarrier barrier;
        private final AtomicInteger barrierGeneration;

        BarrierRestarter(CyclicBarrier cyclicBarrier, AtomicInteger atomicInteger) {
            this.barrier = cyclicBarrier;
            this.barrierGeneration = atomicInteger;
        }

        synchronized void restart(int n) {
            if (this.barrierGeneration.compareAndSet(n, n + 1)) {
                this.barrier.reset();
                return;
            }
        }
    }

    private class IdleMonitor {
        private final Runnable onIdle;
        private final AtomicInteger barrierGeneration;
        private final CyclicBarrier barrier;
        private volatile boolean poisoned;

        private IdleMonitor(final Runnable runnable) {
            Object object = new AtomicInteger(0);
            this.barrierGeneration = object;
            this.onIdle = Preconditions.checkNotNull(runnable);
            ThreadPoolExecutor threadPoolExecutor = AsyncTaskPoolMonitor.this.pool;
            int n = threadPoolExecutor.getCorePoolSize();
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (AsyncTaskPoolMonitor.this.pool.getQueue().isEmpty()) {
                        AsyncTaskPoolMonitor.this.monitor.compareAndSet(IdleMonitor.this, null);
                        runnable.run();
                        return;
                    }
                    IdleMonitor.this.monitorForIdle();
                }
            };
            this.barrier = object = new CyclicBarrier(n, runnable2);
        }

        private void poison() {
            this.poisoned = true;
            this.barrier.reset();
        }

        private void monitorForIdle() {
            if (this.poisoned) {
                return;
            }
            if (AsyncTaskPoolMonitor.this.isIdleNow()) {
                AsyncTaskPoolMonitor.this.monitor.compareAndSet(this, null);
                this.onIdle.run();
                return;
            }
            int n = AsyncTaskPoolMonitor.this.pool.getCorePoolSize();
            final BarrierRestarter barrierRestarter = new BarrierRestarter(this.barrier, this.barrierGeneration);
            for (int i = 0; i < n; ++i) {
                Object object = AsyncTaskPoolMonitor.this;
                object = ((AsyncTaskPoolMonitor)object).pool;
                Runnable runnable = new Runnable(){

                    /*
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        while (!IdleMonitor.this.poisoned) {
                            AsyncTaskPoolMonitor.this.activeBarrierChecks.incrementAndGet();
                            int n = IdleMonitor.this.barrierGeneration.get();
                            try {
                                IdleMonitor.this.barrier.await();
                                AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                return;
                            }
                            catch (InterruptedException interruptedException) {
                                barrierRestarter.restart(n);
                                continue;
                                catch (BrokenBarrierException brokenBarrierException) {
                                    barrierRestarter.restart(n);
                                }
                                finally {
                                    AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                    continue;
                                }
                            }
                            AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                        }
                    }
                };
                ((ThreadPoolExecutor)object).execute(runnable);
            }
        }
    }
}

