/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewAssertions {
    private static final String TAG = ViewAssertions.class.getSimpleName();

    private ViewAssertions() {
    }

    public static ViewAssertion doesNotExist() {
        DoesNotExistViewAssertion doesNotExistViewAssertion = new DoesNotExistViewAssertion();
        return doesNotExistViewAssertion;
    }

    public static ViewAssertion matches(Matcher<? super View> matcher) {
        MatchesViewAssertion matchesViewAssertion = new MatchesViewAssertion(Preconditions.checkNotNull(matcher));
        return matchesViewAssertion;
    }

    public static ViewAssertion selectedDescendantsMatch(Matcher<View> matcher, Matcher<View> matcher2) {
        SelectedDescendantsMatchViewAssertion selectedDescendantsMatchViewAssertion = new SelectedDescendantsMatchViewAssertion(matcher, matcher2);
        return selectedDescendantsMatchViewAssertion;
    }

    static class SelectedDescendantsMatchViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;
        @RemoteMsgField(order=1)
        private final Matcher<View> matcher;

        @RemoteMsgConstructor
        private SelectedDescendantsMatchViewAssertion(Matcher<View> matcher, Matcher<View> matcher2) {
            this.selector = matcher;
            this.matcher = matcher2;
        }

        @Override
        public void check(View view, NoMatchingViewException predicate) {
            Object[] objectArray;
            Preconditions.checkNotNull(view);
            predicate = new Predicate<View>((SelectedDescendantsMatchViewAssertion)object){
                final /* synthetic */ SelectedDescendantsMatchViewAssertion this$0;
                {
                    this.this$0 = selectedDescendantsMatchViewAssertion;
                }

                @Override
                public boolean apply(View view) {
                    return this.this$0.selector.matches((Object)view);
                }
            };
            predicate = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
            ArrayList<View> arrayList = new ArrayList<View>();
            while (predicate.hasNext()) {
                objectArray = predicate.next();
                if (((SelectedDescendantsMatchViewAssertion)object).matcher.matches((Object)objectArray)) continue;
                arrayList.add((View)objectArray);
            }
            if (arrayList.size() > 0) {
                predicate = Locale.ROOT;
                objectArray = new Object[]{((SelectedDescendantsMatchViewAssertion)object).matcher};
                Object object = String.format((Locale)((Object)predicate), "At least one view did not match the required matcher: %s", objectArray);
                object = HumanReadables.getViewHierarchyErrorMessage(view, arrayList, (String)object, "****DOES NOT MATCH****");
                view = new AssertionFailedError((String)object);
                throw view;
            }
        }

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.selector, this.matcher};
            return String.format(locale, "SelectedDescendantsMatchViewAssertion{selector=%s, matcher=%s}", objectArray);
        }
    }

    static class DoesNotExistViewAssertion
    implements ViewAssertion {
        @RemoteMsgConstructor
        private DoesNotExistViewAssertion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void check(View object, NoMatchingViewException noMatchingViewException) {
            if (object == null) {
                return;
            }
            Object object2 = String.valueOf(HumanReadables.describe((View)object));
            object = "View is present in the hierarchy: ";
            object2 = ((String)object2).length() == 0 ? new String((String)object) : ((String)object).concat((String)object2);
            ViewMatchers.assertThat((String)object2, true, Matchers.is((Object)false));
        }
    }

    static class MatchesViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        final Matcher<? super View> viewMatcher;

        @RemoteMsgConstructor
        private MatchesViewAssertion(Matcher<? super View> matcher) {
            this.viewMatcher = matcher;
        }

        @Override
        public void check(View objectArray, NoMatchingViewException noMatchingViewException) {
            StringDescription stringDescription = new StringDescription();
            stringDescription.appendText("'");
            ((MatchesViewAssertion)((Object)locale)).viewMatcher.describeTo((Description)stringDescription);
            if (noMatchingViewException != null) {
                Locale locale = Locale.ROOT;
                objectArray = new Object[]{noMatchingViewException.getViewMatcherDescription()};
                stringDescription.appendText(String.format(locale, "' check could not be performed because view '%s' was not found.\n", objectArray));
                Log.e((String)TAG, (String)stringDescription.toString());
                throw noMatchingViewException;
            }
            stringDescription.appendText("' doesn't match the selected view.");
            ViewMatchers.assertThat(stringDescription.toString(), objectArray, ((MatchesViewAssertion)((Object)locale)).viewMatcher);
        }

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.viewMatcher};
            return String.format(locale, "MatchesViewAssertion{viewMatcher=%s}", objectArray);
        }
    }
}

