/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Iterator;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class PositionAssertions {
    private static final String TAG = "PositionAssertions";

    private PositionAssertions() {
    }

    public static ViewAssertion isCompletelyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_LEFT_OF);
    }

    public static ViewAssertion isCompletelyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_RIGHT_OF);
    }

    @Deprecated
    public static ViewAssertion isLeftOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyLeftOf(matcher);
    }

    @Deprecated
    public static ViewAssertion isRightOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyRightOf(matcher);
    }

    public static ViewAssertion isPartiallyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_LEFT_OF);
    }

    public static ViewAssertion isPartiallyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_RIGHT_OF);
    }

    public static ViewAssertion isLeftAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.LEFT_ALIGNED);
    }

    public static ViewAssertion isRightAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.RIGHT_ALIGNED);
    }

    public static ViewAssertion isCompletelyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_ABOVE);
    }

    public static ViewAssertion isCompletelyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_BELOW);
    }

    public static ViewAssertion isPartiallyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_ABOVE);
    }

    public static ViewAssertion isPartiallyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_BELOW);
    }

    @Deprecated
    public static ViewAssertion isAbove(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyAbove(matcher);
    }

    @Deprecated
    public static ViewAssertion isBelow(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyBelow(matcher);
    }

    public static ViewAssertion isBottomAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.BOTTOM_ALIGNED);
    }

    public static ViewAssertion isTopAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.TOP_ALIGNED);
    }

    static ViewAssertion relativePositionOf(final Matcher<View> matcher, final Position position) {
        Preconditions.checkNotNull(matcher);
        ViewAssertion viewAssertion = new ViewAssertion(){

            @Override
            public void check(View objectArray, NoMatchingViewException noMatchingViewException) {
                StringDescription stringDescription = new StringDescription();
                if (noMatchingViewException != null) {
                    Locale locale = Locale.ROOT;
                    objectArray = new Object[]{noMatchingViewException.getViewMatcherDescription()};
                    stringDescription.appendText(String.format(locale, "' check could not be performed because view '%s' was not found.\n", objectArray));
                    Log.e((String)PositionAssertions.TAG, (String)stringDescription.toString());
                    throw noMatchingViewException;
                }
                stringDescription.appendText("View:").appendText(HumanReadables.describe((View)objectArray)).appendText(" is not ").appendText(locale.position.toString()).appendText(" view ").appendText(locale.matcher.toString());
                ViewMatchers.assertThat(stringDescription.toString(), PositionAssertions.isRelativePosition((View)objectArray, PositionAssertions.findView((Matcher<View>)locale.matcher, (View)PositionAssertions.getTopViewGroup((View)objectArray)), locale.position), Matchers.is((Object)true));
            }
        };
        return viewAssertion;
    }

    static View findView(final Matcher<View> matcher, View view) {
        Predicate<View> predicate;
        block4: {
            Iterator<View> iterator;
            block3: {
                Preconditions.checkNotNull(matcher);
                Preconditions.checkNotNull(view);
                predicate = new Predicate<View>(){

                    @Override
                    public boolean apply(View view) {
                        return matcher.matches((Object)view);
                    }
                };
                iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
                predicate = null;
                while (iterator.hasNext()) {
                    if (predicate == null) {
                        predicate = iterator.next();
                        continue;
                    }
                    break block3;
                }
                if (predicate == null) {
                    predicate = new Predicate<View>();
                    throw ((NoMatchingViewException.Builder)((Object)predicate)).withViewMatcher(matcher).withRootView(view).build();
                }
                break block4;
            }
            AmbiguousViewMatcherException.Builder builder = new AmbiguousViewMatcherException.Builder();
            throw builder.withRootView(view).withViewMatcher(matcher).withView1((View)predicate).withView2(iterator.next()).withOtherAmbiguousViews(Iterators.toArray(iterator, View.class)).build();
        }
        return predicate;
    }

    private static ViewGroup getTopViewGroup(View view) {
        ViewGroup viewGroup = null;
        for (view = view.getParent(); view != null; view = view.getParent()) {
            if (!(view instanceof ViewGroup)) continue;
            viewGroup = (ViewGroup)view;
        }
        return viewGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isRelativePosition(View view, View view2, Position position) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        view.getLocationOnScreen(nArray);
        view2.getLocationOnScreen(nArray2);
        switch (3.$SwitchMap$androidx$test$espresso$assertion$PositionAssertions$Position[position.ordinal()]) {
            case 12: {
                if (nArray[1] + view.getHeight() != nArray2[1] + view2.getHeight()) return false;
                return true;
            }
            case 11: {
                if (nArray[1] != nArray2[1]) return false;
                return true;
            }
            case 10: {
                if (nArray[0] + view.getWidth() != nArray2[0] + view2.getWidth()) return false;
                return true;
            }
            case 9: {
                if (nArray[0] != nArray2[0]) return false;
                return true;
            }
            case 8: {
                if (nArray2[1] >= nArray[1]) return false;
                if (nArray[1] >= nArray2[1] + view2.getHeight()) return false;
                return true;
            }
            case 7: {
                if (nArray[1] >= nArray2[1]) return false;
                if (nArray2[1] >= nArray[1] + view.getHeight()) return false;
                return true;
            }
            case 6: {
                if (nArray2[0] >= nArray[0]) return false;
                if (nArray[0] >= nArray2[0] + view2.getWidth()) return false;
                return true;
            }
            case 5: {
                if (nArray[0] >= nArray2[0]) return false;
                if (nArray2[0] >= nArray[0] + view.getWidth()) return false;
                return true;
            }
            case 4: {
                if (nArray2[1] + view2.getHeight() > nArray[1]) return false;
                return true;
            }
            case 3: {
                if (nArray[1] + view.getHeight() > nArray2[1]) return false;
                return true;
            }
            case 2: {
                if (nArray2[0] + view2.getWidth() > nArray[0]) return false;
                return true;
            }
            case 1: {
                if (nArray[0] + view.getWidth() > nArray2[0]) return false;
                return true;
            }
        }
        return false;
    }

    static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position COMPLETELY_LEFT_OF;
        public static final /* enum */ Position COMPLETELY_RIGHT_OF;
        public static final /* enum */ Position COMPLETELY_ABOVE;
        public static final /* enum */ Position COMPLETELY_BELOW;
        public static final /* enum */ Position PARTIALLY_LEFT_OF;
        public static final /* enum */ Position PARTIALLY_RIGHT_OF;
        public static final /* enum */ Position PARTIALLY_ABOVE;
        public static final /* enum */ Position PARTIALLY_BELOW;
        public static final /* enum */ Position LEFT_ALIGNED;
        public static final /* enum */ Position RIGHT_ALIGNED;
        public static final /* enum */ Position TOP_ALIGNED;
        public static final /* enum */ Position BOTTOM_ALIGNED;
        private final String positionValue;
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        private Position(String string2) {
            this.positionValue = string2;
        }

        public String toString() {
            return this.positionValue;
        }

        static {
            Position[] positionArray = new Position("completely left of");
            COMPLETELY_LEFT_OF = positionArray;
            positionArray = new Position("completely right of");
            COMPLETELY_RIGHT_OF = positionArray;
            positionArray = new Position("completely above");
            COMPLETELY_ABOVE = positionArray;
            positionArray = new Position("completely below");
            COMPLETELY_BELOW = positionArray;
            positionArray = new Position("partially left of");
            PARTIALLY_LEFT_OF = positionArray;
            positionArray = new Position("partially right of");
            PARTIALLY_RIGHT_OF = positionArray;
            positionArray = new Position("partially above");
            PARTIALLY_ABOVE = positionArray;
            positionArray = new Position("partially below");
            PARTIALLY_BELOW = positionArray;
            positionArray = new Position("aligned left with");
            LEFT_ALIGNED = positionArray;
            positionArray = new Position("aligned right with");
            RIGHT_ALIGNED = positionArray;
            positionArray = new Position("aligned top with");
            TOP_ALIGNED = positionArray;
            positionArray = new Position("aligned bottom with");
            BOTTOM_ALIGNED = positionArray;
            Position position = RIGHT_ALIGNED;
            positionArray = new Position[]{COMPLETELY_LEFT_OF, COMPLETELY_RIGHT_OF, COMPLETELY_ABOVE, COMPLETELY_BELOW, PARTIALLY_LEFT_OF, PARTIALLY_RIGHT_OF, PARTIALLY_ABOVE, PARTIALLY_BELOW, LEFT_ALIGNED, position, TOP_ALIGNED, BOTTOM_ALIGNED};
            $VALUES = positionArray;
        }
    }
}

