/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.graphics.Rect;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.LayoutMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.LinkedList;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class LayoutAssertions {
    private LayoutAssertions() {
    }

    public static ViewAssertion noEllipsizedText() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(TextView.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasEllipsizedText()));
    }

    public static ViewAssertion noMultilineButtons() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(Button.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasMultilineText()));
    }

    public static ViewAssertion noOverlaps(Matcher<View> matcher) {
        NoOverlapsViewAssertion noOverlapsViewAssertion = new NoOverlapsViewAssertion(Preconditions.checkNotNull(matcher));
        return noOverlapsViewAssertion;
    }

    public static ViewAssertion noOverlaps() {
        return LayoutAssertions.noOverlaps((Matcher<View>)Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), (Matcher)Matchers.anyOf(ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.isAssignableFrom(ImageView.class))));
    }

    private static Rect getRect(View view) {
        int[] nArray = new int[]{0, 0};
        view.getLocationOnScreen(nArray);
        Rect rect = new Rect(nArray[0], nArray[1], nArray[0] + view.getWidth() + -1, nArray[1] + view.getHeight() + -1);
        return rect;
    }

    static class NoOverlapsViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;

        @RemoteMsgConstructor
        private NoOverlapsViewAssertion(Matcher<View> matcher) {
            this.selector = matcher;
        }

        @Override
        public void check(View object, NoMatchingViewException serializable) {
            View view = new Predicate<View>((NoOverlapsViewAssertion)object2){
                final /* synthetic */ NoOverlapsViewAssertion this$0;
                {
                    this.this$0 = noOverlapsViewAssertion;
                }

                @Override
                public boolean apply(View view) {
                    return this.this$0.selector.matches((Object)view);
                }
            };
            if (serializable != null) {
                throw serializable;
            }
            Object object2 = Iterables.filter(TreeIterables.breadthFirstViewTraversal((View)object), view).iterator();
            object = new LinkedList();
            serializable = new StringBuilder();
            while (object2.hasNext()) {
                view = (View)object2.next();
                Object object3 = LayoutAssertions.getRect(view);
                if (object3.isEmpty() || view instanceof TextView && ((TextView)view).getText().length() == 0) continue;
                Object[] objectArray = object.iterator();
                while (objectArray.hasNext()) {
                    View view2 = (View)objectArray.next();
                    if (view instanceof ImageView && view2 instanceof ImageView || !Rect.intersects((Rect)object3, (Rect)LayoutAssertions.getRect(view2))) continue;
                    if (((StringBuilder)serializable).length() > 0) {
                        ((StringBuilder)serializable).append(",\n\n");
                    }
                    object3 = Locale.ROOT;
                    objectArray = new Object[]{HumanReadables.describe(view), HumanReadables.describe(view2)};
                    ((StringBuilder)serializable).append(String.format((Locale)object3, "%s overlaps\n%s", objectArray));
                    break;
                }
                object.add(view);
            }
            if (((StringBuilder)serializable).length() > 0) {
                object2 = new AssertionFailedError(((StringBuilder)serializable).toString());
                throw object2;
            }
        }

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.selector};
            return String.format(locale, "NoOverlapsViewAssertion{selector=%s}", objectArray);
        }
    }
}

