/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.CloseKeyboardAction;
import androidx.test.espresso.action.EditorAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.GeneralSwipeAction;
import androidx.test.espresso.action.KeyEventAction;
import androidx.test.espresso.action.OpenLinkAction;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.PressBackAction;
import androidx.test.espresso.action.RepeatActionUntilViewState;
import androidx.test.espresso.action.ReplaceTextAction;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.action.Swipe;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.TypeTextAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ViewActions {
    private static final float EDGE_FUZZ_FACTOR = 0.083f;
    private static Set<Pair<String, ViewAssertion>> globalAssertions;

    private ViewActions() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void addGlobalAssertion(String string, ViewAssertion viewAssertion) {
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(viewAssertion);
        Pair pair = new Pair((Object)string, (Object)viewAssertion);
        boolean bl = !globalAssertions.contains(pair);
        Preconditions.checkArgument(bl, "ViewAssertion with name %s is already in the global assertions!", string);
        globalAssertions.add((Pair<String, ViewAssertion>)pair);
    }

    public static void removeGlobalAssertion(ViewAssertion viewAssertion) {
        Iterator<Pair<String, ViewAssertion>> iterator = globalAssertions.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Pair<String, ViewAssertion> pair = iterator.next();
            if (viewAssertion == null || !viewAssertion.equals(pair.second)) continue;
            if (bl || globalAssertions.remove(pair)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        Preconditions.checkArgument(bl, "ViewAssertion was not in global assertions!");
    }

    public static void clearGlobalAssertions() {
        globalAssertions.clear();
    }

    public static ViewAction actionWithAssertions(final ViewAction viewAction) {
        if (globalAssertions.isEmpty()) {
            return viewAction;
        }
        ViewAction viewAction2 = new ViewAction(){

            @Override
            public String getDescription() {
                StringBuilder stringBuilder = new StringBuilder("Running view assertions[");
                Iterator iterator = globalAssertions.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)((Pair)iterator.next()).first);
                    stringBuilder.append(", ");
                }
                stringBuilder.append("] and then running: ");
                stringBuilder.append(viewAction.getDescription());
                return stringBuilder.toString();
            }

            @Override
            public Matcher<View> getConstraints() {
                return viewAction.getConstraints();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void perform(UiController uiController, View view) {
                Iterator iterator = globalAssertions.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        viewAction.perform(uiController, view);
                        return;
                    }
                    Pair pair = (Pair)iterator.next();
                    String string = String.valueOf((String)pair.first);
                    String string2 = "Asserting ";
                    string = string.length() == 0 ? new String(string2) : string2.concat(string);
                    Log.i((String)"ViewAssertion", (String)string);
                    ((ViewAssertion)pair.second).check(view, null);
                }
            }
        };
        return viewAction2;
    }

    public static ViewAction clearText() {
        ReplaceTextAction replaceTextAction = new ReplaceTextAction("");
        return ViewActions.actionWithAssertions(replaceTextAction);
    }

    public static ViewAction click(int n, int n2) {
        if (Build.VERSION.SDK_INT < 14) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            throw unsupportedOperationException;
        }
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, n, n2);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction click() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction click(ViewAction viewAction) {
        Preconditions.checkNotNull(viewAction);
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1, viewAction);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction swipeLeft() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_RIGHT, -0.083f, 0.0f), GeneralLocation.CENTER_LEFT, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeRight() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_LEFT, 0.083f, 0.0f), GeneralLocation.CENTER_RIGHT, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeDown() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.TOP_CENTER, 0.0f, 0.083f), GeneralLocation.BOTTOM_CENTER, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeUp() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.BOTTOM_CENTER, 0.0f, -0.083f), GeneralLocation.TOP_CENTER, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction closeSoftKeyboard() {
        CloseKeyboardAction closeKeyboardAction = new CloseKeyboardAction();
        return ViewActions.actionWithAssertions(closeKeyboardAction);
    }

    public static ViewAction pressImeActionButton() {
        EditorAction editorAction = new EditorAction();
        return ViewActions.actionWithAssertions(editorAction);
    }

    public static ViewAction pressBack() {
        PressBackAction pressBackAction = new PressBackAction(true);
        return ViewActions.actionWithAssertions(pressBackAction);
    }

    public static ViewAction pressBackUnconditionally() {
        PressBackAction pressBackAction = new PressBackAction(false);
        return ViewActions.actionWithAssertions(pressBackAction);
    }

    public static ViewAction pressMenuKey() {
        return ViewActions.pressKey(82);
    }

    public static ViewAction pressKey(int n) {
        EspressoKey.Builder builder = new EspressoKey.Builder();
        KeyEventAction keyEventAction = new KeyEventAction(builder.withKeyCode(n).build());
        return ViewActions.actionWithAssertions(keyEventAction);
    }

    public static ViewAction pressKey(EspressoKey espressoKey) {
        KeyEventAction keyEventAction = new KeyEventAction(espressoKey);
        return ViewActions.actionWithAssertions(keyEventAction);
    }

    public static ViewAction doubleClick() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.DOUBLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction longClick() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.LONG, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction scrollTo() {
        ScrollToAction scrollToAction = new ScrollToAction();
        return ViewActions.actionWithAssertions(scrollToAction);
    }

    public static ViewAction typeTextIntoFocusedView(String string) {
        TypeTextAction typeTextAction = new TypeTextAction(string, false);
        return ViewActions.actionWithAssertions(typeTextAction);
    }

    public static ViewAction typeText(String string) {
        TypeTextAction typeTextAction = new TypeTextAction(string);
        return ViewActions.actionWithAssertions(typeTextAction);
    }

    public static ViewAction replaceText(String string) {
        ReplaceTextAction replaceTextAction = new ReplaceTextAction(string);
        return ViewActions.actionWithAssertions(replaceTextAction);
    }

    public static ViewAction openLinkWithText(String string) {
        return ViewActions.openLinkWithText((Matcher<String>)Matchers.is((Object)string));
    }

    public static ViewAction openLinkWithText(Matcher<String> matcher) {
        return ViewActions.openLink(matcher, (Matcher<Uri>)Matchers.any(Uri.class));
    }

    public static ViewAction openLinkWithUri(String string) {
        return ViewActions.openLinkWithUri((Matcher<Uri>)Matchers.is((Object)Uri.parse((String)string)));
    }

    public static ViewAction openLinkWithUri(Matcher<Uri> matcher) {
        return ViewActions.openLink((Matcher<String>)Matchers.any(String.class), matcher);
    }

    public static ViewAction openLink(Matcher<String> matcher, Matcher<Uri> matcher2) {
        Preconditions.checkNotNull(matcher);
        Preconditions.checkNotNull(matcher2);
        OpenLinkAction openLinkAction = new OpenLinkAction(matcher, matcher2);
        return ViewActions.actionWithAssertions(openLinkAction);
    }

    public static ViewAction repeatedlyUntil(ViewAction viewAction, Matcher<View> matcher, int n) {
        Preconditions.checkNotNull(viewAction);
        Preconditions.checkNotNull(matcher);
        RepeatActionUntilViewState repeatActionUntilViewState = new RepeatActionUntilViewState(viewAction, matcher, n);
        return ViewActions.actionWithAssertions(repeatActionUntilViewState);
    }

    static {
        CopyOnWriteArraySet<Pair<String, ViewAssertion>> copyOnWriteArraySet = new CopyOnWriteArraySet<Pair<String, ViewAssertion>>();
        globalAssertions = copyOnWriteArraySet;
    }
}

