/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.SearchView;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TypeTextAction
implements ViewAction {
    private static final String TAG = TypeTextAction.class.getSimpleName();
    @RemoteMsgField(order=0)
    final String stringToBeTyped;
    @RemoteMsgField(order=1)
    final boolean tapToFocus;
    final GeneralClickAction clickAction;

    public TypeTextAction(String string) {
        this(string, true, TypeTextAction.defaultClickAction());
    }

    @RemoteMsgConstructor
    public TypeTextAction(String string, boolean bl) {
        this(string, bl, null);
    }

    public TypeTextAction(String string, boolean bl, GeneralClickAction generalClickAction) {
        Preconditions.checkNotNull(string);
        this.stringToBeTyped = string;
        this.tapToFocus = bl;
        this.clickAction = generalClickAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Matcher<View> getConstraints() {
        Matcher matcher = new Matcher[]{ViewMatchers.isDisplayed()};
        matcher = Matchers.allOf((Matcher[])matcher);
        TypeTextAction typeTextAction = !typeTextAction.tapToFocus ? Matchers.allOf((Matcher)matcher, ViewMatchers.hasFocus()) : matcher;
        if (Build.VERSION.SDK_INT < 11) {
            return Matchers.allOf((Matcher)typeTextAction, ViewMatchers.supportsInputMethods());
        }
        return Matchers.allOf((Matcher)typeTextAction, (Matcher)Matchers.anyOf(ViewMatchers.supportsInputMethods(), ViewMatchers.isAssignableFrom(SearchView.class)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController object, View view) {
        Object object2;
        if (this.stringToBeTyped.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return;
        }
        if (this.tapToFocus) {
            if (this.clickAction == null) {
                TypeTextAction.defaultClickAction().perform((UiController)object, view);
            } else {
                this.clickAction.perform((UiController)object, view);
            }
            object.loopMainThreadUntilIdle();
        }
        try {
            boolean bl = object.injectString(this.stringToBeTyped);
            if (bl) {
                return;
            }
            Object object3 = TAG;
            object = "Failed to type text: ";
            object2 = String.valueOf(this.stringToBeTyped);
            int n = ((String)object2).length();
            object = n == 0 ? (object2 = new String((String)object)) : ((String)object).concat((String)object2);
            Log.e((String)object3, (String)object);
            object = new PerformException.Builder();
            object3 = ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view));
            object = "Failed to type text: ";
            String string = String.valueOf(this.stringToBeTyped);
            int n2 = string.length();
            if (n2 == 0) {
                string = new String((String)object);
                object = string;
            } else {
                object = ((String)object).concat(string);
            }
            object2 = new RuntimeException((String)object);
            throw ((PerformException.Builder)object3).withCause((Throwable)object2).build();
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            object2 = TAG;
            object = String.valueOf(this.stringToBeTyped);
            String string = "Failed to type text: ";
            object = ((String)object).length() == 0 ? new String(string) : string.concat((String)object);
            Log.e((String)object2, (String)object);
            object = new PerformException.Builder();
            throw ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.stringToBeTyped};
        return String.format(locale, "type text(%s)", objectArray);
    }

    private static GeneralClickAction defaultClickAction() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return generalClickAction;
    }
}

