/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.ArrayList;

public abstract class Swipe
extends Enum<Swipe>
implements Swiper {
    public static final /* enum */ Swipe FAST;
    public static final /* enum */ Swipe SLOW;
    private static final String TAG;
    private static final int SWIPE_EVENT_COUNT = 10;
    private static final int SWIPE_FAST_DURATION_MS = 150;
    private static final int SWIPE_SLOW_DURATION_MS = 1500;
    private static final /* synthetic */ Swipe[] $VALUES;

    public static Swipe[] values() {
        return (Swipe[])$VALUES.clone();
    }

    public static Swipe valueOf(String string) {
        return Enum.valueOf(Swipe.class, string);
    }

    private static float[][] interpolate(float[] fArray, float[] fArray2, int n) {
        Preconditions.checkElementIndex(1, fArray.length);
        Preconditions.checkElementIndex(1, fArray2.length);
        float[][] fArray3 = new float[n][2];
        for (int i = 1; i < n + 1; ++i) {
            fArray3[i + -1][0] = fArray[0] + (fArray2[0] - fArray[0]) * (float)i / ((float)n + 2.0f);
            fArray3[i + -1][1] = fArray[1] + (fArray2[1] - fArray[1]) * (float)i / ((float)n + 2.0f);
        }
        return fArray3;
    }

    private static Swiper.Status sendLinearSwipe(UiController object, float[] object2, float[] fArray, float[] object3, int n) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(object3);
        float[][] fArray2 = Swipe.interpolate((float[])object2, fArray, 10);
        ArrayList<MotionEvent> arrayList = new ArrayList<MotionEvent>();
        object3 = MotionEvents.obtainDownEvent((float[])object2, object3);
        arrayList.add((MotionEvent)object3);
        int n2 = n / fArray2.length;
        long l = n2;
        long l2 = object3.getDownTime();
        n = fArray2.length;
        long l3 = l2;
        for (n2 = 0; n2 < n; ++n2) {
            float[] fArray3 = fArray2[n2];
            long l4 = l3 + l;
            arrayList.add(MotionEvents.obtainMovement(object3.getDownTime(), l4, fArray3));
            l3 = l4;
            continue;
        }
        long l5 = l3 + l;
        try {
            long l6 = object3.getDownTime();
            arrayList.add(MotionEvent.obtain((long)l6, (long)l5, (int)1, (float)fArray[0], (float)fArray[1], (int)0));
            object.injectMotionEventSequence(arrayList);
            object = arrayList.iterator();
        }
        catch (Exception exception) {
            try {
                object = Swiper.Status.FAILURE;
                object2 = arrayList.iterator();
            }
            catch (Throwable throwable) {
                object2 = arrayList.iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        throw throwable;
                    }
                    ((MotionEvent)object2.next()).recycle();
                }
            }
            while (object2.hasNext()) {
                ((MotionEvent)object2.next()).recycle();
            }
            return object;
        }
        while (object.hasNext()) {
            ((MotionEvent)object.next()).recycle();
        }
        return Swiper.Status.SUCCESS;
    }

    static {
        Swipe swipe;
        FAST = swipe = new Swipe(){

            @Override
            public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
                return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 150);
            }
        };
        SLOW = swipe = new Swipe(){

            @Override
            public Swiper.Status sendSwipe(UiController uiController, float[] fArray, float[] fArray2, float[] fArray3) {
                return Swipe.sendLinearSwipe(uiController, fArray, fArray2, fArray3, 1500);
            }
        };
        swipe = new Swipe[]{FAST, SLOW};
        $VALUES = swipe;
        TAG = Swipe.class.getSimpleName();
    }
}

