/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class RepeatActionUntilViewState
implements ViewAction {
    private final ViewAction mAction;
    private final Matcher<View> mDesiredStateMatcher;
    private final int mMaxAttempts;

    /*
     * Enabled aggressive block sorting
     */
    protected RepeatActionUntilViewState(ViewAction viewAction, Matcher<View> matcher, int n) {
        Preconditions.checkNotNull(viewAction);
        Preconditions.checkNotNull(matcher);
        boolean bl = n > 1;
        Preconditions.checkState(bl, "maxAttempts should be greater than 1");
        this.mAction = viewAction;
        this.mDesiredStateMatcher = matcher;
        this.mMaxAttempts = n;
    }

    @Override
    public Matcher<View> getConstraints() {
        return this.mAction.getConstraints();
    }

    @Override
    public String getDescription() {
        StringDescription stringDescription = new StringDescription();
        this.mDesiredStateMatcher.describeTo((Description)stringDescription);
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.mAction.getDescription(), stringDescription};
        return String.format(locale, "%s until: %s", objectArray);
    }

    @Override
    public void perform(UiController object, View object2) {
        int n;
        for (n = 1; !this.mDesiredStateMatcher.matches(object2) && n <= this.mMaxAttempts; ++n) {
            this.mAction.perform((UiController)object, (View)object2);
            object.loopMainThreadUntilIdle();
        }
        if (n > this.mMaxAttempts) {
            object = new PerformException.Builder();
            Object object3 = this.getDescription();
            object = ((PerformException.Builder)object).withActionDescription((String)object3);
            object2 = HumanReadables.describe(object2);
            object = ((PerformException.Builder)object).withViewDescription((String)object2);
            object3 = Locale.ROOT;
            Object[] objectArray = new Object[]{this.mMaxAttempts};
            object2 = new RuntimeException(String.format((Locale)object3, "Failed to achieve view state after %d attempts", objectArray));
            throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
        }
    }
}

