/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Locale;

public final class MotionEvents {
    private static final String TAG = MotionEvents.class.getSimpleName();
    static final int MAX_CLICK_ATTEMPTS = 3;

    private MotionEvents() {
    }

    public static DownResultHolder sendDown(UiController uiController, float[] fArray, float[] fArray2) {
        return MotionEvents.sendDown(uiController, fArray, fArray2, 0, 1);
    }

    public static MotionEvent obtainDownEvent(float[] fArray, float[] fArray2, int n, int n2) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkNotNull(fArray2);
        long l = SystemClock.uptimeMillis();
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.downPressGingerBread(l, fArray, fArray2);
        }
        return MotionEvents.downPressICS(l, fArray, fArray2, n, n2);
    }

    public static MotionEvent obtainDownEvent(float[] fArray, float[] fArray2) {
        return MotionEvents.obtainDownEvent(fArray, fArray2, 0, 1);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DownResultHolder sendDown(UiController object, float[] object2, float[] objectArray, int n, int n2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Preconditions.checkNotNull(objectArray);
        int n3 = 0;
        while (true) {
            long l;
            long l2;
            void var4_6;
            void var3_5;
            if (n3 >= 3) {
                object = new PerformException.Builder();
                object2 = Locale.ROOT;
                Object[] objectArray2 = new Object[]{3};
                throw ((PerformException.Builder)object).withActionDescription(String.format((Locale)object2, "click (after %s attempts)", objectArray2)).withViewDescription("unknown").build();
            }
            MotionEvent motionEvent = MotionEvents.obtainDownEvent((float[])object2, objectArray, (int)var3_5, (int)var4_6);
            long l3 = motionEvent.getDownTime();
            boolean bl = ViewConfiguration.getTapTimeout() / 2;
            long l4 = l3 + (long)bl;
            boolean bl2 = object.injectMotionEvent(motionEvent);
            while ((l2 = l4 - (l = SystemClock.uptimeMillis())) > 10L) {
                object.loopMainThreadForAtLeast(l2 / 4L);
            }
            l = SystemClock.uptimeMillis();
            if (l > l3 + (long)(bl = ViewConfiguration.getLongPressTimeout())) {
                Log.w((String)TAG, (String)"Overslept and turned a tap into a long press");
                bl = true;
            } else {
                bl = false;
            }
            if (bl2) return new DownResultHolder(motionEvent, bl);
            motionEvent.recycle();
            ++n3;
            continue;
            break;
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            object2 = new PerformException.Builder();
            throw ((PerformException.Builder)object2).withActionDescription("Send down motion event").withViewDescription("unknown").withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }

    public static boolean sendUp(UiController uiController, MotionEvent motionEvent) {
        float[] fArray = new float[]{motionEvent.getX(), motionEvent.getY()};
        return MotionEvents.sendUp(uiController, motionEvent, fArray);
    }

    public static MotionEvent obtainUpEvent(MotionEvent motionEvent, float[] fArray) {
        Preconditions.checkNotNull(motionEvent);
        Preconditions.checkNotNull(fArray);
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.upPressGingerBread(motionEvent, fArray);
        }
        return MotionEvents.upPressICS(motionEvent, fArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static boolean sendUp(UiController var0, MotionEvent var1_10, float[] var2_11) {
        block13: {
            block14: {
                Preconditions.checkNotNull(var0);
                Preconditions.checkNotNull(var1_10 /* !! */ );
                Preconditions.checkNotNull(var2_11 /* !! */ );
                var2_11 /* !! */  = (float[])MotionEvents.obtainUpEvent(var1_10 /* !! */ , var2_11 /* !! */ );
                var0_1 = var0.injectMotionEvent((MotionEvent)var2_11 /* !! */ );
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10 /* !! */ };
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of up event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 /* !! */  == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 /* !! */  = (MotionEvent)var2_11 /* !! */ ;
                    ** GOTO lbl36
                }
                var2_11 /* !! */ .recycle();
            }
            return false;
        }
        if (var2_11 /* !! */  != null) {
            var2_11 /* !! */ .recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 /* !! */  = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10 /* !! */ };
                throw var3_13.withActionDescription(String.format(var4_15, "inject up event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 /* !! */  = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 /* !! */  != null) {
                    var1_10 /* !! */ .recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 /* !! */  = (MotionEvent)var2_11 /* !! */ ;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void sendCancel(UiController var0, MotionEvent var1_10) {
        block13: {
            block14: {
                Preconditions.checkNotNull(var0);
                Preconditions.checkNotNull(var1_10);
                var3_11 = var1_10.getDownTime();
                var5_12 = SystemClock.uptimeMillis();
                var2_13 = MotionEvent.obtain((long)var3_11, (long)var5_12, (int)3, (float)var1_10.getX(), (float)var1_10.getY(), (int)0);
                var0_1 = var0.injectMotionEvent(var2_13);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var7_14 = Locale.ROOT;
                    var8_16 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var7_14, "Injection of cancel event failed (corresponding down event: %s)", var8_16));
                    if (var2_13 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_13;
                    ** GOTO lbl38
                }
                var2_13.recycle();
                return;
            }
            return;
        }
        if (var2_13 != null) {
            var2_13.recycle();
            return;
        }
        return;
        catch (InjectEventSecurityException var0_3) {
            var2_13 = null;
lbl30:
            // 2 sources

            while (true) {
                var7_15 = new PerformException.Builder();
                var8_17 = Locale.ROOT;
                var9_18 = new Object[]{var1_10};
                throw var7_15.withActionDescription(String.format(var8_17, "inject cancel event (corresponding down event: %s)", var9_18)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl38:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_13;
                ** continue;
            }
        }
    }

    public static MotionEvent obtainMovement(long l, float[] fArray) {
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)2, (float)fArray[0], (float)fArray[1], (int)0);
    }

    public static MotionEvent obtainMovement(long l, long l2, float[] fArray) {
        return MotionEvent.obtain((long)l, (long)l2, (int)2, (float)fArray[0], (float)fArray[1], (int)0);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static boolean sendMovement(UiController var0, MotionEvent var1_10, float[] var2_11) {
        block13: {
            block14: {
                Preconditions.checkNotNull(var0);
                Preconditions.checkNotNull(var1_10 /* !! */ );
                Preconditions.checkNotNull(var2_11 /* !! */ );
                var2_11 /* !! */  = (float[])MotionEvents.obtainMovement(var1_10 /* !! */ .getDownTime(), var2_11 /* !! */ );
                var0_1 = var0.injectMotionEvent((MotionEvent)var2_11 /* !! */ );
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10 /* !! */ };
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of motion event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 /* !! */  == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 /* !! */  = (MotionEvent)var2_11 /* !! */ ;
                    ** GOTO lbl36
                }
                var2_11 /* !! */ .recycle();
            }
            return false;
        }
        if (var2_11 /* !! */  != null) {
            var2_11 /* !! */ .recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 /* !! */  = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10 /* !! */ };
                throw var3_13.withActionDescription(String.format(var4_15, "inject motion event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 /* !! */  = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 /* !! */  != null) {
                    var1_10 /* !! */ .recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 /* !! */  = (MotionEvent)var2_11 /* !! */ ;
                ** continue;
            }
        }
    }

    private static MotionEvent downPressGingerBread(long l, float[] fArray, float[] fArray2) {
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)0, (float)fArray[0], (float)fArray[1], (float)0.0f, (float)1.0f, (int)0, (float)fArray2[0], (float)fArray2[1], (int)0, (int)0);
    }

    private static MotionEvent downPressICS(long l, float[] fArray, float[] fArray2, int n, int n2) {
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerCoords();
        pointerCoordsArray[0] = pointerPropertiesArray;
        pointerPropertiesArray = MotionEvents.getPointerProperties(n);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = fArray[0];
        pointerCoordsArray[0].y = fArray[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)0, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)n2, (float)fArray2[0], (float)fArray2[1], (int)0, (int)0, (int)n, (int)0);
    }

    private static MotionEvent upPressGingerBread(MotionEvent motionEvent, float[] fArray) {
        return MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (float)fArray[0], (float)fArray[1], (int)0);
    }

    private static MotionEvent upPressICS(MotionEvent motionEvent, float[] fArray) {
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[]{pointerCoords};
        int n = motionEvent.getSource();
        MotionEvent.PointerProperties[] pointerPropertiesArray = MotionEvents.getPointerProperties(n);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = fArray[0];
        pointerCoordsArray[0].y = fArray[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)motionEvent.getButtonState(), (float)motionEvent.getXPrecision(), (float)motionEvent.getYPrecision(), (int)0, (int)0, (int)motionEvent.getSource(), (int)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MotionEvent.PointerProperties[] getPointerProperties(int n) {
        MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[]{pointerProperties};
        pointerPropertiesArray[0].clear();
        pointerPropertiesArray[0].id = 0;
        switch (n) {
            default: {
                pointerPropertiesArray[0].toolType = 0;
                return pointerPropertiesArray;
            }
            case 16386: {
                pointerPropertiesArray[0].toolType = 2;
                return pointerPropertiesArray;
            }
            case 8194: {
                pointerPropertiesArray[0].toolType = 3;
                return pointerPropertiesArray;
            }
            case 4098: 
        }
        pointerPropertiesArray[0].toolType = 1;
        return pointerPropertiesArray;
    }

    public static class DownResultHolder {
        public final MotionEvent down;
        public final boolean longPress;

        DownResultHolder(MotionEvent motionEvent, boolean bl) {
            this.down = motionEvent;
            this.longPress = bl;
        }
    }
}

