/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.ActivityLifecycles;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Locale;
import org.hamcrest.Matcher;

class KeyEventActionBase
implements ViewAction {
    private static final String TAG = "KeyEventActionBase";
    public static final int BACK_ACTIVITY_TRANSITION_MILLIS_DELAY = 150;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_ATTEMPTS = 4;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_MILLIS_DELAY = 150;
    final EspressoKey espressoKey;

    KeyEventActionBase(EspressoKey espressoKey) {
        this.espressoKey = Preconditions.checkNotNull(espressoKey);
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayed();
    }

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.espressoKey};
        return String.format(locale, "send %s key event", objectArray);
    }

    @Override
    public void perform(UiController uiController, View view) {
        block5: {
            Object object;
            try {
                boolean bl = this.sendKeyEvent(uiController);
                if (bl) break block5;
            }
            catch (InjectEventSecurityException injectEventSecurityException) {
                object = String.valueOf(this.espressoKey);
                String string = String.valueOf(object);
                int n = string.length();
                StringBuilder stringBuilder = new StringBuilder(n + 36);
                Log.e((String)TAG, (String)stringBuilder.append("Failed to inject espressoKey event: ").append((String)object).toString());
                object = new PerformException.Builder();
                throw ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)injectEventSecurityException)).build();
            }
            Object object2 = TAG;
            object = String.valueOf(this.espressoKey);
            int n = String.valueOf(object).length();
            n += 36;
            StringBuilder stringBuilder = new StringBuilder(n);
            Log.e((String)object2, (String)stringBuilder.append("Failed to inject espressoKey event: ").append((String)object).toString());
            object2 = new PerformException.Builder();
            object2 = ((PerformException.Builder)object2).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view));
            String string = String.valueOf(this.espressoKey);
            int n2 = String.valueOf(string).length();
            n2 += 35;
            StringBuilder stringBuilder2 = new StringBuilder(n2);
            object = new RuntimeException(stringBuilder2.append("Failed to inject espressoKey event ").append(string).toString());
            throw ((PerformException.Builder)object2).withCause((Throwable)object).build();
        }
    }

    private boolean sendKeyEvent(UiController uiController) throws InjectEventSecurityException {
        int n;
        long l = SystemClock.uptimeMillis();
        boolean bl = false;
        for (n = 0; !bl && n < 4; ++n) {
            KeyEvent keyEvent = new KeyEvent(l, l, 0, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState());
            bl = uiController.injectKeyEvent(keyEvent);
        }
        if (!bl) {
            return false;
        }
        long l2 = SystemClock.uptimeMillis();
        bl = false;
        for (n = 0; !bl && n < 4; ++n) {
            KeyEvent keyEvent = new KeyEvent(l2, l2, 1, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState());
            bl = uiController.injectKeyEvent(keyEvent);
        }
        return bl;
    }

    static Activity getCurrentActivity() {
        return (Activity)Iterables.getOnlyElement(ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED));
    }

    static void waitForStageChangeInitialActivity(UiController uiController, Activity activity) {
        if (KeyEventActionBase.isActivityResumed(activity)) {
            uiController.loopMainThreadForAtLeast(150L);
            if (KeyEventActionBase.isActivityResumed(activity)) {
                Log.i((String)TAG, (String)"Back was pressed but there was no Activity stage transition in 150ms. Pressing back may trigger an activity stage transition if the activity is finished as a result. However, the activity may handle the back behavior in any number of other ways internally as well, such as popping the fragment back stack, dismissing a dialog, otherwise manually transacting fragments, etc.");
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isActivityResumed(Activity activity) {
        if (ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity) != Stage.RESUMED) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void waitForPendingForegroundActivities(UiController uiController, boolean bl) {
        boolean bl2;
        ActivityLifecycleMonitor activityLifecycleMonitor;
        block5: {
            activityLifecycleMonitor = ActivityLifecycleMonitorRegistry.getInstance();
            boolean bl3 = false;
            for (int i = 0; i < 4; ++i) {
                uiController.loopMainThreadUntilIdle();
                bl3 = ActivityLifecycles.hasTransitioningActivities(activityLifecycleMonitor);
                if (bl3) {
                    uiController.loopMainThreadForAtLeast(150L);
                    continue;
                }
                bl2 = bl3;
                break block5;
            }
            bl2 = bl3;
        }
        if (!ActivityLifecycles.hasForegroundActivities(activityLifecycleMonitor)) {
            if (bl) {
                NoActivityResumedException noActivityResumedException = new NoActivityResumedException("Pressed back and killed the app");
                throw noActivityResumedException;
            }
            Log.w((String)TAG, (String)"Pressed back and hopped to a different process or potentially killed the app");
        }
        if (bl2) {
            Log.w((String)TAG, (String)"Back was pressed and left the application in an inconsistent state even after 600ms.");
            return;
        }
    }
}

