/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class GeneralSwipeAction
implements ViewAction {
    private static final int MAX_TRIES = 3;
    private static final int VIEW_DISPLAY_PERCENTAGE = 90;
    final CoordinatesProvider startCoordinatesProvider;
    final CoordinatesProvider endCoordinatesProvider;
    final Swiper swiper;
    final PrecisionDescriber precisionDescriber;

    public GeneralSwipeAction(Swiper swiper, CoordinatesProvider coordinatesProvider, CoordinatesProvider coordinatesProvider2, PrecisionDescriber precisionDescriber) {
        this.swiper = swiper;
        this.startCoordinatesProvider = coordinatesProvider;
        this.endCoordinatesProvider = coordinatesProvider2;
        this.precisionDescriber = precisionDescriber;
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayingAtLeast(90);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController object, View object2) {
        float[] fArray = this.startCoordinatesProvider.calculateCoordinates((View)object2);
        float[] fArray2 = this.endCoordinatesProvider.calculateCoordinates((View)object2);
        float[] fArray3 = this.precisionDescriber.describePrecision();
        Object object3 = Swiper.Status.FAILURE;
        for (int i = 0; i < 3 && object3 != Swiper.Status.SUCCESS; ++i) {
            try {
                object3 = this.swiper.sendSwipe((UiController)object, fArray, fArray2, fArray3);
            }
            catch (RuntimeException runtimeException) {
                object3 = new PerformException.Builder();
                throw ((PerformException.Builder)object3).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)object2)).withCause(runtimeException).build();
            }
            int n = ViewConfiguration.getPressedStateDuration();
            if (n <= 0) continue;
            object.loopMainThreadForAtLeast(n);
        }
        if (object3 == Swiper.Status.FAILURE) {
            object = new PerformException.Builder();
            object3 = this.getDescription();
            object = ((PerformException.Builder)object).withActionDescription((String)object3);
            object2 = HumanReadables.describe((View)object2);
            object = ((PerformException.Builder)object).withViewDescription((String)object2);
            object3 = Locale.ROOT;
            Object[] objectArray = new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray3[0]), Float.valueOf(fArray3[1]), this.swiper, this.startCoordinatesProvider, this.precisionDescriber, 3};
            object2 = new RuntimeException(String.format((Locale)object3, "Couldn't swipe from: %s,%s to: %s,%s precision: %s, %s . Swiper: %s start coordinate provider: %s precision describer: %s. Tried %s times", objectArray));
            throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
        }
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.swiper.toString().toLowerCase()).concat(" swipe");
    }
}

