/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Rect;
import android.view.View;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.TranslatedCoordinatesProvider;

public abstract class GeneralLocation
extends Enum<GeneralLocation>
implements CoordinatesProvider {
    public static final /* enum */ GeneralLocation TOP_LEFT;
    public static final /* enum */ GeneralLocation TOP_CENTER;
    public static final /* enum */ GeneralLocation TOP_RIGHT;
    public static final /* enum */ GeneralLocation CENTER_LEFT;
    public static final /* enum */ GeneralLocation CENTER;
    public static final /* enum */ GeneralLocation CENTER_RIGHT;
    public static final /* enum */ GeneralLocation BOTTOM_LEFT;
    public static final /* enum */ GeneralLocation BOTTOM_CENTER;
    public static final /* enum */ GeneralLocation BOTTOM_RIGHT;
    public static final /* enum */ GeneralLocation VISIBLE_CENTER;
    private static final /* synthetic */ GeneralLocation[] $VALUES;

    public static GeneralLocation[] values() {
        return (GeneralLocation[])$VALUES.clone();
    }

    public static GeneralLocation valueOf(String string) {
        return Enum.valueOf(GeneralLocation.class, string);
    }

    static CoordinatesProvider translate(CoordinatesProvider coordinatesProvider, float f, float f2) {
        TranslatedCoordinatesProvider translatedCoordinatesProvider = new TranslatedCoordinatesProvider(coordinatesProvider, f, f2);
        return translatedCoordinatesProvider;
    }

    private static float[] getCoordinates(View view, Position object, Position position) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n = nArray[0];
        int n2 = view.getWidth();
        float f = position.getPosition(n, n2);
        int n3 = nArray[1];
        int n4 = view.getHeight();
        float f2 = object.getPosition(n3, n4);
        object = new float[2];
        object[0] = (Position)f;
        object[1] = (Position)f2;
        return object;
    }

    private static float[] getCoordinatesOfVisiblePart(View view, Position position, Position position2) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        int n = nArray[0];
        int n2 = rect.width();
        float f = position2.getPosition(n, n2);
        int n3 = nArray[1];
        int n4 = rect.height();
        float f2 = position.getPosition(n3, n4);
        float[] fArray = new float[]{f, f2};
        return fArray;
    }

    static {
        GeneralLocation generalLocation;
        TOP_LEFT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.BEGIN);
            }
        };
        TOP_CENTER = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.MIDDLE);
            }
        };
        TOP_RIGHT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.END);
            }
        };
        CENTER_LEFT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.BEGIN);
            }
        };
        CENTER = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.MIDDLE);
            }
        };
        CENTER_RIGHT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.END);
            }
        };
        BOTTOM_LEFT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.END, Position.BEGIN);
            }
        };
        BOTTOM_CENTER = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.END, Position.MIDDLE);
            }
        };
        BOTTOM_RIGHT = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinates(view, Position.END, Position.END);
            }
        };
        VISIBLE_CENTER = generalLocation = new GeneralLocation(){

            @Override
            public float[] calculateCoordinates(View view) {
                return GeneralLocation.getCoordinatesOfVisiblePart(view, Position.MIDDLE, Position.MIDDLE);
            }
        };
        generalLocation = new GeneralLocation[]{TOP_LEFT, TOP_CENTER, TOP_RIGHT, CENTER_LEFT, CENTER, CENTER_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER, BOTTOM_RIGHT, VISIBLE_CENTER};
        $VALUES = generalLocation;
    }

    private static abstract class Position
    extends Enum<Position> {
        public static final /* enum */ Position BEGIN;
        public static final /* enum */ Position MIDDLE;
        public static final /* enum */ Position END;
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        abstract float getPosition(int var1, int var2);

        static {
            Position position;
            BEGIN = position = new Position(){

                @Override
                public float getPosition(int n, int n2) {
                    return n;
                }
            };
            MIDDLE = position = new Position(){

                @Override
                public float getPosition(int n, int n2) {
                    return (float)n + (float)(n2 + -1) / 2.0f;
                }
            };
            END = position = new Position(){

                @Override
                public float getPosition(int n, int n2) {
                    return n + n2 + -1;
                }
            };
            position = new Position[]{BEGIN, MIDDLE, END};
            $VALUES = position;
        }
    }
}

