/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class GeneralClickAction
implements ViewAction {
    private static final String TAG = "GeneralClickAction";
    final CoordinatesProvider coordinatesProvider;
    final Tapper tapper;
    final PrecisionDescriber precisionDescriber;
    private final Optional<ViewAction> rollbackAction;
    private final int inputDevice;
    private final int buttonState;

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, null);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int n, int n2) {
        this(tapper, coordinatesProvider, precisionDescriber, n, n2, null);
    }

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, ViewAction viewAction) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, viewAction);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int n, int n2, ViewAction viewAction) {
        this.coordinatesProvider = coordinatesProvider;
        this.tapper = tapper;
        this.precisionDescriber = precisionDescriber;
        this.inputDevice = n;
        this.buttonState = n2;
        this.rollbackAction = Optional.fromNullable(viewAction);
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher<View> matcher = ViewMatchers.isDisplayingAtLeast(90);
        if (this.rollbackAction.isPresent()) {
            return Matchers.allOf(matcher, this.rollbackAction.get().getConstraints());
        }
        return matcher;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController object, View object2) {
        Object[] objectArray;
        int n;
        float[] fArray = this.coordinatesProvider.calculateCoordinates((View)object2);
        float[] fArray2 = this.precisionDescriber.describePrecision();
        Object object3 = Tapper.Status.FAILURE;
        for (n = 0; object3 != Tapper.Status.SUCCESS && n < 3; ++n) {
            block14: {
                block13: {
                    int n2;
                    block12: {
                        objectArray = this.tapper.sendTap((UiController)object, fArray, fArray2, this.inputDevice, this.buttonState);
                        boolean bl = Log.isLoggable((String)TAG, (int)3);
                        if (!bl) break block12;
                        String string = TAG;
                        object3 = "perform: ";
                        Object object4 = Locale.ROOT;
                        String string2 = "%s - At Coordinates: %d, %d and precision: %d, %d";
                        Object[] objectArray2 = new Object[]{this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1]};
                        int n3 = ((String)(object4 = String.valueOf(String.format((Locale)object4, string2, objectArray2)))).length();
                        if (n3 != 0) {
                            object3 = object3.concat((String)object4);
                        } else {
                            object4 = new String((String)object3);
                            object3 = object4;
                        }
                        Log.d((String)string, (String)object3);
                    }
                    if ((n2 = ViewConfiguration.getPressedStateDuration()) > 0) {
                        object.loopMainThreadForAtLeast(n2);
                    }
                    if (objectArray != Tapper.Status.WARNING) break block13;
                    if (!this.rollbackAction.isPresent()) break block14;
                    this.rollbackAction.get().perform((UiController)object, (View)object2);
                }
                object3 = objectArray;
                continue;
            }
            object3 = objectArray;
            break;
        }
        if (object3 == Tapper.Status.FAILURE) {
            object = new PerformException.Builder();
            object3 = this.getDescription();
            object = ((PerformException.Builder)object).withActionDescription((String)object3);
            object2 = HumanReadables.describe(object2);
            object = ((PerformException.Builder)object).withViewDescription((String)object2);
            object3 = Locale.ROOT;
            objectArray = new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), this.tapper, this.coordinatesProvider, this.precisionDescriber, n, this.rollbackAction.isPresent()};
            object2 = new RuntimeException(String.format((Locale)object3, "Couldn't click at: %s,%s precision: %s, %s . Tapper: %s coordinate provider: %s precision describer: %s. Tried %s times. With Rollback? %s", objectArray));
            throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
        }
        if (this.tapper == Tap.SINGLE && object2 instanceof WebView) {
            object.loopMainThreadForAtLeast(ViewConfiguration.getDoubleTapTimeout());
            return;
        }
        return;
        catch (RuntimeException runtimeException) {
            object3 = new PerformException.Builder();
            Locale locale = Locale.ROOT;
            objectArray = new Object[]{this.getDescription(), (int)fArray[0], (int)fArray[1], (int)fArray2[0], (int)fArray2[1]};
            throw object3.withActionDescription(String.format(locale, "%s - At Coordinates: %d, %d and precision: %d, %d", objectArray)).withViewDescription(HumanReadables.describe(object2)).withCause(runtimeException).build();
        }
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.tapper.toString().toLowerCase()).concat(" click");
    }
}

