/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class CloseKeyboardAction
implements ViewAction {
    private static final int NUM_RETRIES = 3;
    private static final String TAG = CloseKeyboardAction.class.getSimpleName();

    @RemoteMsgConstructor
    public CloseKeyboardAction() {
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.any(View.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(UiController object, View view) {
        int n = 0;
        while (n < 3) {
            try {
                this.tryToCloseKeyboard(view, (UiController)object);
                return;
            }
            catch (TimeoutException timeoutException) {
                Log.w((String)TAG, (String)"Caught timeout exception. Retrying.");
                if (n == 2) {
                    object = new PerformException.Builder();
                    throw ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(timeoutException).build();
                }
                ++n;
            }
        }
    }

    private void tryToCloseKeyboard(View object, UiController idlingResourceArray) throws TimeoutException {
        Object object2;
        CloseKeyboardIdlingResult closeKeyboardIdlingResult;
        block7: {
            block6: {
                InputMethodManager inputMethodManager = (InputMethodManager)CloseKeyboardAction.getRootActivity((UiController)idlingResourceArray).getSystemService("input_method");
                Handler handler = new Handler(Looper.getMainLooper());
                closeKeyboardIdlingResult = new CloseKeyboardIdlingResult(handler);
                handler = IdlingRegistry.getInstance();
                IdlingResource[] idlingResourceArray2 = new IdlingResource[]{closeKeyboardIdlingResult};
                handler.register(idlingResourceArray2);
                try {
                    boolean bl = inputMethodManager.hideSoftInputFromWindow(object.getWindowToken(), 0, (ResultReceiver)closeKeyboardIdlingResult);
                    if (bl) break block6;
                }
                catch (Throwable throwable) {
                    object = IdlingRegistry.getInstance();
                    idlingResourceArray = new IdlingResource[]{closeKeyboardIdlingResult};
                    object.unregister(idlingResourceArray);
                    throw throwable;
                }
                Log.w((String)TAG, (String)"Attempting to close soft keyboard, while it is not shown.");
                object2 = IdlingRegistry.getInstance();
                object = new IdlingResource[]{closeKeyboardIdlingResult};
                object2.unregister(object);
                return;
            }
            closeKeyboardIdlingResult.scheduleTimeout(2000L);
            idlingResourceArray.loopMainThreadUntilIdle();
            boolean bl = closeKeyboardIdlingResult.timedOut;
            if (!bl) break block7;
            object2 = new TimeoutException("Wait on operation result timed out.");
            throw object2;
        }
        IdlingRegistry idlingRegistry = IdlingRegistry.getInstance();
        Object object3 = new IdlingResource[]{closeKeyboardIdlingResult};
        idlingRegistry.unregister((IdlingResource[])object3);
        if (closeKeyboardIdlingResult.result != 1 && closeKeyboardIdlingResult.result != 3) {
            int n = closeKeyboardIdlingResult.result;
            object3 = new StringBuilder(105);
            String string = ((StringBuilder)object3).append("Attempt to close the soft keyboard did not result in soft keyboard to be hidden. resultCode = ").append(n).toString();
            Log.e((String)TAG, (String)string);
            object3 = new PerformException.Builder();
            object2 = ((CloseKeyboardAction)object2).getDescription();
            object2 = ((PerformException.Builder)object3).withActionDescription((String)object2);
            object = HumanReadables.describe((View)object);
            object2 = ((PerformException.Builder)object2).withViewDescription((String)object);
            object = new RuntimeException(string);
            throw ((PerformException.Builder)object2).withCause((Throwable)object).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Activity getRootActivity(UiController object) {
        Collection collection = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (collection.isEmpty()) {
            object.loopMainThreadUntilIdle();
            object = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        } else {
            object = collection;
        }
        boolean bl = object.size() == 1;
        Preconditions.checkState(bl, "More than one activity is in RESUMED stage. There may have been an error during the activity creation/startup process, please check your logs.");
        return (Activity)Iterables.getOnlyElement(object);
    }

    @Override
    public String getDescription() {
        return "close keyboard";
    }

    private static class CloseKeyboardIdlingResult
    extends ResultReceiver
    implements IdlingResource {
        private IdlingResource.ResourceCallback resourceCallback;
        private boolean receivedResult = false;
        private int result = -1;
        private boolean timedOut = false;
        private boolean idle = false;
        private final Handler handler;

        private CloseKeyboardIdlingResult(Handler handler) {
            super(handler);
            this.handler = handler;
        }

        private void scheduleTimeout(long l) {
            Handler handler = this.handler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!receivedResult) {
                        CloseKeyboardIdlingResult.access$202(this, true);
                        if (resourceCallback != null) {
                            resourceCallback.onTransitionToIdle();
                            return;
                        }
                    }
                }
            };
            handler.postDelayed(runnable, l);
        }

        private void notifyEspresso(long l) {
            Preconditions.checkState(this.receivedResult);
            Handler handler = this.handler;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CloseKeyboardIdlingResult.access$602(this, true);
                    if (resourceCallback != null) {
                        resourceCallback.onTransitionToIdle();
                        return;
                    }
                }
            };
            handler.postDelayed(runnable, l);
        }

        protected void onReceiveResult(int n, Bundle bundle) {
            this.result = n;
            this.receivedResult = true;
            this.notifyEspresso(300L);
        }

        public String getName() {
            return "CloseKeyboardIdlingResource";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isIdleNow() {
            if (this.idle) {
                return true;
            }
            if (this.timedOut) return true;
            return false;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
            this.resourceCallback = resourceCallback;
        }

        static /* synthetic */ boolean access$202(CloseKeyboardIdlingResult closeKeyboardIdlingResult, boolean bl) {
            closeKeyboardIdlingResult.timedOut = bl;
            return bl;
        }

        static /* synthetic */ boolean access$602(CloseKeyboardIdlingResult closeKeyboardIdlingResult, boolean bl) {
            closeKeyboardIdlingResult.idle = bl;
            return bl;
        }
    }
}

