/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.AdapterViewFlipper;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Range;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import java.util.ArrayList;

public final class AdapterViewProtocols {
    private static final int FULLY_RENDERED_PERCENTAGE_CUTOFF = 90;
    private static final AdapterViewProtocol STANDARD_PROTOCOL;

    private AdapterViewProtocols() {
    }

    public static AdapterViewProtocol standardProtocol() {
        return STANDARD_PROTOCOL;
    }

    static {
        StandardAdapterViewProtocol standardAdapterViewProtocol = new StandardAdapterViewProtocol();
        STANDARD_PROTOCOL = standardAdapterViewProtocol;
    }

    private static final class StandardAdapterViewProtocol
    implements AdapterViewProtocol {
        private static final String TAG = "StdAdapterViewProtocol";

        @Override
        public Iterable<AdapterViewProtocol.AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> adapterView) {
            ArrayList<AdapterViewProtocol.AdaptedData> arrayList = Lists.newArrayList();
            for (int i = 0; i < adapterView.getCount(); ++i) {
                Object object = adapterView.getItemAtPosition(i);
                AdapterViewProtocol.AdaptedData.Builder builder = new AdapterViewProtocol.AdaptedData.Builder();
                StandardDataFunction standardDataFunction = new StandardDataFunction(object, i);
                arrayList.add(builder.withDataFunction(standardDataFunction).withOpaqueToken(i).build());
            }
            return arrayList;
        }

        @Override
        public EspressoOptional<AdapterViewProtocol.AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> adapterView, View object) {
            int n;
            if (adapterView == object.getParent() && (n = adapterView.getPositionForView((View)object)) != -1) {
                object = new AdapterViewProtocol.AdaptedData.Builder();
                StandardDataFunction standardDataFunction = new StandardDataFunction(adapterView.getItemAtPosition(n), n);
                return EspressoOptional.of(((AdapterViewProtocol.AdaptedData.Builder)object).withDataFunction(standardDataFunction).withOpaqueToken(n).build());
            }
            return EspressoOptional.absent();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            boolean bl;
            Preconditions.checkArgument(adaptedData.opaqueToken instanceof Integer, "Not my data: %s", adaptedData);
            int n = (Integer)adaptedData.opaqueToken;
            if (Build.VERSION.SDK_INT > 7) {
                if (adapterView instanceof AbsListView) {
                    if (Build.VERSION.SDK_INT > 10) {
                        ((AbsListView)adapterView).smoothScrollToPositionFromTop(n, adapterView.getPaddingTop(), 0);
                    } else {
                        ((AbsListView)adapterView).smoothScrollToPosition(n);
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                if (Build.VERSION.SDK_INT > 10 && adapterView instanceof AdapterViewAnimator) {
                    if (adapterView instanceof AdapterViewFlipper) {
                        ((AdapterViewFlipper)adapterView).stopFlipping();
                    }
                    ((AdapterViewAnimator)adapterView).setDisplayedChild(n);
                    return;
                }
            } else {
                bl = false;
            }
            if (bl) return;
            adapterView.setSelection(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            Preconditions.checkArgument(adaptedData.opaqueToken instanceof Integer, "Not my data: %s", adaptedData);
            int n = (Integer)adaptedData.opaqueToken;
            if (!Range.closed(adapterView.getFirstVisiblePosition(), adapterView.getLastVisiblePosition()).contains(n)) return false;
            boolean bl = adapterView.getFirstVisiblePosition() == adapterView.getLastVisiblePosition() ? true : this.isElementFullyRendered(adapterView, n - adapterView.getFirstVisiblePosition());
            if (!bl) return bl;
            adapterView.setSelection(n);
            return bl;
        }

        private boolean isElementFullyRendered(AdapterView<? extends Adapter> adapterView, int n) {
            StandardAdapterViewProtocol standardAdapterViewProtocol = adapterView.getChildAt(n);
            return ViewMatchers.isDisplayingAtLeast(90).matches((Object)standardAdapterViewProtocol);
        }

        private static final class StandardDataFunction
        implements AdapterViewProtocol.DataFunction {
            private final Object dataAtPosition;
            private final int position;

            /*
             * Enabled aggressive block sorting
             */
            private StandardDataFunction(Object object, int n) {
                boolean bl = n >= 0;
                Preconditions.checkArgument(bl, "position must be >= 0");
                this.dataAtPosition = object;
                this.position = n;
            }

            @Override
            public Object getData() {
                if (this.dataAtPosition instanceof Cursor && !((Cursor)this.dataAtPosition).moveToPosition(this.position)) {
                    int n = this.position;
                    StringBuilder stringBuilder = new StringBuilder(43);
                    Log.e((String)StandardAdapterViewProtocol.TAG, (String)stringBuilder.append("Cannot move cursor to position: ").append(n).toString());
                }
                return this.dataAtPosition;
            }
        }
    }
}

