/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;

public interface AdapterViewProtocol {
    public Iterable<AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> var1);

    public EspressoOptional<AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> var1, View var2);

    public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public static class AdaptedData {
        @Deprecated
        public final Object data;
        public final Object opaqueToken;
        private final DataFunction dataFunction;

        public Object getData() {
            return this.dataFunction.getData();
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            Object object = this.getData();
            String string = object != null ? object.getClass().getName() : "null";
            if (object instanceof Cursor) {
                object = HumanReadables.describe((Cursor)object);
            }
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{object, string, this.opaqueToken};
            return String.format(locale, "Data: %s (class: %s) token: %s", objectArray);
        }

        private AdaptedData(Object object, Object object2, DataFunction dataFunction) {
            this.data = object;
            this.opaqueToken = Preconditions.checkNotNull(object2);
            this.dataFunction = Preconditions.checkNotNull(dataFunction);
        }

        public static class Builder {
            private Object data;
            private Object opaqueToken;
            private DataFunction dataFunction;

            public Builder withDataFunction(DataFunction dataFunction) {
                this.dataFunction = dataFunction;
                return this;
            }

            public Builder withData(Object object) {
                this.data = object;
                return this;
            }

            public Builder withOpaqueToken(Object object) {
                this.opaqueToken = object;
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public AdaptedData build() {
                if (this.dataFunction != null) {
                    this.data = this.dataFunction.getData();
                    return new AdaptedData(this.data, this.opaqueToken, this.dataFunction);
                }
                DataFunction dataFunction = new DataFunction(){

                    @Override
                    public Object getData() {
                        return data;
                    }
                };
                this.dataFunction = dataFunction;
                return new AdaptedData(this.data, this.opaqueToken, this.dataFunction);
            }
        }
    }

    public static interface DataFunction {
        public Object getData();
    }
}

