/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.InteractionResultsHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewInteraction {
    private static final String TAG = ViewInteraction.class.getSimpleName();
    private final InterruptableUiController uiController;
    private final ViewFinder viewFinder;
    private final Executor mainThreadExecutor;
    private final ControlledLooper controlledLooper;
    private volatile FailureHandler failureHandler;
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcherRef;
    private final AtomicReference<Boolean> needsActivity;
    private final RemoteInteraction remoteInteraction;
    private final ListeningExecutorService remoteExecutor;
    private boolean hasRootMatcher = false;

    ViewInteraction(UiController uiController, ViewFinder viewFinder, @MainThread Executor executor, FailureHandler failureHandler, Matcher<View> matcher, AtomicReference<Matcher<Root>> atomicReference, AtomicReference<Boolean> atomicReference2, RemoteInteraction remoteInteraction, ListeningExecutorService listeningExecutorService, ControlledLooper controlledLooper) {
        this.viewFinder = Preconditions.checkNotNull(viewFinder);
        this.uiController = (InterruptableUiController)Preconditions.checkNotNull(uiController);
        this.failureHandler = Preconditions.checkNotNull(failureHandler);
        this.mainThreadExecutor = Preconditions.checkNotNull(executor);
        this.viewMatcher = Preconditions.checkNotNull(matcher);
        this.rootMatcherRef = Preconditions.checkNotNull(atomicReference);
        this.needsActivity = Preconditions.checkNotNull(atomicReference2);
        this.remoteInteraction = Preconditions.checkNotNull(remoteInteraction);
        this.remoteExecutor = Preconditions.checkNotNull(listeningExecutorService);
        this.controlledLooper = Preconditions.checkNotNull(controlledLooper);
    }

    public ViewInteraction perform(ViewAction ... viewActionArray) {
        Preconditions.checkNotNull(viewActionArray);
        for (ViewAction viewAction : viewActionArray) {
            SingleExecutionViewAction singleExecutionViewAction = new SingleExecutionViewAction(viewAction, this.viewMatcher);
            this.desugaredPerform(singleExecutionViewAction);
        }
        return this;
    }

    private static Map<String, IBinder> getIBindersFromBindables(List<Bindable> object) {
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        object = object.iterator();
        while (object.hasNext()) {
            Bindable bindable = (Bindable)object.next();
            hashMap.put(Preconditions.checkNotNull(bindable.getId(), "Bindable id cannot be null!"), Preconditions.checkNotNull(bindable.getIBinder(), "Bindable binder cannot be null!"));
        }
        return ImmutableMap.copyOf(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Bindable> getBindables(Object ... objectArray) {
        ArrayList<Bindable> arrayList = Lists.newArrayListWithCapacity(objectArray.length);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Bindable) {
                arrayList.add((Bindable)object);
            }
            ++n2;
        }
        return arrayList;
    }

    private static Map<String, IBinder> getIBindersFromViewActions(ViewAction ... viewActionArray) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewActionArray));
    }

    private static Map<String, IBinder> getIBindersFromViewAssertions(ViewAssertion ... viewAssertionArray) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewAssertionArray));
    }

    private void desugaredPerform(SingleExecutionViewAction object) {
        Callable<Void> callable = new Callable<Void>((SingleExecutionViewAction)object){
            final /* synthetic */ SingleExecutionViewAction val$va;
            {
                this.val$va = singleExecutionViewAction;
            }

            @Override
            public Void call() {
                ViewInteraction.this.doPerform(this.val$va);
                return null;
            }
        };
        ViewAction viewAction = ((SingleExecutionViewAction)object).getInnerViewAction();
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            callable = this.remoteExecutor;
            RemoteInteraction remoteInteraction = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAction[] viewActionArray = new ViewAction[]{object, viewAction};
            object = ViewInteraction.getIBindersFromViewActions(viewActionArray);
            viewActionArray = new ViewAction[]{viewAction};
            arrayList.add(callable.submit(remoteInteraction.createRemotePerformCallable((Matcher<Root>)matcher, matcher2, (Map<String, IBinder>)object, viewActionArray)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
    }

    public ViewInteraction withFailureHandler(FailureHandler failureHandler) {
        this.failureHandler = Preconditions.checkNotNull(failureHandler);
        return this;
    }

    public ViewInteraction inRoot(Matcher<Root> matcher) {
        this.hasRootMatcher = true;
        this.rootMatcherRef.set(Preconditions.checkNotNull(matcher));
        return this;
    }

    public ViewInteraction noActivity() {
        if (!this.hasRootMatcher) {
            this.rootMatcherRef.set((Matcher<Root>)Matchers.anyOf(RootMatchers.DEFAULT, (Matcher)Matchers.allOf(RootMatchers.hasWindowLayoutParams(), RootMatchers.isSystemAlertWindow())));
        }
        this.needsActivity.set(false);
        return this;
    }

    private void doPerform(SingleExecutionViewAction object) {
        Preconditions.checkNotNull(object);
        Object object2 = Preconditions.checkNotNull(((SingleExecutionViewAction)object).getConstraints());
        ((ViewInteraction)object3).uiController.loopMainThreadUntilIdle();
        View view = ((ViewInteraction)object3).viewFinder.getView();
        String string = TAG;
        Serializable serializable = Locale.ROOT;
        Object[] objectArray = new Object[]{((SingleExecutionViewAction)object).getDescription(), ((ViewInteraction)object3).viewMatcher};
        Log.i((String)string, (String)String.format(serializable, "Performing '%s' action on view %s", objectArray));
        if (!object2.matches((Object)view)) {
            serializable = new StringBuilder("Action will not be performed because the target view does not match one or more of the following constraints:\n");
            string = new StringDescription((Appendable)((Object)serializable));
            object2.describeTo((Description)string);
            string.appendText("\nTarget view: ").appendValue((Object)HumanReadables.describe(view));
            if (((SingleExecutionViewAction)object).getInnerViewAction() instanceof ScrollToAction && ViewMatchers.isDescendantOfA(ViewMatchers.isAssignableFrom(AdapterView.class)).matches((Object)view)) {
                string.appendText("\nFurther Info: ScrollToAction on a view inside an AdapterView will not work. Use Espresso.onData to load the view.");
            }
            object2 = new PerformException.Builder();
            object = ((SingleExecutionViewAction)object).getDescription();
            object = ((PerformException.Builder)object2).withActionDescription((String)object);
            Object object3 = ((ViewInteraction)object3).viewMatcher;
            object3 = object3.toString();
            object3 = ((PerformException.Builder)object).withViewDescription((String)object3);
            object = new RuntimeException(string.toString());
            throw ((PerformException.Builder)object3).withCause((Throwable)object).build();
        }
        ((SingleExecutionViewAction)object).perform(((ViewInteraction)object3).uiController, view);
    }

    public ViewInteraction check(final ViewAssertion viewAssertion) {
        Preconditions.checkNotNull(viewAssertion);
        final SingleExecutionViewAssertion singleExecutionViewAssertion = new SingleExecutionViewAssertion(viewAssertion);
        Callable<Void> callable = new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                NoMatchingViewException noMatchingViewException;
                View view;
                ViewInteraction.this.uiController.loopMainThreadUntilIdle();
                try {
                    view = ViewInteraction.this.viewFinder.getView();
                    noMatchingViewException = null;
                }
                catch (NoMatchingViewException noMatchingViewException2) {
                    view = null;
                }
                String string = TAG;
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{viewAssertion, ViewInteraction.this.viewMatcher};
                Log.i((String)string, (String)String.format(locale, "Checking '%s' assertion on view %s", objectArray));
                singleExecutionViewAssertion.check(view, noMatchingViewException);
                return null;
            }
        };
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            callable = this.remoteExecutor;
            RemoteInteraction remoteInteraction = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAssertion[] viewAssertionArray = new ViewAssertion[]{singleExecutionViewAssertion, viewAssertion};
            arrayList.add(callable.submit(remoteInteraction.createRemoteCheckCallable((Matcher<Root>)matcher, matcher2, ViewInteraction.getIBindersFromViewAssertions(viewAssertionArray), viewAssertion)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
        return this;
    }

    private ListenableFuture<Void> postAsynchronouslyOnUiThread(Callable<Void> object) {
        object = ListenableFutureTask.create(object);
        this.mainThreadExecutor.execute((Runnable)object);
        return object;
    }

    private void waitForAndHandleInteractionResults(List<ListenableFuture<Void>> list) {
        try {
            this.controlledLooper.drainMainThreadUntilIdle();
            InteractionResultsHandler.gatherAnyResult(list);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.failureHandler.handle(runtimeException, this.viewMatcher);
            return;
        }
        catch (Error error) {
            this.failureHandler.handle(error, this.viewMatcher);
        }
        finally {
            this.uiController.interruptEspressoTasks();
        }
    }

    private static final class SingleExecutionViewAssertion
    implements ViewAssertion,
    Bindable {
        final ViewAssertion viewAssertion;
        private IInteractionExecutionStatus assertionExecutionStatus;

        private SingleExecutionViewAssertion(ViewAssertion viewAssertion) {
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.assertionExecutionStatus = stub;
            this.viewAssertion = viewAssertion;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void check(View object, NoMatchingViewException noMatchingViewException) {
            try {
                boolean bl = ((SingleExecutionViewAssertion)object2).assertionExecutionStatus.canExecute();
                if (!bl) {
                    object = TAG;
                    Object object2 = String.valueOf(((SingleExecutionViewAssertion)object2).viewAssertion);
                    int n = String.valueOf(object2).length();
                    StringBuilder stringBuilder = new StringBuilder(n += 66);
                    object2 = stringBuilder.append("Attempted to execute a Single Execution Assertion more then once: ").append((String)object2).toString();
                    Object[] objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)object, (String)object2, (Object[])objectArray);
                    return;
                }
                ((SingleExecutionViewAssertion)object2).viewAssertion.check((View)object, noMatchingViewException);
                return;
            }
            catch (RemoteException remoteException) {
                object = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw object;
            }
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.assertionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder iBinder) {
            this.assertionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(iBinder);
        }
    }

    private static final class SingleExecutionViewAction
    implements ViewAction,
    Bindable {
        final ViewAction viewAction;
        final Matcher<View> viewMatcher;
        private IInteractionExecutionStatus actionExecutionStatus;

        private SingleExecutionViewAction(ViewAction viewAction, Matcher<View> matcher) {
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.actionExecutionStatus = stub;
            this.viewAction = viewAction;
            this.viewMatcher = matcher;
        }

        @Override
        public Matcher<View> getConstraints() {
            return this.viewAction.getConstraints();
        }

        @Override
        public String getDescription() {
            return this.viewAction.getDescription();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void perform(UiController object, View object2) {
            try {
                int n = ((SingleExecutionViewAction)object4).actionExecutionStatus.canExecute();
                if (n == 0) {
                    object = TAG;
                    object2 = String.valueOf(((SingleExecutionViewAction)object4).viewAction);
                    n = String.valueOf(object2).length();
                    StringBuilder stringBuilder = new StringBuilder(n += 63);
                    object2 = stringBuilder.append("Attempted to execute a Single Execution Action more then once: ").append((String)object2).toString();
                    Object[] objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)object, (String)object2, (Object[])objectArray);
                    return;
                }
                ((SingleExecutionViewAction)object4).viewAction.perform((UiController)object, (View)object2);
                return;
            }
            catch (RemoteException remoteException) {
                object2 = new PerformException.Builder();
                Object object3 = ((SingleExecutionViewAction)object4).viewAction;
                object3 = object3.getDescription();
                object2 = ((PerformException.Builder)object2).withActionDescription((String)object3);
                Object object4 = ((SingleExecutionViewAction)object4).viewMatcher;
                object4 = object4.toString();
                object4 = ((PerformException.Builder)object2).withViewDescription((String)object4);
                object2 = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw ((PerformException.Builder)object4).withCause((Throwable)object2).build();
            }
        }

        ViewAction getInnerViewAction() {
            return this.viewAction;
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.actionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder iBinder) {
            this.actionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(iBinder);
        }
    }
}

