/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.WindowManager;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;

public final class Root {
    private final View decorView;
    private final EspressoOptional<WindowManager.LayoutParams> windowLayoutParams;

    private Root(Builder builder) {
        this.decorView = Preconditions.checkNotNull(builder.decorView);
        this.windowLayoutParams = EspressoOptional.fromNullable(builder.windowLayoutParams);
    }

    public View getDecorView() {
        return this.decorView;
    }

    public EspressoOptional<WindowManager.LayoutParams> getWindowLayoutParams() {
        return this.windowLayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReady() {
        if (this.decorView.isLayoutRequested()) return false;
        int n = this.windowLayoutParams.get().flags;
        if (this.decorView.hasWindowFocus()) return true;
        if ((n & 8) != 8) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("application-window-token", this.decorView.getApplicationWindowToken()).add("window-token", this.decorView.getWindowToken()).add("has-window-focus", this.decorView.hasWindowFocus());
        if (this.windowLayoutParams.isPresent()) {
            toStringHelper.add("layout-params-type", this.windowLayoutParams.get().type).add("layout-params-string", this.windowLayoutParams.get());
        }
        toStringHelper.add("decor-view-string", HumanReadables.describe(this.decorView));
        return toStringHelper.toString();
    }

    public static class Builder {
        private View decorView;
        private WindowManager.LayoutParams windowLayoutParams;

        public Root build() {
            Root root = new Root(this);
            return root;
        }

        public Builder withDecorView(View view) {
            this.decorView = view;
            return this;
        }

        public Builder withWindowLayoutParams(WindowManager.LayoutParams layoutParams) {
            this.windowLayoutParams = layoutParams;
            return this;
        }
    }
}

