/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class NoMatchingViewException
extends RuntimeException
implements EspressoException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private List<View> adapterViews = Lists.newArrayList();
    private boolean includeViewHierarchy = true;
    private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();

    private NoMatchingViewException(String string) {
        super(string);
    }

    private NoMatchingViewException(Builder builder) {
        super(NoMatchingViewException.getErrorMessage(builder), builder.cause);
        this.viewMatcher = builder.viewMatcher;
        this.rootView = builder.rootView;
        this.adapterViews = builder.adapterViews;
        this.adapterViewWarning = builder.adapterViewWarning;
        this.includeViewHierarchy = builder.includeViewHierarchy;
    }

    public String getViewMatcherDescription() {
        if (this.viewMatcher != null) {
            return this.viewMatcher.toString();
        }
        return "unknown";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getErrorMessage(Builder object) {
        if (((Builder)object).includeViewHierarchy) {
            Object object2 = Locale.ROOT;
            Object object3 = new Object[]{((Builder)object).viewMatcher};
            object2 = String.format((Locale)object2, "No views in hierarchy found matching: %s", (Object[])object3);
            if (!((Builder)object).adapterViewWarning.isPresent()) return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
            object2 = String.valueOf(object2);
            object3 = String.valueOf((String)((Builder)object).adapterViewWarning.get());
            if (((String)object3).length() == 0) {
                object2 = object3 = new String((String)object2);
                return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
            }
            object2 = ((String)object2).concat((String)object3);
            return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)object).viewMatcher};
        return String.format(locale, "Could not find a view that matches %s", objectArray);
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private List<View> adapterViews = Lists.newArrayList();
        private boolean includeViewHierarchy = true;
        private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();
        private Throwable cause;

        public Builder from(NoMatchingViewException noMatchingViewException) {
            this.viewMatcher = noMatchingViewException.viewMatcher;
            this.rootView = noMatchingViewException.rootView;
            this.adapterViews = noMatchingViewException.adapterViews;
            this.adapterViewWarning = noMatchingViewException.adapterViewWarning;
            this.includeViewHierarchy = noMatchingViewException.includeViewHierarchy;
            return this;
        }

        public Builder withViewMatcher(Matcher<? super View> matcher) {
            this.viewMatcher = matcher;
            return this;
        }

        public Builder withRootView(View view) {
            this.rootView = view;
            return this;
        }

        public Builder withAdapterViews(List<View> list) {
            this.adapterViews = list;
            return this;
        }

        public Builder includeViewHierarchy(boolean bl) {
            this.includeViewHierarchy = bl;
            return this;
        }

        public Builder withAdapterViewWarning(EspressoOptional<String> espressoOptional) {
            this.adapterViewWarning = espressoOptional;
            return this;
        }

        public Builder withCause(Throwable throwable) {
            this.cause = throwable;
            return this;
        }

        public NoMatchingViewException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.adapterViews);
            Preconditions.checkNotNull(this.adapterViewWarning);
            NoMatchingViewException noMatchingViewException = new NoMatchingViewException(this);
            return noMatchingViewException;
        }
    }
}

