/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.remote.NoRemoteEspressoInstanceException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

final class InteractionResultsHandler {
    private static final String TAG = "InteractionResultsHandl";
    private static final int LOCAL_OR_REMOTE_ERROR_PRIORITY = Integer.MAX_VALUE;

    private InteractionResultsHandler() {
    }

    static <T> T gatherAnyResult(List<ListenableFuture<T>> list) {
        return InteractionResultsHandler.gatherAnyResult(list, MoreExecutors.directExecutor());
    }

    /*
     * Exception decompiling
     */
    static <T> T gatherAnyResult(List<ListenableFuture<T>> var0, Executor var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T> T finalResult(ExecutionResult<T> object) {
        if (((ExecutionResult)object).isSuccess()) {
            return ((ExecutionResult)object).getResult();
        }
        Throwable throwable = ((ExecutionResult)object).getFailure();
        if (throwable instanceof ExecutionException) {
            if ((throwable = throwable.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        } else {
            if (throwable instanceof InterruptedException) {
                object = new IllegalStateException("Interrupted while interacting remotely", throwable);
                throw object;
            }
            object = new RuntimeException("Error interacting remotely", throwable);
            throw object;
        }
        if (!(throwable instanceof Error)) {
            throwable = new RuntimeException("Unknown error during interactions", ((ExecutionResult)object).getFailure());
            throw throwable;
        }
        throw (Error)throwable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> ExecutionResult<T> adaptResult(Future<T> executionResult) {
        boolean bl;
        try {
            Preconditions.checkState(executionResult.isDone());
            return ExecutionResult.success(executionResult.get());
        }
        catch (ExecutionException executionException) {
            if (InteractionResultsHandler.getPriority(executionException) == Integer.MAX_VALUE) {
                bl = true;
                return ExecutionResult.error(executionException, bl);
            }
        }
        catch (InterruptedException interruptedException) {
            return ExecutionResult.error(interruptedException);
        }
        catch (RuntimeException runtimeException) {
            return ExecutionResult.error(runtimeException);
        }
        catch (Error error) {
            return ExecutionResult.error(error);
        }
        bl = false;
        return ExecutionResult.error(executionException, bl);
    }

    private static <T> ExecutionResult<T> pickResult(ExecutionResult<T> executionResult, ExecutionResult<T> executionResult2) {
        if (executionResult2 == null) {
            return executionResult;
        }
        if (executionResult == null) {
            return executionResult2;
        }
        if (executionResult.isSuccess()) {
            return executionResult;
        }
        if (executionResult2.isSuccess()) {
            return executionResult2;
        }
        if (InteractionResultsHandler.getPriority(executionResult.getFailure()) > InteractionResultsHandler.getPriority(executionResult2.getFailure())) {
            return executionResult;
        }
        return executionResult2;
    }

    private static int getPriority(Throwable throwable) {
        if (throwable == null) {
            return Integer.MIN_VALUE;
        }
        if (!(throwable instanceof ExecutionException)) {
            return -2147483647;
        }
        if (throwable.getCause() instanceof NoRemoteEspressoInstanceException) {
            return 0;
        }
        if (throwable.getCause() instanceof NoActivityResumedException) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static class ExecutionResult<T> {
        private final T result;
        private final boolean success;
        private final Throwable failure;
        private final boolean priority;

        private ExecutionResult(T t, boolean bl, Throwable throwable, boolean bl2) {
            this.result = t;
            this.success = bl;
            this.failure = throwable;
            this.priority = bl2;
        }

        public T getResult() {
            Preconditions.checkState(this.success);
            return this.result;
        }

        public boolean isPriority() {
            return this.priority;
        }

        public boolean isSuccess() {
            return this.success;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Throwable getFailure() {
            boolean bl = !this.success;
            Preconditions.checkState(bl);
            return this.failure;
        }

        public static <T> ExecutionResult<T> success(T t) {
            ExecutionResult<T> executionResult = new ExecutionResult<T>(t, true, null, true);
            return executionResult;
        }

        public static <T> ExecutionResult<T> error(Throwable throwable) {
            return ExecutionResult.error(throwable, false);
        }

        public static <T> ExecutionResult<T> error(Throwable throwable, boolean bl) {
            ExecutionResult<Object> executionResult = new ExecutionResult<Object>(null, false, throwable, bl);
            return executionResult;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("priority", this.priority).add("success", this.success).add("result", this.result).add("failure", this.failure).toString();
        }
    }
}

